/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef TOOLS_H
#define TOOLS_H

#include <qwidget.h>
#include <kprocess.h>
#include <kconfig.h>
#include <tools_gui.h>
#include "processoutput.h"

/**
  *@author Kai Heitkamp
  */

class Tools : public Tools_GUI  {
   Q_OBJECT

public:
	Tools(QWidget *parent=0, const char *name=0);
	~Tools();

	QString cdrecord;

protected:
	KProcess process;
	ProcessOutput procoutdlg;
	KConfig *config;

protected slots:
	void slot_start();
	void slot_deviceReset();
	void slot_quit();
	void slotRecStderr( KProcess *proc, char *buffer, int buflen );
	void slotProcessExited( KProcess *rcproc );
	void abort_handler();
};

#endif
