/* $Id: misc.h,v 1.2 1999/05/31 21:16:27 marcus Exp $
******************************************************************************

   LibGGI Misc extension API header file

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_MISC_H
#define _GGI_MISC_H

#include <ggi/ggi.h>

__BEGIN_DECLS

int ggiMiscInit(void);
int ggiMiscExit(void);

int ggiMiscAttach(ggi_visual_t vis);
int ggiMiscDetach(ggi_visual_t vis);

int ggiSetSplitline(ggi_visual_t vis, int y);


#define GGI_RP_BORDER   (1<<27)
#define GGI_RP_BLANK    (1<<28)
#define GGI_RP_SYNC     (1<<29)
#define GGI_RP_DONTCARE (1<<30)

int ggiGetRayPos (ggi_visual_t vis, sint32 *x, sint32 *y);
int ggiWaitRayPos(ggi_visual_t vis, sint32 *x, sint32 *y);

__END_DECLS

#endif /* _GGI_MISC_H */
