/* $Id: init.c,v 1.5 2000/04/24 17:43:19 marcus Exp $
******************************************************************************

   Misc extension initialization.

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "misc_int.h"

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
EXPORTVAR ggi_extid ggiMiscID = -1;


static int dummyfunc(void) { return -1; }

static void clearfuncs(miscext *ext)
{
	ext->setsplitline = (void*) dummyfunc;
	ext->getraypos    = (void*) dummyfunc;
	ext->waitraypos   = (void*) dummyfunc;
}

static int changed(ggi_visual_t vis,int whatchanged)
{
	GGIDPRINT("changed(%p, %i) called for misc extension\n",
		  vis, whatchanged);

	switch (whatchanged) {
		case GGI_CHG_APILIST: {
			int temp;
			char api[256],args[256];
			int err;
			GGIDPRINT("changed() APILIST \n");

			clearfuncs(LIBGGI_MISCEXT(vis));
			for(temp=0; ggiGetAPI(vis,temp,api,args)==0; temp++) {
				strcat(api, "-misc");
				GGIDPRINT("Trying #%d: %s(%s)\n",
					  temp, api, args);
				err = _ggiAddDL(vis, api, args, NULL,
						GGI_DLTYPE_EXTENSION);
				GGIDPRINT("Loaded #%d: %s(%s) : %d\n",
					  temp, api, args, err);
			}
		}
		break;
	}
                                
	return 0;
}


int ggiMiscInit(void)
{
	ggiMiscID = ggiExtensionRegister("GGIMisc", sizeof(miscext), changed);
	GGIDPRINT("Initialized Misc extension. ID: %i\n",ggiMiscID);

	return ggiMiscID >= 0 ? 0 : -1;
}


int ggiMiscExit(void)
{
	int rc;

	rc = ggiExtensionUnregister(ggiMiscID);
	GGIDPRINT("DeInitailized Misc extension. rc=%i\n", rc);

	return rc;
}


int ggiMiscAttach(ggi_visual_t vis)
{
	int rc;

	rc = ggiExtensionAttach(vis, ggiMiscID);
	GGIDPRINT("Attached Misc extension to %p. rc=%i\n", vis, rc);

	if (rc == 0) {
		/* We are actually creating the primary instance. */
		memset(LIBGGI_MISCEXT(vis), 0, sizeof(miscext));
		LIBGGI_MISCEXT(vis)->priv = NULL;

		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
	}

	return rc;
}

int ggiMiscDetach(ggi_visual_t vis)
{
	int rc;

	rc = ggiExtensionDetach(vis,ggiMiscID);
	GGIDPRINT("Detached Misc extension from %p. rc=%i\n", vis, rc);

	return rc;
}
