/* $Id: visual.c,v 1.12 2000/04/24 17:43:19 marcus Exp $
******************************************************************************

   Misc extension for LibGGI SVGAlib-target

   Copyright (C) 1998-2000 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include "svgamisc.h"

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
#endif


static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	LIBGGI_MISCEXT(vis)->priv = malloc(sizeof(struct svgamisc_priv));
	if (LIBGGI_MISCEXT(vis)->priv == NULL) return GGI_ENOMEM;

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
	{
#define	MISCr	0x03CC
#define	MISCw	0x03C2
#define	CRTIm	0x03B4
#define CRTIc	0x03D4
#define CRTDm	0x03B5
#define	CRTDc	0x03D5
#define	MISC_COLOR_IO	0x01
	int tmp = inb(MISCr);
	outb(tmp, MISCw);
	if (tmp & MISC_COLOR_IO) { 
		SVGAMISC_PRIV(vis)->CRTI = CRTIc;
		SVGAMISC_PRIV(vis)->CRTD = CRTDc; 
	} else {
		SVGAMISC_PRIV(vis)->CRTI = CRTIm;
		SVGAMISC_PRIV(vis)->CRTD = CRTDm;
	}
	}
	LIBGGI_MISCEXT(vis)->setsplitline = GGI_svga_setsplitline;
#endif
	LIBGGI_MISCEXT(vis)->waitraypos = GGI_svga_waitraypos;

	*dlret = GGI_DL_EXTENSION;
	return 0;
}

static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	free(LIBGGI_MISCEXT(vis)->priv);

	return 0;
}


int GGIdl_svgalib_misc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	default:
		*funcptr = NULL;
	}

	return GGI_ENOTFOUND;
}

#include <ggi/internal/ggidlinit.h>
