/* $Id: mode.c,v 1.10 1999/05/31 21:16:27 marcus Exp $
******************************************************************************

   Misc extension for LibGGI SVGAlib-target, CRT stuff

   Copyright (C) 1997	   Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998	   Steve Cheng		[steve@ggi-project.org]
   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include "svgamisc.h"


int GGI_svga_waitraypos(ggi_visual *vis,sint32 *x,sint32 *y)
{
	if (*y == GGI_RP_SYNC && *x == GGI_RP_DONTCARE) {
		vga_waitretrace();
		return 0;
	}
	*x = GGI_RP_DONTCARE;
	*y = GGI_RP_SYNC;

	return 1;
}


#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
int GGI_svga_setsplitline(ggi_visual *vis, int y)
{
#define CRT_LINECOMPARE      0x18
#define CR07_LINECOMPARE_B8  0x10
#define CR09_LINECOMPARE_B9  0x40
#define outbCRT(val,reg) outw(((val) << 8) | (reg), CRTI)
	register uint8 foo;
	unsigned short CRTI,CRTD;

	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;
	if (LIBGGI_MODE(vis)->visible.y<0x100) y <<= 1;

	CRTI=SVGAMISC_PRIV(vis)->CRTI;
	CRTD=SVGAMISC_PRIV(vis)->CRTD;

	outbCRT(y & 0xFF, CRT_LINECOMPARE);

	outb(0x07, CRTI);

	foo = (y & 0x0100)
		? inb(CRTD) | CR07_LINECOMPARE_B8
		: inb(CRTD) & ~CR07_LINECOMPARE_B8;
	outbCRT(foo, 0x07);

	outb(0x09, CRTI);
	foo = (y & 0x0200)
		? inb(CRTD) | CR09_LINECOMPARE_B9
		: inb(CRTD) & ~CR09_LINECOMPARE_B9;
	outbCRT(foo, 0x09);
	
	return 0;
}
#endif

