/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#include "global.h"
#include "sceme.h"
#include <X11/cursorfont.h>

// the default default iconpath
// #define ICONPATH "/opt/kde/share/icons/unknown.xpm"

#define CMAP DefaultColormap(dpy, screen)

Sceme::Sceme(Section *section) {
  s = section;
}

void Sceme::Init() {
  flags = 0;
  char *v; // value
  int i;

  XColor dummyc;
  v = s ? s->GetEntry("fgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "yellow", &colors[C_FG], &dummyc);
  v = s ? s->GetEntry("bgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "black", &colors[C_BG], &dummyc);
  v = s ? s->GetEntry("bdcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "rgb:5/5/5", &colors[C_BD], &dummyc);
  v = s ? s->GetEntry("titlebgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "rgb:0/0/5", &colors[C_TBG], &dummyc);
  v = s ? s->GetEntry("htitlebgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "rgb:0/0/8", &colors[C_HTBG], &dummyc);
  v = s ? s->GetEntry("hhtitlebgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "rgb:0/0/B", &colors[C_HHTBG], &dummyc);
  v = s ? s->GetEntry("iconfgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "white", &colors[C_IFG], &dummyc);
  v = s ? s->GetEntry("iconbgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "grey30", &colors[C_IBG], &dummyc);
  v = s ? s->GetEntry("actionbgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "grey15", &colors[C_ABG], &dummyc);
  v = s ? s->GetEntry("iconbdcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "grey", &colors[C_IBD], &dummyc);
  v = s ? s->GetEntry("menufgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "black", &colors[C_MFG], &dummyc);
  v = s ? s->GetEntry("menubgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "grey", &colors[C_MBG], &dummyc);
  v = s ? s->GetEntry("hmenubgcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "yellow", &colors[C_HMBG], &dummyc);
  v = s ? s->GetEntry("menubdcolor") : 0;
  XAllocNamedColor(dpy, CMAP, v ? v : "black", &colors[C_MBD], &dummyc);
  v = s ? s->GetEntry("font") : 0;
  fonts[FO_STD] = XLoadQueryFont(dpy, v ? v : "lucidasans-10");
  v = s ? s->GetEntry("iconfont") : 0;
  fonts[FO_ICON] = v ? XLoadQueryFont(dpy, v)
                     : fonts[FO_STD]; // :-)
  v = s ? s->GetEntry("menufont") : 0;
  fonts[FO_MENU] = v ? XLoadQueryFont(dpy, v)
                     : fonts[FO_STD]; // :-)
  for (int i=0;i!=FO_NUM;++i) {
    if (!fonts[i]) fonts[i] = XLoadQueryFont(dpy, "lucidasans-10");
    if (!fonts[i]) {
      fprintf(stderr,"No font found\n");
      exit(1);
    }
  };
  cursors[CU_STD] = XCreateFontCursor(dpy, XC_left_ptr);
  cursors[CU_MOVE] = XCreateFontCursor(dpy, XC_fleur);
  cursors[CU_RESIZE] = XCreateFontCursor(dpy, XC_plus);
  cursors[CU_NEWTARGET] = XCreateFontCursor(dpy, XC_diamond_cross);

  v = s ? s->GetEntry("defaulticon") : 0;
  if (v) {
    iconpm = rman->GetPixmap(v);
  } else {
#ifdef ICONPATH
    iconpm = rman->GetPixmap(ICONPATH);
#else
    iconpm = 0;
#endif
  }
  if (s && s->GetIntEntry("borderwidth",i)) {
    BW = i;
  } else BW = 1;

  v = s ? s->GetEntry("bgpixmap") : 0;
  if (v) {
    bgpm = rman->GetPixmap(v);
  } else bgpm = 0;


  v = s ? s->GetEntry("button10") : 0;
  button[BU_10] = rman->GetPixmap(v ? v : "none1.xpm");
  v = s ? s->GetEntry("button11") : 0;
  button[BU_11] = rman->GetPixmap(v ? v : "max2.xpm");
  v = s ? s->GetEntry("button12") : 0;
  button[BU_12] = rman->GetPixmap(v ? v : "max1.xpm");
  v = s ? s->GetEntry("button13") : 0;
  button[BU_13] = rman->GetPixmap(v ? v : "resize.xpm");
  v = s ? s->GetEntry("button20") : 0;
  button[BU_20] = rman->GetPixmap(v ? v : "none2.xpm");
  v = s ? s->GetEntry("button21") : 0;
  button[BU_21] = rman->GetPixmap(v ? v : "close.xpm");
  v = s ? s->GetEntry("button22") : 0;
  button[BU_22] = rman->GetPixmap(v ? v : "icon.xpm");
  v = s ? s->GetEntry("button23") : 0;
  button[BU_23] = rman->GetPixmap(v ? v : "move.xpm");
  for (int i=0;i!=BU_NUM;++i)
    if (button[i])
      button[i]->GetPixmap();


  if (s && s->GetIntEntry("raiseonclick",i) && i)
    flags |= SC_RAISEONCLICK;
  if (s && s->GetIntEntry("raiseonenter",i) && i)
    flags |= SC_RAISEONENTER;
  if (s && s->GetIntEntry("focusonclick",i) && i)
    flags |= SC_FOCUSONCLICK;
  if (s && s->GetIntEntry("focusonenter",i)) {
    if (i)
      flags |= SC_FOCUSONENTER;
  } else flags |= SC_FOCUSONENTER;
  if (s && s->GetIntEntry("grabaltclick",i)) {
    if (i)
      flags |= SC_GRABALTCLICK;
  } flags |= SC_GRABALTCLICK;

  if (s && s->GetIntEntry("passfirstclick",i)) {
    if (i)
      flags |= SC_PASSFIRSTCLICK;
  } else flags |= SC_PASSFIRSTCLICK;
  if (!s || !s->GetIntEntry("showkeys",i) || i)
    flags |= SC_SHOWKEYS;


  if (!s || !s->GetIntEntry("MinIconX",MinIX))
    MinIX = 100;
  if (!s || !s->GetIntEntry("MinIconY",MinIY))
    MinIY = 50;
  if (!s || !s->GetIntEntry("GridX",GridX))
    GridX = 80;
  if (!s || !s->GetIntEntry("GridY",GridY))
    GridY = 70;
  if (!s || !s->GetIntEntry("IconSpaceLeft",ISLeft))
    ISLeft = 35;
  if (!s || !s->GetIntEntry("IconSpaceRight",ISRight))
    ISRight = 35;
  if (!s || !s->GetIntEntry("IconSpaceTop",ISTop))
    ISTop = 40;
  if (!s || !s->GetIntEntry("IconSpaceBottom",ISBottom))
    ISBottom = 25;
  if (!s || !s->GetIntEntry("DoubleClickTime",i))
    i = 250;
  DCTime = i;

  XGCValues gv;

  gv.graphics_exposures = false;
  gv.function = GXcopy;
  gv.foreground = colors[C_FG].pixel;
  gv.font = fonts[FO_STD]->fid;
  string_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCFont|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_IFG].pixel;
  gv.font = fonts[FO_ICON]->fid;
  icon_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCFont|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_MFG].pixel;
  gv.font = fonts[FO_MENU]->fid;
  menustring_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCFont|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_MBG].pixel;
  menu_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_HMBG].pixel;
  hmenu_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_MBD].pixel;
  menubd_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_BD].pixel;
  gv.line_width = 1;
  border_gc = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures|GCLineWidth, &gv);

  gv.foreground = colors[C_TBG].pixel;
  title_gc[0] = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_HTBG].pixel;
  title_gc[1] = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.foreground = colors[C_HHTBG].pixel;
  title_gc[2] = XCreateGC(dpy, root, GCFunction|GCForeground|GCGraphicsExposures, &gv);

  gv.function = GXinvert;
  gv.subwindow_mode = IncludeInferiors;
  invert_gc = XCreateGC(dpy, root, GCFunction|GCSubwindowMode|GCGraphicsExposures|GCLineWidth|GCFont, &gv);

  s = 0;

}


Sceme::~Sceme() {
  if (fonts[FO_STD] == fonts[FO_ICON])
    fonts[FO_ICON] = 0;
  if (fonts[FO_STD] == fonts[FO_MENU])
    fonts[FO_MENU] = 0;
  for (int i=0;i!=FO_NUM;++i)
    if (fonts[i])
      XFreeFont(dpy, fonts[i]);
  for (int i=0;i!=CU_NUM;++i)
    if (cursors[i])
      XFreeCursor(dpy, cursors[i]);
  XFreeGC(dpy, invert_gc);
  XFreeGC(dpy, border_gc);
  XFreeGC(dpy, string_gc);
  XFreeGC(dpy, icon_gc);
  XFreeGC(dpy, title_gc[0]);
  XFreeGC(dpy, title_gc[2]);
  XFreeGC(dpy, title_gc[1]);
  for (int i=0;i!=BU_NUM;++i)
    if (button[i])
      button[i]->FreePixmap();

}
