/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#include "menu.h"
#include "sceme.h"
#include <X11/keysym.h>

inline int min(int x,int y) {
  return x < y ? x : y;
}

Menu::Menu(const MenuItem* Items,int N,Sceme *sceme,int X,int Y) {
  Sc = sceme;
  window = 0;
  int w,width2 = 0;
  width = 0;
  n = N;
  items = Items;
  EHeight = Sc->fonts[FO_MENU]->ascent + Sc->fonts[FO_MENU]->descent + 2*MENUSPACE + 1;
  height = n*EHeight - 1;
  for (int i=0;i!=n;++i) {
    w = XTextWidth(Sc->fonts[FO_MENU],items[i].text,strlen(items[i].text));
    w += MENUINDENT * (items[i].flags/MF_INDENT);
    if (w>width)
      width = w;
    if (!(Sc->flags & SC_SHOWKEYS))
      continue;
    w = XTextWidth(Sc->fonts[FO_MENU],items[i].key,strlen(items[i].key));
    if (w>width2)
      width2 = w;
  }
  width += width2 + 4*MENUSPACE;
  sel = 0;
  x = min(X - width/2, DisplayWidth(dpy, screen) - width - 2);
  if (x < 0)
    x = 0;
  y  = min(Y, DisplayHeight(dpy, screen) - height - 2);
  if (y < 0)
    y = 0;

}


Menu::~Menu() {
}


void Menu::Init() {
  XSetWindowAttributes pattr;

  pattr.override_redirect = True;
  pattr.background_pixel = Sc->colors[C_MBG].pixel;
  pattr.border_pixel = Sc->colors[C_MBD].pixel;
  pattr.event_mask = ChildMask|ButtonMask|ExposureMask|EnterWindowMask|KeyPressMask;
  window = XCreateWindow(dpy, root, x, y, width, height, 1,
      DefaultDepth(dpy, screen), CopyFromParent, DefaultVisual(dpy, screen),
      CWOverrideRedirect|CWBackPixel|CWBorderPixel|CWEventMask, &pattr);
  XMapWindow(dpy,window);
  XGrabKeyboard(dpy,window,false,GrabModeAsync,GrabModeAsync,CurrentTime);
}

void Menu::DrawItem(int i) {
  XDrawString(dpy, window, Sc->menustring_gc, MENUSPACE + MENUINDENT * (items[i].flags/MF_INDENT),
              i*EHeight + MENUSPACE + Sc->fonts[FO_MENU]->ascent,
              items[i].text, strlen(items[i].text));
  if (!(Sc->flags & SC_SHOWKEYS))
    return;
  int w = XTextWidth(Sc->fonts[FO_MENU],items[i].key,strlen(items[i].key));
  XDrawString(dpy, window, Sc->menustring_gc, width -w-MENUSPACE, i*EHeight + MENUSPACE + Sc->fonts[FO_MENU]->ascent,
              items[i].key, strlen(items[i].key));

}

void Menu::ReDraw() {
  XClearWindow(dpy,window);
  for (int i=0;i!=n;++i) {
    if (i)
      XDrawLine(dpy, window, Sc->menubd_gc, 0, i*EHeight-1, width, i*EHeight-1);
      if (i+1 == sel)
        XFillRectangle(dpy,window,Sc->hmenu_gc,0,i*EHeight,width,EHeight-1);
      DrawItem(i);
  }
}

void Menu::Mouse(int X,int Y) {
  int oldsel = sel;
  if (x <= X && X <= x+width && y <= Y && Y <= y + height)
    sel = (Y-y)/EHeight + 1; else
    sel = 0;
  if (sel > n)
    sel = n;
  if (sel != oldsel) {
    if (oldsel) {
      XFillRectangle(dpy,window,Sc->menu_gc,0,(oldsel-1)*EHeight,width,EHeight-1);
      DrawItem(oldsel - 1);
    }
    if (sel) {
      XFillRectangle(dpy,window,Sc->hmenu_gc,0,(sel-1)*EHeight,width,EHeight-1);
      DrawItem(sel - 1);
    }
  }
}

void Menu::Key(XKeyEvent &e) {
  if (e.keycode == XKeysymToKeycode(dpy,XK_Up)) {
    XWarpPointer(dpy,None,None,0,0,0,0,0,-EHeight);
  }
  if (e.keycode == XKeysymToKeycode(dpy,XK_Down)) {
    XWarpPointer(dpy,None,None,0,0,0,0,0,EHeight);
  }
}

int Menu::Remove() {
  XUngrabKeyboard(dpy,CurrentTime);
  XUnmapWindow(dpy,window);
  XDestroyWindow(dpy,window);
  return sel;
}
