/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef DESKTOP_H
#define DESKTOP_H

#include "global.h"
#include "client.h"

#define DF_ICONSRAISED 2048
#define DF_AUTOSCROLL  4096
#define DF_TILE        8192

#define GOTO_RELATIVE 1
#define GOTO_MOVEFULL 2
#define GOTO_MOVEHALF 4
#define GOTO_SNAP     8

class Desktop : public Client  {
  public:
    Desktop(Desktop *, Options *, ClientInfo *, Window, char *);
    virtual ~Desktop();
    virtual bool Init();
    virtual Desktop *DesktopAbove();
    virtual Client *FindPointerClient();
    virtual bool GetWindowList(MenuItem *,int &,bool,int,int,int);
    virtual void RemoveClientReferences(Client *);
    void RemoveChild(Client *, int);
    virtual void SendWMDelete(bool);
    virtual void Remove(int);
    void AutoClose();
    virtual void ReDraw();
    virtual void Raise(int);
    virtual void GrabButtons(bool=false);
    void UpdateTB();
    void ShowIcons(bool);
    Icon *AddIcon(Client *, Action*);
    void RemoveIcon(Icon *);
    void GiveAway(Client *);
    void Take(Client *,int,int);
    virtual void RequestDesktop();
    virtual void GetFocus();
    virtual bool Leave(int,int,bool);
    bool Goto(int,int,int);
    virtual Client *Focus();
    virtual unsigned long GetRegionMask(int,int,Client * &);
    void Tile();
    virtual void SetWMState();
    virtual void SendConfig();
    virtual void ChangeSize();
    void Translate(int *,int *);
    Client *AddChild(Window,Options*,ClientInfo *);
    Desktop *AddDesktop(int,int,int,int,Options *,ClientInfo *);
    Client *firstchild, *focus;
    Icon *firsticon;
    bool autoclose;
    Window StackRef[3];
    Client *LastRaised[3];
    int PosX,PosY;
    int VirtualX,VirtualY;
	
};

#endif
