<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: displays a single alert   
 *
 * Input GET/POST variables
 *   - caller
 *   - submit:
 *
 */

  include ("acid_constants.inc");
  include ("acid_conf.php");
  include ("acid_include.inc");
  include_once ("acid_db_common.php");
  include_once ("acid_qry_common.php");
  include_once ("acid_stat_common.php");

function PrintPacketLookupBrowseButtons($seq, $save_sql, $db, &$previous_button, &$next_button)
{
  echo "\n\n<!-- Single Alert Browsing Buttons -->\n";

  $result2 = $db->acidExecute($save_sql);

  if ( $seq == 0 )
     $previous_button = '[ First ]'."\n";

  $i = 0;
  while ($i <= $seq+1 )
  {
     $myrow2 = $result2->acidFetchRow();

     if ( $myrow2 == "" )
        $next_button = '[ Last ]'."\n"; 
     else if ( $i == $seq-1 )
        $previous_button = '<INPUT TYPE="submit" NAME="submit" VALUE="&lt;&lt; Previous #'.($seq-1).'-('.$myrow2[0].'-'.$myrow2[1].')">'."\n";

     else if ( $i == $seq+1 )
        $next_button = '<INPUT TYPE="submit" NAME="submit" VALUE="&gt;&gt; Next #'.($seq+1).'-('.$myrow2[0].'-'.$myrow2[1].')">'."\n";
     $i++;
  }

  $result2->acidFreeRows();
}

  /* 
   *  Need to import $submit and set the $QUERY_STRING early to support
   *  the back button.  Otherwise, the value of $submit will not be passed
   *  to the history.
   */
  $submit = ImportHTTPVar("submit");
  $QUERY_STRING = "submit=".rawurlencode($submit);

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_qry_alert.php");
  $cs->ReadState();

  $qs = new QueryState();

  $page_title = "Alert";
  PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  PrintCriteria("");
  $criteria_clauses = ProcessCriteria();  

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");

  $qs->SetActionSQL($from.$where);
 
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_ALERT_DISPLAY, $db);
  $et->Mark("Alert Action");

  /* If get a valid (sid,cid) store it in $caller.  
   * But if $submit is returning from an alert action 
   * get the (sid,cid) back from $caller 
   */ 
  if ( $submit == "Selected" )
     $submit = ImportHTTPVar("caller");
  else
     $caller = $submit;

  /* Setup the Query Results Table -- However, this data structure is not
   * really used for output.  Rather, it duplicates the sort SQL set in
   *  acid_qry_sqlcalls.php 
   */
  $qro = new QueryResultsOutput("");

  $qro->AddTitle("Signature",
                 "sig_a", " ", " ORDER BY sig_name ASC",
                 "sig_d", " ", " ORDER BY sig_name DESC");
  $qro->AddTitle("Timestamp",
                 "time_a", " ", " ORDER BY timestamp ASC ",
                 "time_d", " ", " ORDER BY timestamp DESC ");
  $qro->AddTitle("Source<BR>Address",
                 "sip_a", " ", " ORDER BY ip_src ASC",
                 "sip_d", " ", " ORDER BY ip_src DESC");
  $qro->AddTitle("Dest.<BR>Address",
                 "dip_a", " ", " ORDER BY ip_dst ASC",
                 "dip_d", " ", " ORDER BY ip_dst DESC");
  $qro->AddTitle("Layer 4<BR>Proto",
                 "proto_a", " ", " ORDER BY layer4_proto ASC",
                 "proto_d", " ", " ORDER BY layer4_proto DESC");

  $sort_sql = $qro->GetSortSQL($qs->GetCurrentSort(), "");
  $save_sql = "SELECT acid_event.sid, acid_event.cid".$sort_sql[0].
              $from.$where.$sort_sql[1];

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  GetQueryResultID($submit, $seq, $sid, $cid);

  if ( $debug_mode > 0 )
     echo "\n====== Alert Lookup =======<BR>
           sid = $sid<BR>
           cid = $cid<BR>
           seq = $seq<BR>\n".
          "===========================<BR>\n";

  /* Verify that have extracted (sid, cid) correctly */
  if ( !($sid > 0 && $cid > 0) )
  {
     ErrorMessage("Invalid (sid,cid) pair (".$sid.",".$cid.")");
     exit();
  }

  echo "<FORM METHOD=\"POST\" ACTION=\"acid_qry_alert.php\">\n"; 
  PrintPacketLookupBrowseButtons($seq, $save_sql, $db, $previous, $next);
  echo "<CENTER>\n<B>Alert #".($seq+1)."</B><BR>\n$previous &nbsp&nbsp&nbsp\n$next\n</CENTER>\n";
  echo "<HR>\n";

  /* Make Selected */
  echo "\n<INPUT TYPE=\"hidden\" NAME=\"action_chk_lst[0]\" VALUE=\"$submit\">\n";

  /* Event */
  $sql2 = "SELECT signature, timestamp FROM acid_event WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  if ( $myrow2[0] == "" )
  {
     echo '<CENTER><B>';
     ErrorMessage("Alert DELETED");
     echo '</CENTER></B>';
  }

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="metatitle" WIDTH=50 ALIGN=CENTER ROWSPAN=3>Meta
              <TD>
                  <TABLE BORDER=1 CELLPADDING=4>
                    <TR><TD CLASS="plfieldhdr" >ID #</TD>
                        <TD CLASS="plfieldhdr">Time</TD>
                        <TD CLASS="plfieldhdr">Triggered Signature</TD></TR>
                    <TR><TD CLASS="plfield">'.($sid." - ".$cid).'</TD>
                        <TD CLASS="plfield">'.$myrow2[1].'</TD>
                        <TD CLASS="plfield">'.BuildSigByID($myrow2[0], $db).'</TD></TR>      
                  </TABLE>
              </TD>
           </TR>';

  $sql4 = "SELECT hostname, interface, filter FROM sensor  WHERE sid='".$sid."'";
  $result4 = $db->acidExecute($sql4);
  $myrow4 = $result4->acidFetchRow();

  echo '  <TR>
             <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="metatitle" ALIGN=CENTER ROWSPAN=2>Sensor</TD>
                       <TD class="plfieldhdr">name</TD>
                       <TD class="plfieldhdr">interface</TD>
                       <TD class="plfieldhdr">filter</TD>
                  </TR>
                  <TR><TD class="plfield">'.$myrow4[0].'</TD>
                      <TD class="plfield">'.$myrow4[1].'</TD>
                      <TD class="plfield">'.
                      ( ($myrow4[2] == "") ? "&nbsp;<I>none</I>&nbsp;" : $myrow4[2] ).'</TD>
                  </TR>
                 </TABLE>     
          </TR>';
  $result4->acidFreeRows();

  $sql4 = "SELECT acid_ag_alert.ag_id, ag_name, ag_desc ".
          "FROM acid_ag_alert LEFT JOIN acid_ag ON acid_ag_alert.ag_id = acid_ag.ag_id ".
          "WHERE ag_sid=".$sid." AND ag_cid=".$cid;
  $result4 = $db->acidExecute($sql4);
  $num = $result4->acidRecordCount();

  echo ' <TR>
           <TD>
             <TABLE BORDER=1 CELLPADDING=4>
               <TR><TD CLASS="metatitle" ALIGN=CENTER ROWSPAN='.($num+1).'>Alert<BR>Group</TD>';
  
  if ( $num > 0 )
     echo '        <TD class="plfieldhdr">ID #</TD>
                   <TD class="plfieldhdr">Name</TD>
                   <TD class="plfieldhdr">Description</TD></TR>';  
  else
     echo '        <TD>&nbsp;&nbsp;<I>none</I>&nbsp;</TD></TR>';

  for ($i = 0; $i < $num; $i++)
  {
     $myrow4 = $result4->acidFetchRow();

     echo '    <TR><TD class="plfield">'.$myrow4[0].'</TD>
                   <TD class="plfield">'.$myrow4[1].'</TD>
                   <TD class="plfield">'.$myrow4[2].'</TD>
               </TR>';
  }
  echo '      </TABLE>';
  $result4->acidFreeRows();

  echo '   </TR>
        </TABLE>';
  $result2->acidFreeRows();

  /* IP */
  $sql2 = "SELECT ip_src, ip_dst, ".
          "ip_ver, ip_hlen, ip_tos, ip_len, ip_id, ip_flags, ip_off, ip_ttl, ip_csum, ip_proto". 
          " FROM iphdr  WHERE sid='".$sid."' AND cid='".$cid."'";

  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  $layer4_proto = -1;
  if ( $myrow2[0] != "" )
  {
  $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='0'";
  $result3 = $db->acidExecute($sql3);
  $num_opt = $result3->acidRecordCount();

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="iptitle" WIDTH=50 ROWSPAN=3 ALIGN=CENTER>IP';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=2>';
  echo '            <TR><TD class="plfieldhdr">source addr</TD>
                        <TD class="plfieldhdr">&nbsp dest addr &nbsp</TD>
                        <TD class="plfieldhdr">Ver</TD>
                        <TD class="plfieldhdr">Hdr Len</TD>
                        <TD class="plfieldhdr">TOS</TD>
                        <TD class="plfieldhdr">length</TD>
                        <TD class="plfieldhdr">ID</TD>
                        <TD class="plfieldhdr">flags</TD>
                        <TD class="plfieldhdr">offset</TD>
                        <TD class="plfieldhdr">TTL</TD>
                        <TD class="plfieldhdr">chksum</TD></TR>';
  echo '             <TR><TD class="plfield">
                       <A HREF="acid_stat_ipaddr.php?ip='.acidLong2IP($myrow2[0]).'&netmask=32">'.
                            acidLong2IP($myrow2[0]).'</A></TD>';
  echo '                 <TD class="plfield">
                         <A HREF="acid_stat_ipaddr.php?ip='.acidLong2IP($myrow2[1]).'&netmask=32">'.
                            acidLong2IP($myrow2[1]).'</A></TD>';
  echo '                 <TD class="plfield">'.$myrow2[2].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[3].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[4].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[5].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[6].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[7].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[8].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[9].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[10].'</TD></TR>';
  echo '         </TABLE>';

  if ( $resolve_IP == 1 )
  {
     echo '  <TR>
              <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="iptitle" ALIGN=CENTER ROWSPAN=2>FQDN</TD>
                       <TD class="plfieldhdr">Source Name</TD>
                       <TD class="plfieldhdr">Dest. Name</TD>
                  </TR>
                  <TR><TD class="plfield">'.
                      (acidGetHostByAddr(acidLong2IP($myrow2[0]),
                                        $db, $dns_cache_lifetime)).'</TD>
                      <TD class="plfield">'.
                      (acidGetHostByAddr(acidLong2IP($myrow2[1]),
                                         $db, $dns_cache_lifetime)).'</TD>
                  </TR>
                 </TABLE>     
            </TR>';
  }

  echo '  <TR>';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=4>';
  echo '           <TR><TD CLASS="iptitle" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

  $layer4_proto = $myrow2[11];

  if ( $num_opt > 0 )
  {
     echo '            <TD></TD>
                       <TD class="plfieldhdr">code</TD>
                       <TD class="plfieldhdr">length</TD>
                       <TD class="plfieldhdr" ALIGN=CENTER>data</TD>';

     for ( $i = 0; $i < $num_opt; $i++)
     {
         $myrow3 = $result3->acidFetchRow();
         echo '    <TR><TD>#'.($i+1).'</TD>';
         echo '        <TD class="plfield">'.IPOption2str($myrow3[4]).'</TD>';
         echo '        <TD class="plfield">'.$myrow3[5].'</TD>';
         echo '        <TD class="plfield">'.$myrow3[6].'</TD></TR>';             
     }
   }
   else
   {
     echo '             <TD> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
   }
      echo '         </TABLE></TD></TR>';  
                       

  echo '</TABLE>';
  $result3->acidFreeRows();
  }
  $result2->acidFreeRows();

  /* TCP */
  if ( $layer4_proto == "6" )  
  {
     $sql2 = "SELECT tcp_sport, tcp_dport, tcp_seq, tcp_ack, tcp_off, tcp_res, tcp_flags, tcp_win, ".
             "       tcp_csum, tcp_urp FROM tcphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='6'";
     $result3 = $db->acidExecute($sql3);
     $num_opt = $result3->acidRecordCount();

      echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>TCP';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=2>';
      echo '            <TR><TD class="plfieldhdr">source<BR> port</TD>
                            <TD class="plfieldhdr"> dest<BR> &nbsp port &nbsp</TD>
                            <TD class="plfieldhdr">R<BR>1</TD>
                            <TD class="plfieldhdr">R<BR>0</TD>
                            <TD class="plfieldhdr">U<BR>R<BR>G</TD>
                            <TD class="plfieldhdr">A<BR>C<BR>K</TD>
                            <TD class="plfieldhdr">P<BR>S<BR>H</TD>
                            <TD class="plfieldhdr">R<BR>S<BR>T</TD>
                            <TD class="plfieldhdr">S<BR>Y<BR>N</TD>
                            <TD class="plfieldhdr">F<BR>I<BR>N</TD>
                            <TD class="plfieldhdr">seq #</TD>
                            <TD class="plfieldhdr">ack</TD>
                            <TD class="plfieldhdr">offset</TD>
                            <TD class="plfieldhdr">res</TD>
                            <TD class="plfieldhdr">window</TD>
                            <TD class="plfieldhdr">urp</TD>
                            <TD class="plfieldhdr">chksum</TD></TR>';
      $src_port = $external_port_link.$myrow2[0];
      $dst_port = $external_port_link.$myrow2[1]; 
      echo '            <TR><TD class="plfield"><A HREF="'.$src_port.'" TARGET="_ACID_PORT_">'.$myrow2[0].'</A></TD>';
      echo '                <TD class="plfield"><A HREF="'.$dst_port.'" TARGET="_ACID_PORT_">'.$myrow2[1].'</A></TD>';
      echo '                <TD class="plfield">';
      if ( ($myrow2[6] & 128) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 64 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 32) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 16 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 8) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 4 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 2 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 1 ) != 0 )
           echo 'X';
      echo '                    </TD>';
     
      echo '                <TD class="plfield">'.$myrow2[2].'</TD>';    
      echo '                <TD class="plfield">'.$myrow2[3].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[4].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[5].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[7].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[9].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[8].'</TD></TR>';
      echo '         </TABLE></TR></TR>';
      echo '  <TR>';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=4>';
      echo '           <TR><TD CLASS="layer4title" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

      if ( $num_opt != 0)
      {
         echo '            <TD></TD>
                           <TD class="plfieldhdr">code</TD>
                           <TD class="plfieldhdr">length</TD>
                           <TD class="plfieldhdr">data</TD>';

         for ( $i = 0; $i < $num_opt; $i++)
         {
             $myrow3 = $result3->acidFetchRow();
             echo '    <TR><TD class="plfield">#'.($i+1).'</TD>';
             echo '        <TD class="plfield">'.TCPOption2str($myrow3[4]).'</TD>';
             echo '        <TD class="plfield">'.$myrow3[5].'</TD>';
             echo '        <TD class="plfield">'.$myrow3[6].'</TD></TR>';             
         }
      }
      else
      {
         echo '             <TD class="plfield"> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
      }
      echo '         </TABLE></TD></TR>';                       

      echo '</TABLE>';

      $result2->acidFreeRows();
      $result3->acidFreeRows();
  }

  /* UDP */
  if ( $layer4_proto == "17" )
  {

     $sql2 = "SELECT * FROM udphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>UDP</TD>';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="plfieldhdr">source port</TD>
                            <TD class="plfieldhdr">dest port</TD>
                            <TD class="plfieldhdr">length</TD></TR>';

    $src_port = $external_port_link.$myrow2[2];
    $dst_port = $external_port_link.$myrow2[3]; 

     echo '            <TR><TD class="plfield"><A HREF="'.$src_port.'" TARGET="_ACID_PORT_">'.$myrow2[2].'</A></TD>';
     echo '                <TD class="plfield"><A HREF="'.$dst_port.'" TARGET="_ACID_PORT_">'.$myrow2[3].'</A></TD>';
     echo '                <TD class="plfield">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE></TD></TR>';
     echo '</TABLE>';

     $result2->acidFreeRows();
  }

  /* ICMP */
  if ( $layer4_proto == "1" )
  {
     $sql2 = "SELECT icmp_type, icmp_code, icmp_csum, icmp_id, icmp_seq FROM icmphdr ".
             "WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     echo '
           <TABLE BORDER=1>
              <TR><TD class="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>ICMP';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="plfieldhdr">type</TD>
                           <TD class="plfieldhdr">code</TD>
                           <TD class="plfieldhdr">checksum</TD>
                           <TD class="plfieldhdr">id</TD>
                           <TD class="plfieldhdr">seq #</TR>';
     echo '            <TR><TD class="plfield">('.$myrow2[0].') '.ICMPType2str($myrow2[0]).'</TD>';
     echo '                <TD class="plfield">('.$myrow2[1].') '.ICMPCode2str($myrow2[0],$myrow2[1]).'</TD>';
     echo '                <TD class="plfield">'.$myrow2[2].'</TD>';
     echo '                <TD class="plfield">'.$myrow2[3].'</TD>';
     echo '                <TD class="plfield">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE>';
     echo '</TABLE>';

     $ICMPitype = $myrow2[0];
     $ICMPicode = $myrow2[1];

     $result2->acidFreeRows();
  }

  /* Print the Payload */
  $sql2 = "SELECT data_payload FROM data WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);

  /* get encoding information and detail_level on the payload */
  $sql3 = 'SELECT encoding, detail FROM sensor WHERE sid='.$sid;
  $result3 = $db->acidExecute($sql3);
  $myrow3 = $result3->acidFetchRow();  
 
  echo '
        <TABLE BORDER=1>
           <TR><TD class="payloadtitle" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>Payload';
  echo '       <TD>';

  $myrow2 = $result2->acidFetchRow();
  if ( $myrow2 )
  {
     /* print the packet based on encoding type */
     PrintPacketPayload($myrow2[0], $myrow3[0], 1);

     if ( $layer4_proto == "1" )
     {
      /* IF ( ICMP destination unreachable OR ICMP time exceeded ) */
      if ( $ICMPitype == "3" || $ICMPitype == "11" )
      {
          /* IF ( network, host, port unreachable OR frag needed OR network admin prohibited OR filtered) */
          if ( $ICMPicode == "0" || $ICMPicode == "1" || $ICMPicode == "3" || 
               $ICMPicode == "4" || 
               $ICMPicode == "9" || 
               $ICMPicode == "13" )
          {
              $work = str_replace("\n","",$myrow2[0]);

              /* 
               * depending on how the packet logged, 32-bits of NULL padding after
               * the checksum may still be present.
               */
              if ( substr($work, 0, 8) == "00000000" )
                 $offset = 8;

              $icmp_src = hexdec($work[24+$offset].$work[25+$offset]).".".
                          hexdec($work[26+$offset].$work[27+$offset]).".".
                          hexdec($work[28+$offset].$work[29+$offset]).".".
                          hexdec($work[30+$offset].$work[31+$offset]);
              $icmp_dst = hexdec($work[32+$offset].$work[33+$offset]).".".
                          hexdec($work[34+$offset].$work[35+$offset]).".".
                          hexdec($work[36+$offset].$work[37+$offset]).".".
                          hexdec($work[38+$offset].$work[39+$offset]);
              $icmp_proto = hexdec($work[18+$offset].$work[19+$offset]);

              $hdr_offset = ($work[$offset+1]) * 8 + offset;
              $icmp_src_port = hexdec($work[$hdr_offset].$work[$hdr_offset+1].$work[$hdr_offset+2].$work[$hdr_offset+3]);
              $icmp_dst_port = hexdec($work[$hdr_offset+4].$work[$hdr_offset+5].$work[$hdr_offset+6].$work[$hdr_offset+7]);

              echo '<TABLE BORDER=1>';
              echo '<TR>';
              echo '<TD class="plfieldhdr">Protocol</TD>';
              echo '<TD class="plfieldhdr">Org.Source<BR>IP</TD>';
              echo '<TD class="plfieldhdr">Org.Source<BR>Name</TD>';
              echo '<TD class="plfieldhdr">Org.Source<BR>Port</TD>';
              echo '<TD class="plfieldhdr">Org.Destination<BR>IP</TD>';
              echo '<TD class="plfieldhdr">Org.Destination<BR>Name</TD>';
              echo '<TD class="plfieldhdr">Org.Destination<BR>Port</TD>';
              echo '</TR>';
              echo '<TR>';
              echo '<TD class="plfield">'.IPProto2Str($icmp_proto).'</TD>';
              echo '<TD class="plfield">';
              echo '<A HREF="acid_stat_ipaddr.php?ip='.$icmp_src.'&netmask=32" TARGET="_PL_SIP">'.$icmp_src.'</A></TD>';
              echo '<TD class="plfield">'.acidGetHostByAddr($icmp_src, $db, $dns_cache_lifetime).'</TD>';
              echo '<TD class="plfield">'.$icmp_src_port.'</TD>';
              echo '<TD class="plfield">';
              echo '<A HREF="acid_stat_ipaddr.php?ip='.$icmp_dst.'&netmask=32" TARGET="_PL_DIP">'.$icmp_dst.'</A></TD>';
              echo '<TD class="plfield">'.acidGetHostByAddr($icmp_dst, $db, $dns_cache_lifetime).'</TD>';
              echo '<TD class="plfield">'.$icmp_dst_port.'</TD>';
              echo '</TR>';
              echo '</TABLE>';
             }
         }
     }
  }
  else
  {
     /* Don't have payload so lets print out why by checking the detail level */

     /* if have fast detail level */
     if ( $myrow3[1] == "0" )
        echo '<BR> &nbsp <I>Fast logging used so payload was discarded </I><BR>';
     else
        echo '<BR> &nbsp <I>none </I><BR>';
  }
  $result3->acidFreeRows();
  echo '</TABLE><P>';

  $result2->acidFreeRows();

  echo "<CENTER>$previous &nbsp&nbsp&nbsp $next</CENTER>";

  //PrintQueryResultAction($action, $action_arg, 1);  

  $qs->PrintAlertActionButtons();
  $qs->SaveState();
  ExportHTTPVar("caller", $caller);
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();

?>
