/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#ifndef GARMINICONS_H
#define GARMINICONS_H
#include <stdint.h>
#include <QString>

class QPixmap;
#define N_CUSTOM_ICONS   24
#define CUSTOM_ICONS_ID0 7680

extern void getWptIconByName(const QString& name, uint16_t& id);
extern void getWptIconByName(const QString& name, uint16_t& id, QPixmap& pix);
extern void getWptIconById(const uint16_t id, QPixmap& pix);
extern void getWptIconById(const uint16_t id, QPixmap& pix, QString& name);
extern void getWptIconById(const uint16_t id, QPixmap& pix, QString& name, QString& src);
extern void setWptIconById(const uint16_t id, const QString& src);
extern QPixmap loadIcon(const QString& path);

extern const char * wptDefault;

struct garmin_icon_t
{
    QString icon;
    uint16_t id;
    const char * name;
};

extern void InitCustomIcons();
extern void FreeCustomIcons();
#endif                           //GARMINICONS_H
