/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.This;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Interpreter interpreter, Object object, String string, Object[] objectArray, SimpleNode simpleNode) throws ReflectError, InvocationTargetException, EvalError {
        if (object instanceof This && !Reflect.showThisMethod(string)) {
            return ((This)object).invokeMethod(string, objectArray, interpreter, null, simpleNode);
        }
        return Reflect.invokeMethod(object.getClass(), object, string, objectArray, false);
    }

    private static boolean showThisMethod(String string) {
        return string.equals("getClass") || string.equals("invokeMethod");
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray) throws ReflectError, InvocationTargetException, EvalError {
        Interpreter.debug("invoke static Method");
        return Reflect.invokeMethod(clazz, null, string, objectArray, true);
    }

    public static Object getIndex(Object object, int n) throws ReflectError, TargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object + ", index=" + n);
        }
        try {
            Object object2 = Array.get(object, n);
            return Reflect.wrapPrimitive(object2, object.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new TargetError("Array Index", arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n, Object object2) throws ReflectError, TargetError {
        try {
            object2 = Reflect.unwrapPrimitive(object2);
            Array.set(object, n, object2);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new TargetError("Array store exception", arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TargetError("Illegal Argument", new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticField(Class clazz, String string) throws ReflectError {
        return Reflect.getFieldValue(clazz, null, string);
    }

    public static Object getObjectField(Object object, String string) throws ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, string);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), string)) {
                return Reflect.getObjectProperty(object, string);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string) throws ReflectError {
        Field field = Reflect.getField(clazz, string);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object, String string) throws ReflectError {
        if (object instanceof This) {
            return new LHS(((This)object).namespace, string);
        }
        try {
            Field field = Reflect.getField(object.getClass(), string);
            return new LHS(object, field);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), string)) {
                return new LHS(object, string);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object, String string) throws ReflectError {
        try {
            Field field = Reflect.getField(clazz, string);
            if (field == null) {
                throw new ReflectError("internal: field not found:" + string);
            }
            Object object2 = field.get(object);
            Class<?> clazz2 = field.getType();
            return Reflect.wrapPrimitive(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    private static Field getField(Class clazz, String string) throws ReflectError {
        try {
            if (Capabilities.haveAccessibility()) {
                return Reflect.findAccessibleField(clazz, string);
            }
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Field findAccessibleField(Class var0, String var1_1) throws NoSuchFieldException {
        try {
            return var0.getField(var1_1);
        }
        catch (NoSuchFieldException var2_2) {
            ** while (var0 != null)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_3 = var0.getDeclaredField(var1_1);
                if (ReflectManager.RMSetAccessible(var2_3)) {
                    return var2_3;
                }
            }
            catch (NoSuchFieldException var2_4) {
                // empty catch block
            }
            var0 = var0.getSuperclass();
            continue;
        }
lbl14:
        // 1 sources

        throw new NoSuchFieldException(var1_1);
    }

    private static Object invokeMethod(Class clazz, Object object, String string, Object[] objectArray, boolean bl) throws ReflectError, InvocationTargetException, EvalError {
        if (object == Primitive.NULL) {
            throw new TargetError("Attempt to invoke method " + string + " on null value", new NullPointerException());
        }
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to invoke method " + string + " on undefined variable or class name");
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + n + ") to method: " + string);
            }
            ++n;
        }
        Class<?> clazz2 = null;
        Object object2 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Reflect.unwrapPrimitives(objectArray);
        try {
            Method method = null;
            try {
                method = Reflect.findAccessibleMethod(clazz, string, classArray, bl);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (method == null && Interpreter.DEBUG) {
                Interpreter.debug("Exact method " + StringUtil.methodString(string, classArray) + " not found in '" + clazz.getName() + "'");
            }
            if (method == null) {
                if (classArray.length == 0) {
                    throw new ReflectError("No args " + (bl ? "static " : "") + "method " + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
                }
                Method[] methodArray = clazz.getMethods();
                if (bl) {
                    methodArray = Reflect.retainStaticMethods(methodArray);
                }
                method = Reflect.findMostSpecificMethod(string, classArray, methodArray);
                methodArray = clazz.getMethods();
                if (method == null) {
                    method = Reflect.findExtendedMethod(string, objectArray, methodArray);
                }
                if (method != null) {
                    try {
                        method = Reflect.findAccessibleMethod(clazz, method.getName(), method.getParameterTypes(), bl);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
            if (method == null) {
                throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
            }
            object2 = method.invoke(object, objectArray);
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            clazz2 = method.getReturnType();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(string, classArray) + " in '" + clazz.getName() + "' :" + illegalAccessException);
        }
        return Reflect.wrapPrimitive(object2, clazz2);
    }

    private static Method[] retainStaticMethods(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (Modifier.isStatic(methodArray[n].getModifiers())) {
                vector.addElement(methodArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Method findAccessibleMethod(Class clazz, String string, Class[] classArray, boolean bl) {
        Method method = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(clazz);
        Method method2 = null;
        while (vector.size() > 0) {
            Class<?>[] classArray2;
            Class clazz2 = (Class)vector.firstElement();
            vector.removeElementAt(0);
            if (Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility()) {
                try {
                    method = clazz2.getDeclaredMethod(string, classArray);
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility() && ReflectManager.RMSetAccessible(method)) {
                        method2 = method;
                        break;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!clazz2.isInterface() && (classArray2 = clazz2.getSuperclass()) != null) {
                vector.addElement(classArray2);
            }
            classArray2 = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                vector.addElement(classArray2[n]);
                ++n;
            }
        }
        if (method2 != null && (!bl || Modifier.isStatic(method2.getModifiers()))) {
            return method2;
        }
        return null;
    }

    private static Object wrapPrimitive(Object object, Class clazz) throws ReflectError {
        if (object == null) {
            return Primitive.NULL;
        }
        if (clazz == Void.TYPE) {
            return Primitive.VOID;
        }
        if (clazz.isPrimitive()) {
            if (object instanceof Number) {
                return new Primitive((Number)object);
            }
            if (object instanceof Boolean) {
                return new Primitive((Boolean)object);
            }
            if (object instanceof Character) {
                return new Primitive((Character)object);
            }
            throw new ReflectError("Something bad happened");
        }
        return object;
    }

    public static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new InterpreterError("Null arg in getTypes()");
            }
            classArray[n] = objectArray[n] instanceof Primitive ? ((Primitive)objectArray[n]).getType() : objectArray[n].getClass();
            ++n;
        }
        return classArray;
    }

    private static void unwrapPrimitives(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = Reflect.unwrapPrimitive(objectArray[n]);
            ++n;
        }
    }

    private static Object unwrapPrimitive(Object object) {
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    static Object constructObject(String string, Object[] objectArray) throws ReflectError, InvocationTargetException {
        Class clazz = BshClassManager.classForName(string);
        if (clazz == null) {
            throw new ReflectError("Class not found: " + string);
        }
        return Reflect.constructObject(clazz, objectArray);
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + n + ") to constructor for: " + clazz);
            }
            ++n;
        }
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var3_3 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Reflect.unwrapPrimitives(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray = clazz.getDeclaredConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            if (classArray.length == 0) {
                throw new ReflectError("Can't find default constructor for: " + clazz);
            }
            constructor = Reflect.findExtendedConstructor(objectArray, constructorArray);
        }
        if (constructor == null) {
            throw new ReflectError("Can't find constructor: " + clazz);
        }
        try {
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("we don't have permission to create an instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (var3_3 == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return var3_3;
    }

    static Method findMostSpecificMethod(String string, Class[] classArray, Method[] methodArray) {
        int n;
        Vector<Class<?>[]> vector = new Vector<Class<?>[]>();
        Vector<Method> vector2 = new Vector<Method>();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (methodArray[n2].getName().equals(string)) {
                vector2.addElement(methodArray[n2]);
                vector.addElement(methodArray[n2].getParameterTypes());
            }
            ++n2;
        }
        Class[][] classArray2 = new Class[vector.size()][];
        vector.copyInto((Object[])classArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string);
        }
        if ((n = Reflect.findMostSpecificSignature(classArray, classArray2)) == -1) {
            return null;
        }
        return (Method)vector2.elementAt(n);
    }

    static Method findExtendedMethod(String string, Object[] objectArray, Method[] methodArray) {
        Object var3_3 = null;
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            Method method = methodArray[n];
            if (string.equals(method.getName()) && (classArray = method.getParameterTypes()).length == objectArray.length) {
                try {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        objectArray2[n2] = NameSpace.getAssignableForm(objectArray[n2], classArray[n2]);
                        ++n2;
                    }
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                    return method;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        Class[][] classArray2 = new Class[constructorArray.length][];
        int n = 0;
        while (n < classArray2.length) {
            classArray2[n] = constructorArray[n].getParameterTypes();
            ++n;
        }
        int n2 = Reflect.findMostSpecificSignature(classArray, classArray2);
        if (n2 == -1) {
            return null;
        }
        return constructorArray[n2];
    }

    static Constructor findExtendedConstructor(Object[] objectArray, Constructor[] constructorArray) {
        Object var2_2 = null;
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < constructorArray.length) {
            Constructor constructor = constructorArray[n];
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length == objectArray.length) {
                try {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        objectArray2[n2] = NameSpace.getAssignableForm(objectArray[n2], classArray[n2]);
                        ++n2;
                    }
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                    return constructor;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        Class[] classArray3 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < classArray2.length) {
            Class[] classArray4 = classArray2[n2];
            if (Reflect.isAssignable(classArray, classArray4) && (classArray3 == null || Reflect.isAssignable(classArray4, classArray3))) {
                classArray3 = classArray4;
                n = n2;
            }
            ++n2;
        }
        if (classArray3 != null) {
            return n;
        }
        Interpreter.debug("no match found");
        return -1;
    }

    static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if (classArray2 == null) {
            classArray2 = new Class[]{};
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (classArray2[n] != null) {
                if (classArray[n] == null) {
                    if (classArray2[n].isPrimitive()) {
                        return false;
                    }
                } else if (!Reflect.isAssignableFrom(classArray2[n], classArray[n])) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            if (clazz == clazz2) {
                return true;
            }
            if (clazz2 == Byte.TYPE && (clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Short.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Character.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && clazz == Double.TYPE) {
                return true;
            }
        } else if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        return false;
    }

    private static String accessorName(String string, String string2) {
        return string + String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("get", string);
        try {
            clazz.getMethod(string2, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("set", string);
        Class[] classArray = new Class[]{clazz};
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string) throws ReflectError {
        String string2 = Reflect.accessorName("get", string);
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        try {
            try {
                return Reflect.invokeObjectMethod(null, object, string2, objectArray, null);
            }
            catch (EvalError evalError) {
                throw new ReflectError("getter: " + evalError);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectError("Property accessor threw exception:" + invocationTargetException);
        }
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws ReflectError, EvalError {
        String string2 = Reflect.accessorName("set", string);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Reflect.invokeObjectMethod(null, object, string2, objectArray, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EvalError("Property accessor threw exception!");
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName());
            int n = 0;
            while (n < Reflect.getArrayDimensions(clazz)) {
                stringBuffer.append("[]");
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }
}

