#ifndef _NAP_WINIO_H
#define _NAP_WINIO_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include "cmds.h"

struct colortab_s 
{
  char *in;
  int pair, c;
};
typedef struct colortab_s colortab_t;

struct cmds_s 
{
  unsigned char cmd[512];
  struct cmds_s *prev;
  struct cmds_s *next;
};
typedef struct cmds_s cmds_t;

struct scrls_s 
{
  unsigned char ln[256];
  unsigned char d;
  chans_t *chan;
  struct scrls_s *own;
  struct scrls_s *prev;
  struct scrls_s *next;
};
typedef struct scrls_s scrls_t;


#ifndef MCURSES
void resize(void);
#endif

void wstats(WINDOW *);
void drw(WINDOW *);
void dstatus();
void addlog(char *, char *, unsigned char);
int wp(WINDOW *, char *, ...);
scrls_t *scrend(scrls_t *);
void addscroll(WINDOW *, char *);
void dscr(WINDOW *);
void dscroll(WINDOW *, int);
int doesc(WINDOW *, char *);
int cmdcnt(cmds_t *);
cmds_t *cmdend(cmds_t *);
int input(WINDOW *, sock_t *);
void initwin(unsigned char);
void indraw(char *, int, WINDOW *);

#endif /* not _NAP_WINIO_H */
