/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <signal.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ncurses.h>


#include "defines.h"
#include "colors.h"
#include "timer.h"


/* a list of scheduled events. Each carries a time when it is supposed
   to be performed, then deleted. */
ntimer_t *timers;

/* do any time events that are due */
void tevent(int dummy)
{
  time_t t = time(NULL);
  ntimer_t *cur, *last=NULL;  /* last was called n. What is it for? */
  /* struct itimerval tv;   // This is never used */
  
  for (cur=timers;cur;)
  {
    if (cur->t <= t)
    {
      pfunc(cur);
      deltimer(cur);
      cur = timers;  /* this is inelegant: after deleting the element,
			we have to start from the beginning. But note
			that pfunc could have side effects, thus it may not 
			in general work to save cur->next before deleting cur.
		     */
    }
    else
    {
      if (!last || cur->t < last->t)
        last = cur; 
      cur = cur->next;
    }
  }
}

/* print the current timers */
void timerlist(WINDOW *win)
{
  ntimer_t *cur;
  int i, t, min, sec;
  time_t ct = time(NULL);
  
  for (cur=timers,i=0;cur;cur=cur->next,i++)
  {
    t = cur->t-ct;
    min = t/60;
    sec = t%60;
    wp(win, "%s* Timer [%s%i:%02i%s] left:%s %s\n", BRIGHT(BLUE), WHITE, min, sec, BRIGHT(BLUE), WHITE, cur->d);
  }
  
  drw(win);
}

/* perform the function scheduled in t. This uses the general format
   from cmds.c, thus timer events are stored as command strings
   (without the leading '/'). */
void pfunc(ntimer_t *t)
{
  int i, c;
  char dbuf[512];
  
  memset(dbuf, 0, sizeof(dbuf));
  
  strcpy(dbuf+1, t->d);
  dbuf[0] = '/';
  
  /* remove any top-level curly braces */
  /* what is the purpose of this? -PS */
  for (i=0,c=0;dbuf[i];i++)
  {
    if (c < 0)
      c = 0;
    if (dbuf[i] == '{' && !c)
    {
      dbuf[i] = ' ';
      c++;
    }
    else if (dbuf[i] == '{')
      c++;
    else if (dbuf[i] == '}' && c == 1)
    {
      dbuf[i] = ' ';
      c--;
    }
    else if (dbuf[i] == '}')
      c--;
  }
  
  parseout(t->s, dbuf, t->win);
}

void *addtimer(int sec, int s, unsigned char *d, WINDOW *win)
{
  ntimer_t *cur, *cur1=NULL;
  /* struct itimerval tv;   // This is never used */
  time_t t = time(NULL);
  
  if (!timers)
  {
    timers = (ntimer_t *)malloc(sizeof(ntimer_t));
    cur = timers;
  }
  else
  {
    for (cur=timers;cur;cur=cur->next)
      cur1 = cur;
    cur = (ntimer_t *)malloc(sizeof(ntimer_t));
    cur1->next = cur;
  }
  
  cur->t = t+sec;
  cur->d = strdup(d);
  cur->win = win;
  cur->s = s;
  cur->next = NULL;
  
  if (!sec)
  {
    pfunc(cur);
    deltimer(cur);
    return(NULL);
  }
  
  return((void *)cur);
}

void deltimer(void *t)
{
  ntimer_t *cur, *cur1=NULL;
  
  for (cur=timers;cur&&cur!=(ntimer_t *)t;cur=cur->next)
    cur1 = cur;
  
  if (!cur)
    return;
  
  if (cur1)
    cur1->next = cur->next;
  else if (cur->next)
    timers = cur->next;
  else
    timers = NULL;
  
  free(cur->d);
  free(cur);
}
