#ifndef _NAP_MP3S_H
#define _NAP_MP3S_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

/* Physical layout of mp3 header. Note: to ensure portability, we no
   longer read binary data directly into this struct. -PS */
struct hdr_s 
{
  unsigned int
  emph:2,
  original:1,
  copyright:1,
  mode_ext:2,
  mode:2,
  pvt:1,
  pad:1,
  freq:2,
  brate:4,
  prot:1,
  layer:2,
  id:1,
  sync:12;
};
typedef struct hdr_s hdr_t;

/* physical layout of id3v2 header. Note that all fields in this
   struct are byte-sized; thus it should be safe (with respect to
   portability) to read binary data directly into it. */
struct id3v2_s 
{
  unsigned char id[3];
  unsigned char ver, revis;
  unsigned char flags;
  unsigned char size[4];
};
typedef struct id3v2_s id3v2_t;

struct mhdr_s 
{
  unsigned int bitrate;  /* in 1000 bits/sec (or 1024 bits/sec?) */
  unsigned int freq;     /* sample frequency */
  unsigned int len;      /* length in seconds */
  unsigned int sz;       /* size in bytes */
  unsigned char check[32];
};
typedef struct mhdr_s mhdr_t;


int checkhdr(hdr_t *);
hdr_t *getrhdr(int);
mhdr_t *gethdr(char *);
int md5_stream_blocks (int fd, int kb, void *resblock);

#endif
