/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "defines.h"
#include "lists.h"


void addlink(link_t **h, void *d)
{
  link_t *cur, *cur1 = NULL;
  
  if (!(*h))
  {
    *h = (link_t *)malloc(sizeof(link_t));
    cur = *h;
  }
  else
  {
    for (cur=*h;cur;cur=cur->next)
      cur1 = cur;
    cur = (link_t *)malloc(sizeof(link_t));
    cur1->next = cur;
  }
  
  cur->d = d;
  cur->next = NULL;
}

void dellink(link_t **h, void *d)
{
  link_t *cur, *cur1 = NULL;
  
  for (cur=*h;;cur=cur->next)
  {
    if (!cur)
      return;
    if (cur->d == d)
      break;
    cur1 = cur;
  }
  
  if (cur1)
    cur1->next = cur->next;
  else if (cur->next)
    *h = cur->next;
  else
    *h = NULL;
  
  free(cur);
}

void *_findlink(link_t *h, void *d, void *p, unsigned char t)
{
  link_t *cur;
  unsigned int i, pd, hd;
  int *pt;
  char *ptr;
  void *str;
  
  if (!h)
    return(NULL);
  
  if (!t)
  {
    pd = (unsigned int)p;
    hd = (unsigned int)h->d;
    i = abs(pd-hd);
  }
  else
  {
    pt = h->d;
  
    pd = (unsigned int)p;
    hd = (unsigned int)*pt;
    i = abs(pd-hd);
  }
  
  for (cur=h;;cur=cur->next)
  {
    if (!cur)
      return(NULL);
    str = (void *)(*(int *)(cur->d));
    if (!t)
    {
      pt = cur->d+i;
      if (*pt == (int)d)
        return(cur->d);
    }
    else
    {
      ptr = str+i;
      if (!strcasecmp(ptr, (char *)d))
        return(cur->d);
    }
  }
}

void *linknum(link_t *h, int index)
{
  link_t *cur;
  int i;
  
  for (cur=h,i=0;;cur=cur->next,i++)
  {
    if (!cur)
      return(NULL);
    if (i == index)
      return(cur->d);
  }
}

void dellist(link_t **h)
{
  link_t *cur=*h, *cur1=NULL;
  
  while (cur)
  {
    cur1 = cur->next;
    dellink(&cur, cur->d);
    cur = cur1;
  }
  
  *h = NULL;
}
