#include "XCPoint.h"

#undef RELEASE_CODE
#define RELEASE_CODE \
	IXCObject_Release(((XCPoint*)This)->object);

BEGIN_XC_IMPL(XCPoint)

STDMETHODIMP XCPoint_get_x(IXCPoint *This, short *pVal)
{
	XCPoint *p = (XCPoint*)This;
	long handle;
	HRESULT hres;

	if ((hres = IXCObject_get_object_handle(p->object, &handle)) != S_OK)
		return hres;
	*pVal = p->pt->x;

	return S_OK;
}

STDMETHODIMP XCPoint_put_x(IXCPoint *This, short newVal)
{
	XCPoint *p = (XCPoint*)This;
	long handle;
	HRESULT hres;

	if ((hres = IXCObject_get_object_handle(p->object, &handle)) != S_OK)
		return hres;
	p->pt->x = newVal;
	IXCObject_update(p->object, 1);

	return S_OK;
}

STDMETHODIMP XCPoint_get_y(IXCPoint *This, short *pVal)
{
	XCPoint *p = (XCPoint*)This;
	long handle;
	HRESULT hres;

	if ((hres = IXCObject_get_object_handle(p->object, &handle)) != S_OK)
		return hres;
	*pVal = p->pt->y;

	return S_OK;
}

STDMETHODIMP XCPoint_put_y(IXCPoint *This, short newVal)
{
	XCPoint *p = (XCPoint*)This;
	long handle;
	HRESULT hres;

	if ((hres = IXCObject_get_object_handle(p->object, &handle)) != S_OK)
		return hres;
	p->pt->y = newVal;
	IXCObject_update(p->object, 1);

	return S_OK;
}

COM_VTBL_BEGIN(XCPoint)
	XCPoint_get_x,
	XCPoint_put_x,
	XCPoint_get_y,
	XCPoint_put_y,
COM_VTBL_END()

END_XC_IMPL(XCPoint)
