/* $Id: xio-tcpwrap.c,v 1.2 2006/06/08 06:36:31 gerhard Exp $ */
/* Copyright Gerhard Rieger 2006 */
/* Published under the GNU General Public License V.2, see file COPYING */

/* this file contains the source for tcpwrapper handling stuff */

#include "xiosysincludes.h"
#if WITH_LIBWRAP
#include "tcpd.h"
#endif
#include "xioopen.h"

#include "xio-tcpwrap.h"


#if (WITH_TCP || WITH_UDP) && WITH_LIBWRAP

const struct optdesc opt_tcpwrappers = { "tcpwrappers", "tcpwrap", OPT_TCPWRAPPERS, GROUP_RANGE,  PH_ACCEPT, TYPE_STRING_NULL, OFUNC_SPEC };
const struct optdesc opt_tcpwrap_etc               = { "tcpwrap-etc",               "tcpwrap-dir", OPT_TCPWRAP_ETC,               GROUP_RANGE, PH_ACCEPT, TYPE_FILENAME, OFUNC_SPEC };
#if defined(HAVE_HOSTS_ALLOW_TABLE)
const struct optdesc opt_tcpwrap_hosts_allow_table = { "tcpwrap-hosts-allow-table", "allow-table", OPT_TCPWRAP_HOSTS_ALLOW_TABLE, GROUP_RANGE, PH_ACCEPT, TYPE_FILENAME, OFUNC_SPEC };
#endif
#if defined(HAVE_HOSTS_DENY_TABLE)
const struct optdesc opt_tcpwrap_hosts_deny_table  = { "tcpwrap-hosts-deny-table",  "deny-table",  OPT_TCPWRAP_HOSTS_DENY_TABLE,  GROUP_RANGE, PH_ACCEPT, TYPE_FILENAME, OFUNC_SPEC };
#endif


/* they are declared only externaly with libwrap and would be unresolved
   without these definitions */
int allow_severity=10, deny_severity=10;


int xio_retropt_tcpwrap(xiosingle_t *xfd, struct opt *opts) {
   if (retropt_string(opts, OPT_TCPWRAPPERS,
		      &xfd->para.socket.ip.libwrapname) >= 0 ||
       retropt_string(opts, OPT_TCPWRAP_ETC,
		      &xfd->para.socket.ip.tcpwrap_etc) >= 0 ||
#if defined(HAVE_HOSTS_ALLOW_TABLE)
       retropt_string(opts, OPT_TCPWRAP_HOSTS_ALLOW_TABLE,
		      &xfd->para.socket.ip.hosts_allow_table) >= 0 ||
#endif
#if defined(HAVE_HOSTS_DENY_TABLE)
       retropt_string(opts, OPT_TCPWRAP_HOSTS_DENY_TABLE,
		      &xfd->para.socket.ip.hosts_deny_table) >= 0 ||
#endif
       0) {
      xfd->para.socket.ip.dolibwrap = true;
      if (xfd->para.socket.ip.libwrapname == NULL) {
	 xfd->para.socket.ip.libwrapname = (char *)diag_get_string('p');
      }
#if defined(HAVE_HOSTS_ALLOW_TABLE) || defined(HAVE_HOSTS_DENY_TABLE)
      if (xfd->para.socket.ip.tcpwrap_etc) {
	 if (xfd->para.socket.ip.hosts_allow_table == NULL) {
	    xfd->para.socket.ip.hosts_allow_table =
	       Malloc(strlen(xfd->para.socket.ip.tcpwrap_etc)+1+11+1);
	    sprintf(xfd->para.socket.ip.hosts_allow_table, "%s/hosts.allow",
		    xfd->para.socket.ip.tcpwrap_etc);
	 }
	 if (xfd->para.socket.ip.hosts_deny_table == NULL) {
	    xfd->para.socket.ip.hosts_deny_table =
	       Malloc(strlen(xfd->para.socket.ip.tcpwrap_etc)+1+10+1);
	    sprintf(xfd->para.socket.ip.hosts_deny_table, "%s/hosts.deny",
		    xfd->para.socket.ip.tcpwrap_etc);
	 }
      }
#endif /* defined(HAVE_HOSTS_ALLOW_TABLE) || defined(HAVE_HOSTS_DENY_TABLE) */
   }
   return 0;
}


/* returns -1 if forbidden, 0 if no tcpwrap check, or 1 if explicitely allowed
   */
int xio_tcpwrap_check(xiosingle_t *xfd, union sockaddr_union *us,
		      union sockaddr_union *them) {
   char *save_hosts_allow_table, *save_hosts_deny_table;
   struct request_info ri;
   char clientaddr[16], serveraddr[16]; 
   int allow;

   if (!xfd->para.socket.ip.dolibwrap) {
      return 0;
   }

#if defined(HAVE_HOSTS_ALLOW_TABLE)
   save_hosts_allow_table = hosts_allow_table;
   if (xfd->para.socket.ip.hosts_allow_table) {
      Debug1("hosts_allow_table = \"%s\"",
	     xfd->para.socket.ip.hosts_allow_table);
      hosts_allow_table = xfd->para.socket.ip.hosts_allow_table;
   }
#endif /* defined(HAVE_HOSTS_ALLOW_TABLE) */
#if defined(HAVE_HOSTS_DENY_TABLE)
   save_hosts_deny_table  = hosts_deny_table;
   if (xfd->para.socket.ip.hosts_deny_table) {
      Debug1("hosts_deny_table = \"%s\"",
	     xfd->para.socket.ip.hosts_deny_table);
      hosts_deny_table  = xfd->para.socket.ip.hosts_deny_table;
   }
#endif /* defined(HAVE_HOSTS_DENY_TABLE) */
   sprintf(clientaddr, "%u.%u.%u.%u",
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[0],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[1],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[2],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[3]);
   sprintf(serveraddr, "%u.%u.%u.%u",
	   ((unsigned char *)&us->ip4.sin_addr)[0],
	   ((unsigned char *)&us->ip4.sin_addr)[1],
	   ((unsigned char *)&us->ip4.sin_addr)[2],
	   ((unsigned char *)&us->ip4.sin_addr)[3]);

   hosts_access_verbose = 32767;
   Debug15("request_init(%p, RQ_FILE, %d, RQ_CLIENT_SIN, {%u.%u.%u.%u:%u}, RQ_CLIENT_ADDR, %s, RQ_SERVER_SIN, {%u.%u.%u.%u:%u}, RQ_SERVER_ADDR, %s, RQ_DAEMON, \"%s\", 0",
	   &ri, xfd->fd,
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[0],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[1],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[2],
	   ((unsigned char *)&((struct sockaddr_in *)them)->sin_addr)[3],
	   ntohs(((struct sockaddr_in *)them)->sin_port),
	   clientaddr,
	   ((unsigned char *)&us->ip4.sin_addr)[0],
	   ((unsigned char *)&us->ip4.sin_addr)[1],
	   ((unsigned char *)&us->ip4.sin_addr)[2],
	   ((unsigned char *)&us->ip4.sin_addr)[3],
	   ntohs(us->ip4.sin_port),
	   serveraddr,
	   xfd->para.socket.ip.libwrapname?xfd->para.socket.ip.libwrapname:(char *)diag_get_string('p'));
   request_init(&ri, RQ_FILE, xfd->fd,
		RQ_CLIENT_SIN, them,
		RQ_CLIENT_ADDR, clientaddr,
		RQ_SERVER_SIN, &us->soa,
		RQ_SERVER_ADDR, serveraddr,
		RQ_DAEMON, xfd->para.socket.ip.libwrapname?xfd->para.socket.ip.libwrapname:(char *)diag_get_string('p'), 0);
   Debug("request_init() ->");

   Debug1("sock_methods(%p)", &ri);
   sock_methods(&ri);
   Debug("sock_methods() ->");

   Debug1("hosts_access(%p)", &ri);
   allow = hosts_access(&ri);
   Debug1("hosts_access() -> %d", allow);

#if defined(HAVE_HOSTS_ALLOW_TABLE)
   hosts_allow_table = save_hosts_allow_table;
#endif
#if defined(HAVE_HOSTS_DENY_TABLE)
   hosts_deny_table  = save_hosts_deny_table;
#endif
   if (allow == 0) {
      return -1;
   }
   return 1;
}

#endif /* (WITH_TCP || WITH_UDP) && WITH_LIBWRAP */

