/* $Id: tstring.h,v 1.2 2001/03/24 05:38:17 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef TSTRING_H
#define TSTRING_H

/**
 this is originally from gPS (of which I am the author also):
 http://gps.seul.org

 provides a special type of String for tokenizing
 purposes. It provides a method with the same functionality
 of strtok and a method for token advancing. It was written
 when strtok gave me a headache when I introduced POSIX threads
 to gPS. All operations (containment, for example) are performed
 on the current token, not the whole string.
 */
class TString {

 public:

  /// Creates a new empty TString that holds at most l characters.
  TString(int l);

  /// Creates a new TString with the string pointed by s.
  TString(char *s);

  ~TString();

  /// sets the contents of this string to s and resets the token position.  
  void set(char *s);

  /// Moves to start of next token, t contains the token separators.
  char *token(char *t);

  /// Moves token to next position of the next occurrence of a character in t.
  char *advance(char *t); 

  /// Returns a pointer to first occurrence of t in the token, NULL otherwise.
  char *contains(char *t);

 private:
  char *data,*dtoken;
  int initl;
};

#endif
