/* $Id: clock.cc,v 1.7 2002/03/29 05:23:37 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <sys/time.h>
#include <unistd.h>
#include "clock.h"
#include "global.h"

ClockMaster Chronos;

int ChessClock::freeid=1;

ClockMaster::ClockMaster() {
  timeout_on=0;
  timeout_id=-1;
}

void ClockMaster::append(ChessClock *clockp) {
  clocks.push_back(clockp);
  if (!timeout_on) {
    timeout_id=gtk_timeout_add(333,clockmaster_timeout,this);
    timeout_on=1;
  }
}

void ClockMaster::remove(ChessClock *clockp) {
  list<ChessClock *>::iterator li;
  for(li=clocks.begin();li!=clocks.end();li++)
    if ( (*li) == clockp ) {
      clocks.erase(li);
      return;
    }
}

void ClockMaster::update() {
  list<ChessClock *>::iterator it;
  for(it=clocks.begin();it!=clocks.end();it++)
    (*it)->update();
}

gint clockmaster_timeout(gpointer data) {
  ClockMaster *cm;
  cm=(ClockMaster *)data;
  cm->update();
  return 1;
}

// ==================================================================

ChessClock::ChessClock() {
  active=0;
  host=0;
  host2=0;
  mirror=0;
  value[0]=value[1]=0;
  t_ref[0]=t_ref[1]=0;
  val_ref[0]=val_ref[1]=0;
  id=freeid++;
  countdownf=1;

  LastWarning.tv_sec = 0;
  LastWarning.tv_usec = 0;

  Chronos.append(this);
}

ChessClock::~ChessClock() {
  active=0;
  host=0;
  Chronos.remove(this);
}

void ChessClock::setMirror(ChessClock *dest) {
  mirror=dest;
}

void ChessClock::setClock(int whitesec,int blacksec,int activep,int countdown)
{
  global.debug("ChessClock","setClock");
  countdownf=countdown;
  if (whitesec>-999999) {
    value[0]=whitesec;
    t_ref[0]=time(0);
    val_ref[0]=value[0];
  }
  if (blacksec>-999999) {
    value[1]=blacksec;
    t_ref[1]=time(0);
    val_ref[1]=value[1];
  }
  active=activep;
  if (mirror)
    mirror->setClock(whitesec,blacksec,activep,countdown);
}

void ChessClock::setHost(ClockHost *hostp) {
  host=hostp;
}

void ChessClock::setAnotherHost(ClockHost *hostp) {
  host2=hostp;
}

int  ChessClock::getActive() {
  return active;
}

void ChessClock::update() {
  time_t now;
  if ((active)&&(host)) {
    now=time(0);
    if (active<0)
      value[0]=val_ref[0]+(countdownf?-1:1)*(now-t_ref[0]);
    else
      value[1]=val_ref[1]+(countdownf?-1:1)*(now-t_ref[1]);     

    host->updateClock();
    if (host2) host->updateClock();
  }
}

int ChessClock::getValue(int black) {
  return(value[black?1:0]);
}

bool ChessClock::lowTimeWarning(piece mycolor) {
  struct timeval now;
  long gap;

  // only countdown clocks can issue warnings
  if (!countdownf) return false;

  gettimeofday(&now,0);
  
  if (now.tv_sec >= LastWarning.tv_sec) {

    if (now.tv_sec - LastWarning.tv_sec > 10) {
      gap=5000;
    } else {
      gap = 100 * (now.tv_sec - LastWarning.tv_sec);
      gap += (now.tv_usec - LastWarning.tv_usec) / 10000;
    }
    
    if (gap < 100) return false;    

  }

  if (active != 0) {
    
    if ( (active < 0) && (mycolor==WHITE) && (value[0] <= global.LowTimeWarningLimit) ) {
      global.timeRunningOut();
      LastWarning.tv_sec = now.tv_sec;
      LastWarning.tv_usec = now.tv_usec;
      return true;
    }

    if ( (active > 0) && (mycolor==BLACK) && (value[1] <= global.LowTimeWarningLimit) ) {
      global.timeRunningOut();
      LastWarning.tv_sec = now.tv_sec;
      LastWarning.tv_usec = now.tv_usec;
      return true;
    }

  }
 
  return false;
}
