/*
 *	$snafu: gps2.h,v 1.5 2001/12/16 00:56:16 marc Exp $
 *
 *	Placed in the Public Domain by Marco S. Hyman
 */

    /*
     * Garmin GPS layer 2 functions.
     */

    /*
     * Send a buffer containing layer 3 data using garmin layer 2 framing
     * to the device indicated by the GpsHandle.
     *
     *	returns 1 if data sent and acknowledged, -1 if any errors occured.
     */
int gpsSend( GpsHandle gps, const unsigned char * buf, int cnt );

    /*
     * Send an ack for the given packet type.  Return 1 if the packet
     * sent OK, othewise -1.
     */
int gpsSendAck( GpsHandle gps, unsigned char type );

    /*
     * Send a nak for the given packet type. Return 1 if the packet
     * sent OK, othewise -1.
     */
int gpsSendNak( GpsHandle gps, unsigned char type );

    /*
     * Receive a frame from the gps unit indicated by the GpsHandle.
     * Data is put into buf for up to *cnt bytes.  *cnt is updated
     * with the number of bytes actually received.  to specifies
     * a timeout before the start of a message is received.  Use -1
     * to block.
     *
     * Function returns:
     *	1 - data received
     *	0 - timeout
     *	-1 - error
     */
int gpsRecv( GpsHandle gps, int to, unsigned char * buf, int * cnt );

    /*
     * send a frame and wait for an ack/nak.  If nak'd re-send the frame.
     * Return 1 if all ok, -1 if frame can not be sent/is not acknowledged.
     */
int gpsSendWait( GpsHandle gps, const unsigned char * buf, int cnt );
