#!/usr/bin/env python

""" Setup script """

from distutils.core import setup, Extension
from distutils import util

def EnsureScripts(*linuxScripts):
    """
    Creates the proper script names required for each platform
    (taken from 4Suite)
    """
    scripts = linuxScripts
    if util.get_platform()[:3] == 'win':
        scripts = map(lambda s: s + '.bat', scripts)
    return scripts

from __pkginfo__ import modname, version, license, short_desc, long_desc,\
     web, author, author_email

if __name__ == '__main__' :
    dist = setup(name = modname,
                 version = version,
                 license =license,
                 description = short_desc,
                 long_description = long_desc,
                 author = author,
                 author_email = author_email,
                 url = web,
                 package_dir = {'Products.PortalTransforms': '.'},
                 packages = ['Products.PortalTransforms',
                             'Products.PortalTransforms.libtransforms',
                             'Products.PortalTransforms.mime_types',
                             'Products.PortalTransforms.tests',
                             'Products.PortalTransforms.transforms',
                             'Products.PortalTransforms.unsafe_transforms',
                             ],
                 scripts = EnsureScripts('bin/transform',),
                 )
    if dist.have_run.get('install'):
        # create Products.__init__.py if needed
        import os
        install = dist.get_command_obj('install')
        product_init = os.path.join(install.install_lib, 'Products', '__init__.py')
        if not os.path.exists(product_init):
            f = open(product_init, 'w')
            f.write('# generated by the PortalTransforms installer')
            f.close()
        # copy tests data
        import shutil
        product_test = os.path.join(install.install_lib, 'Products', 'PortalTransforms', 'tests')
        test_input = os.path.join(product_test, 'input')
        shutil.copytree(os.path.join('tests', 'input'), test_input)
        test_output = os.path.join(product_test, 'output')
        shutil.copytree(os.path.join('tests', 'output'), test_output)
