/*
 * Sylpheed -- a GTK+ based, lightweight, and fast e-mail client
 * Copyright (C) 2001 Match Grun
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Definitions necessary to access VCard files. VCard files are used
 * by GnomeCard for addressbook, and Netscape for sending business
 * card information. Refer to RFC2426 for more information.
 */

#ifndef __LDIF_H__
#define __LDIF_H__

#include <stdio.h>
#include <glib.h>

#include "addritem.h"
#include "addrcache.h"

#define LDIFBUFSIZE         2048

#define	LDIF_TAG_COMMONNAME "cn"
#define	LDIF_TAG_FIRSTNAME  "givenname"
#define	LDIF_TAG_LASTNAME   "sn"
#define LDIF_TAG_NICKNAME   "xmozillanickname"
#define	LDIF_TAG_EMAIL      "mail"

#define	LDIF_SEP_TAG        ':'

/*
// Typical LDIF entry (similar to that generated by Netscape):
//
// dn: uid=axel, dc=axel, dc=com
// cn: Axel Rose
// sn: Rose
// givenname: Arnold
// xmozillanickname: Axel
// mail: axel@axelrose.com
// mail: axelrose@aol.com
// mail: axel@netscape.net
// mail: axel@hotmail.com
// uid: axelrose
// o: The Company
// locality: Denver
// st: CO
// streetaddress: 777 Lexington Avenue
// postalcode: 80298
// countryname: USA
// telephonenumber: 303-555-1234
// homephone: 303-555-2345
// cellphone: 303-555-3456
// homeurl: http://www.axelrose.com
// objectclass: top
// objectclass: person
//
// Note that first entry is always dn. Empty line defines end of record.
//
*/

/* VCard object */
typedef struct _LdifFile LdifFile;
struct _LdifFile {
	FILE         *file;
	gchar        *path;
	gchar        *bufptr;
	gchar        buffer[ LDIFBUFSIZE ];
	/* AddressCache *addressCache; */
	gint         retVal;
};

/* Function prototypes */
LdifFile *ldif_create	( void );
void ldif_set_file	( LdifFile* ldifFile, const gchar *value );
void ldif_free		( LdifFile *ldifFile );
gint ldif_import_data	( LdifFile *ldifFile, AddressCache *cache );

#endif /* __LDIF_H__ */

