/***************************************************************************
                      fortran_parser.cpp  -  description
                             -------------------
    begin                : jul 10 2005
    author               : 2005 Roberto Quitiliani
    email                : roby(dot)q(AT)tiscali(dot)it
 ***************************************************************************/
 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "plugin_katesymbolviewer.h"

void KatePluginSymbolViewerView::parseFortranSymbols(void)
{
  if (!win->viewManager()->activeView())
   return;

 QString currline;
 QString subrStr("subroutine ");
 QString funcStr("function ");
 QString modStr("module ");

 QString stripped="";
 uint i;
 int fnd,block=0,blockend=0,paro=0,parc=0;
 bool mainprog;

 QListViewItem *node = NULL;
 QListViewItem *subrNode = NULL, *funcNode = NULL, *modNode = NULL;
 QListViewItem *lastSubrNode = NULL, *lastFuncNode = NULL, *lastModNode = NULL;

 QPixmap func( ( const char** ) class_xpm );
 QPixmap subr( ( const char** ) macro_xpm );
 QPixmap mod( ( const char** ) struct_xpm );

 //It is necessary to change names
 popup->changeItem( popup->idAt(2),i18n("Show Subroutines"));
 popup->changeItem( popup->idAt(3),i18n("Show Modules"));
 popup->changeItem( popup->idAt(4),i18n("Show Functions"));


 if(listMode)
  {
   funcNode = new QListViewItem(symbols, symbols->lastItem(), i18n("Functions"));
   subrNode = new QListViewItem(symbols, symbols->lastItem(), i18n("Subroutines"));
   modNode = new QListViewItem(symbols, symbols->lastItem(), i18n("Modules"));
   funcNode->setPixmap(0, (const QPixmap &)func);
   modNode->setPixmap(0, (const QPixmap &)mod);
   subrNode->setPixmap(0, (const QPixmap &)subr);
   lastSubrNode = subrNode;
   lastFuncNode = funcNode;
   lastModNode = modNode;
   symbols->setRootIsDecorated(1);
  }
 else
   symbols->setRootIsDecorated(0);

 Kate::Document *kDoc = win->viewManager()->activeView()->getDoc();

 for (i = 0; i<kDoc->numLines(); i++)
   {
    currline = kDoc->textLine(i);
    currline = currline.stripWhiteSpace();
    currline = currline.simplifyWhiteSpace();
    //Fortran is case insensitive
    currline = currline.lower();
    bool comment = false;
    //kdDebug(13000)<<currline<<endl;
    if(currline.at(0) == '!' || currline.at(0) == 'c') comment = true;
    //block=0;

    mainprog=false;

    if(!comment)
      {
	//Subroutines
	if(currline.startsWith(subrStr) || currline.startsWith("program "))
	{
		block=1;
		stripped="";
	}
	//Modules
	else if(currline.startsWith(modStr))
	{
		block=2;
		stripped="";
	}
 	else if(((currline.startsWith("real") || currline.startsWith("double") || currline.startsWith("integer") || currline.startsWith("character")) || currline.startsWith("logical")) && currline.find(funcStr) > 0)
	{
		block=3;
		stripped="";
	}
	
	//Subroutines
	if(block==1)
	{
		if(currline.startsWith("program "))
			mainprog=true;
		if (macro_on == true) // not really a macro, but a subroutines
		{
			stripped += currline.right(currline.length());
			stripped = stripped.simplifyWhiteSpace();
			stripped.replace("*","");
			stripped.replace("+","");
			stripped.replace("$","");
			if(blockend==0){
				fnd = stripped.find(' ');
				stripped = currline.right(currline.length()-fnd-1);
			}
			stripped.replace(" ","");
			fnd = stripped.find("!");
			if(fnd>0){
				stripped = stripped.left(fnd);
			}
			paro+=currline.contains(')',FALSE);
			parc+=currline.contains('(',FALSE);
			
			if((paro==parc || mainprog) && stripped.endsWith("&",FALSE)==FALSE){
				stripped.replace("&","");
				if(mainprog && stripped.find('(')<0 && stripped.find(')')<0)
					stripped.prepend("Main: ");
				if(stripped.find("=")==-1){
					if (listMode)
					{
						node = new QListViewItem(subrNode, lastSubrNode, stripped);
						lastSubrNode = node;
					}
					else
						node = new QListViewItem(symbols, symbols->lastItem(), stripped);
					node->setPixmap(0, (const QPixmap &)subr);
					node->setText(1, QString::number( i, 10));
				}
				stripped="";
				block=0;
				blockend=0;
				paro=0;
				parc=0;
			}else{
				blockend=1;
			}
		}
	}

	//Modules
	else if(block==2)
	{
		if (struct_on == true) // not really a struct, but a module
		{
			stripped = currline.right(currline.length());
			stripped = stripped.simplifyWhiteSpace();
			fnd = stripped.find(' ');
			stripped = currline.right(currline.length()-fnd-1);
			fnd = stripped.find('!');
			if(fnd>0){
				stripped = stripped.left(fnd);
			}
			if(stripped.find('=')==-1){
				if (listMode)
				{
					node = new QListViewItem(modNode, lastModNode, stripped);
					lastModNode = node;
				}
				else
					node = new QListViewItem(symbols, symbols->lastItem(), stripped);
				node->setPixmap(0, (const QPixmap &)mod);
				node->setText(1, QString::number( i, 10));
			}
			stripped = "";
		}
		block=0;
		blockend=0;
	}

	//Functions
	else if(block==3)
	{
		if (func_on == true)
		{
			stripped += currline.right(currline.length());
			stripped = stripped.stripWhiteSpace();
			stripped.replace( "function", "" );
			stripped.replace("*","");
			stripped.replace("+","");
			stripped.replace("$","");
			stripped = stripped.simplifyWhiteSpace();
			fnd = stripped.find('!');
			if(fnd>0){
				stripped = stripped.left(fnd);
			}
			stripped = stripped.stripWhiteSpace();
			paro+=currline.contains(')',FALSE);
			parc+=currline.contains('(',FALSE);

			if(paro==parc && stripped.endsWith("&",FALSE)==FALSE){
				stripped.replace("&","");
				if (listMode)
				{
					node = new QListViewItem(funcNode, lastFuncNode, stripped);
					lastFuncNode = node;
				}
				else
					node = new QListViewItem(symbols, symbols->lastItem(), stripped);
				node->setPixmap(0, (const QPixmap &)func);
				node->setText(1, QString::number( i, 10));
				stripped = "";
				block=0;
				paro=0;
				parc=0;
			}
			blockend=0;
		}
	}
	}
    } //for i loop
}

