/*
 * Resource handle helper functions
 * (C) 2006, Pascal Schmidt <arena-language@ewetel.net>
 * see file ../doc/LICENSE for license
 */

#include <stdio.h>
#include <stdlib.h>

#include "stdlib.h"

/*
 * Initialize handle management
 *
 * Returns a pointer to a new allocated handle management
 * structure. 
 */
handles *handle_init(void)
{
  return oom(calloc(1, sizeof(handles)));
}

/*
 * Free handles structure
 */
void handle_free(handles *h)
{
  free(h->entries);
  free(h);
}

/*
 * Add handle
 *
 * Associates data with a new handle. Returns the new handle
 * or -1 on failure.
 */
int handle_add(handles *h, void *data)
{
  int i;
  void **list;
  
  if (!h || !data) {
    return -1;
  }
  
  for (i = 0; i < h->count; i++) {
    if (!h->entries[i]) {
      h->entries[i] = data;
      return i + 1;
    }
  }
  
  list = oom(realloc(h->entries, (h->count + 1) * sizeof(void *)));

  h->entries = list;
  h->entries[h->count++] = data;
  return h->count;
}

/*
 * Get data from handle
 *
 * Returns the data pointer associated with a given handle or
 * NULL on failure.
 */
void *handle_get(handles *h, int handle)
{
  if (!h || handle < 1 || handle > h->count) {
    return NULL;
  }
  return h->entries[handle - 1];
}

/*
 * Remove handle
 *
 * Removes the data pointer associated with the given handle.
 */
void handle_del(handles *h, int handle)
{
  if (!h || handle < 1 || handle > h->count) {
    return;
  }

  if (handle < h->count) {
    h->entries[handle - 1] = NULL;
  } else if (h->count > 1) {
    void **list;
    list = realloc(h->entries, (h->count - 1) * sizeof(void *));
    if (list) {
      h->entries = list;
    }
    --h->count;
  } else {
    free(h->entries);
    h->entries = NULL;
    h->count = 0;
  }
}
