/*
 * Parse file
 * (C) 2006, Pascal Schmidt <arena-language@ewetel.net>
 * see file ../doc/LICENSE for license
 */

#include <stdio.h>
#include <stdlib.h>

#include "parser.h"
#include "y.tab.h"

extern FILE *yyin;

void yyparse(void);

/*
 * Tear down internal parser memory
 */
static void parse_teardown(void)
{
  parser_include_teardown();
  expr_stack_teardown();
  expr_arg_teardown();
  stmt_stack_teardown();
  stmt_arg_teardown();
}

/*
 * Parse file
 *
 * This function tries to parse the given file and returns the
 * resulting statement list.
 */
stmt_list *parse_file(char *path)
{
  FILE *file;
  
  sanity(path);
  
  source_file = path;

  file = fopen(path, "r");
  if (!file) {
    source_line = 0;
    fatal("could not open input file");
  }

  atexit(parse_teardown);

  stmt_stack_enter();

  yyin = file;
  yyparse();
  fclose(file);
  if (parser_error != 0) {
    stmt_stack_leave(1);
    return NULL;
  }
  
  return stmt_stack_leave(0);
}
