/*
 * XFMail sound handler code
 * Graham Biswell <graham@tarka.demon.co.uk>
 * patches by Thomas Pundt <pundtt@ESCHER.UNI-MUENSTER.DE>
 * NAS support by Warren Stockton <wns@knysna.slc.unisys.com>
 *
 * Patched and modified by Gennady B. Sorokopud <gena@netvision.net.il>
 */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#ifdef NAS_SOUND
    #include <audio/audiolib.h>
    #include <audio/soundlib.h>
#endif

/*
 * This comes from some /etc/magic to check the .au file header
 */
#define AUDIO_DATA_SUN_BIG_ENDIAN   0x2e736e64
#define AUDIO_DATA_SUN_LITTLE_ENDIAN    0x646e732e

/*
 * play the audio file specified as soundfile, to the audio device AUDIO_DEVICE
 * with specified volume volume.
 * returns 0 on success, -1 on error
 */
int play_sound(char *soundfile, int volume) {
#ifdef  USE_SOUND
    #ifdef NAS_SOUND
    AuServer *aud;
    char *auservername = NULL;

    aud = AuOpenServer(auservername, 0, NULL, 0, NULL, NULL);
    if(!aud)
        return -1;
    if(!AuSoundPlaySynchronousFromFile(aud, soundfile, volume)) {
        AuCloseServer(aud);
        return 0;
    } else {
        AuCloseServer(aud);
        return -1;
    }
    #else
    int fd_snd, fd_audio, nb;
    int snd_buf[256];

    /* first open sound file */
    if((fd_snd = open(soundfile, O_RDONLY)) < 0) {
        display_msg(MSG_WARN, "play_sound", "Can not open %s", soundfile);
        return -1;
    }

    /* now open audio file */
    if((fd_audio = open(AUDIO_DEVICE, O_WRONLY | O_NONBLOCK)) < 0) {
        if(errno != EBUSY)
            display_msg(MSG_WARN, "play_sound", "Can not open %s",
                        AUDIO_DEVICE);
        close(fd_snd);
        return -1;
    }

    /* now set device volume */
    /* this is not implemented yet */

    /* check if sound file is a valid audio file (SUN au file) */
    read(fd_snd, snd_buf, 24);
    if(snd_buf[0] != AUDIO_DATA_SUN_BIG_ENDIAN &&
       snd_buf[0] != AUDIO_DATA_SUN_LITTLE_ENDIAN) {
        display_msg(MSG_WARN, "play_sound", "%s is not a vaild audio file",
                    soundfile);
        close(fd_snd);
        close(fd_audio);
        return -1;
    }

    /*
     * The Sox documentation says, that the header length is a multiple
     * of 24, given in position 1 of the header.
     */
    if(htonl(snd_buf[1]) > 24) {
        /* Skip the header */
        if(lseek(fd_snd, htonl(snd_buf[1]), SEEK_SET) == -1) {
            display_msg(MSG_WARN, "play_sound",
                        "Invalid header length in audio file");
            close(fd_snd);
            close(fd_audio);
            return -1;
        }
    }

    /* now play sound file */
    while((nb = read(fd_snd, snd_buf, 256)) > 0) {
        if((write(fd_audio, snd_buf, nb)) < 0) {
            display_msg(MSG_WARN, "play_sound", "Write failed\n%s",
                        AUDIO_DEVICE);
            close(fd_snd);
            close(fd_audio);
            return -1;
        }
    }

    /* tidy up & exit */
    close(fd_audio);
    close(fd_snd);
    return 0;
    #endif
#else
    display_msg(MSG_WARN, "play_sound",
                "Sound is not supported in this version of XFMail");
    return -1;
#endif /* USE_SOUND */
}
