/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    AuthPanel authenticator;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    String host;
    int port;
    String passwordParam;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;

    void connectAndAuthenticate() throws IOException {
        if (this.passwordParam != null) {
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
                this.vncFrame.show();
            } else {
                this.validate();
            }
            if (!this.tryAuthenticate(this.passwordParam)) {
                throw new IOException("VNC authentication failed");
            }
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, gridBagConstraints);
        this.vncContainer.add(this.authenticator);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
            this.authenticator.moveFocusToPasswordField();
        }
        while (true) {
            AuthPanel authPanel = this.authenticator;
            synchronized (authPanel) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.tryAuthenticate(this.authenticator.password.getText())) break;
            this.authenticator.retry();
        }
        this.vncContainer.remove(this.authenticator);
    }

    public void destroy() {
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public void disconnect() {
        System.out.println("Disconnect");
        this.options.dispose();
        this.clipboard.dispose();
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            if (this.rfb != null) {
                this.rfb.close();
                this.rfb = null;
            }
            Label label = new Label("Disconnected");
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            this.rfbThread.stop();
        } else {
            System.exit(0);
        }
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    public void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            if (this.rfb != null) {
                this.rfb.close();
                this.rfb = null;
            }
            Label label = new Label(string);
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public void init() {
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        this.authenticator = new AuthPanel();
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToPasswordField();
            }
        }
    }

    int readIntParameter(String string, int n) {
        int n2;
        block2: {
            String string2 = this.readParameter(string, false);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(String.valueOf(string) + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(String.valueOf(string) + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(String.valueOf(string) + " parameter not specified");
        }
        return null;
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", this.inAnApplet ^ true);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.passwordParam = this.readParameter("PASSWORD", false);
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.options.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (this.inSeparateFrame) {
                Panel panel = new Panel();
                panel.setLayout(new FlowLayout(0, 0, 0));
                panel.add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.desktopScrollPane.add(panel);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gridBagConstraints);
                this.add(this.vc);
                this.validate();
            }
            if (this.options.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.vc.processNormalProtocol();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fatalError(exception.toString());
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean tryAuthenticate(String string) throws IOException {
        this.rfb = new RfbProto(this.host, this.port, this);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int n = this.rfb.readAuthScheme();
        block0 : switch (n) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                byte[] byArray = new byte[16];
                this.rfb.is.readFully(byArray);
                if (string.length() > 8) {
                    string = string.substring(0, 8);
                }
                byte[] byArray2 = new byte[8];
                System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
                DesCipher desCipher = new DesCipher(byArray2);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.rfb.os.write(byArray);
                int n2 = this.rfb.is.readInt();
                switch (n2) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new IOException("VNC authentication failed - too many tries");
                    }
                }
                throw new IOException("Unknown VNC authentication result " + n2);
            }
            default: {
                throw new IOException("Unknown VNC authentication scheme " + n);
            }
        }
        return false;
    }

    public void update(Graphics graphics) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToPasswordField();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

