/* $Id: mainwindow.h,v 1.44 2001/09/09 17:40:49 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef EBOARD_MAINWINDOW_H
#define EBOARD_MAINWINDOW_H 1

#include "eboard.h"
#include "widgetproxy.h"
#include "notebook.h"
#include "board.h"
#include "text.h"
#include "util.h"
#include "status.h"
#include "protocol.h"
#include "history.h"
#include "dlg_about.h"
#include "dlg_connect.h"
#include "dlg_gamelist.h"
#include "dlg_prefs.h"
#include "help.h"
#include "promote.h"
#include "script.h"
#include "stl.h"

class ThemeEntry {
 public:
  bool isDupe(ThemeEntry *te);
  bool isNameDupe(ThemeEntry *te);
  char Filename[128];
  char Text[128];
};

// ask about our multiple inheritance contest

class MainWindow : public WidgetProxy, 
		   public InputHandler,
		   public ConnectionHandler,
                   public GameListListener,
                   public StockListListener,
		   public AdListListener,
                   public ConsoleListener,
                   public PaneChangeListener
{
 public:
  MainWindow();
  void setPasswordMode(int pm);
  void openServer(char *host,int port,ProtocolParser *protocol,char *helper);
  void openGameList();
  void openAdList();
  void openStockList();
  void openDetachedConsole();

  void gameListClosed();
  void stockListClosed();
  void adListClosed();
  void consoleClosed();

  void paneChanged(int pgseq,int pgid);
  void userInput(char *text);
  void peekKeys(GtkWidget *who);

  void restoreDesk();

  static GdkWindow *RefWindow;

 private:
  int HideMode; // password
  GtkItemFactory  *gif;
  GtkWidget       *v;
  GtkWidget       *menubar;
  GtkWidget       *inputbox;
  Notebook        *notebook;
  TextSet         *icsout;
  Text            *inconsole;
  Status          *status;
  PromotionPicker *promote;

  GameListDialog  *gamelist;
  StockListDialog *stocklist;
  AdListDialog    *adlist;
  ScriptList      *scriptlist;
  DetachedConsole *consolecopy;

  GtkTooltips *tooltips;
  GtkWidget *navbar[7];
  bool nav_enable[7];

  GtkWidget *picseal;
  GdkPixmap *sealmap[2];
  GdkBitmap *sealmask[2];
  GtkWidget *vector_checkbox;

  History   *InputHistory;

  void createNavbar(GtkWidget *box);
  void createSealPix(GtkWidget *box);

  void setSealPix(int flag);

  void setTitle(char *msg);
  void searchThemes();
  void parseThemeFile(char *name);
  void greet();

  void injectInput();
  void historyUp();
  void historyDown();
  void tryConnect(char *host,int port,ProtocolParser *protocol,char *helper);
  void cleanUpConnection();
  void disconnect();

  void openEngine(XBoardProtocolParser *xpp);
  void openGnuChess4();
  void openCrafty();
  void openSjeng();
  void openXBoardEngine();

  void gameWalk(int op);

  void saveDesk();

  int hook_count;
  void decrementHook();
  void incrementHook();

  list<ThemeEntry *> Themes;

  friend void mainwindow_themeitem(GtkMenuItem *menuitem, gpointer data);
  friend void mainwindow_themeitem2(GtkMenuItem *menuitem, gpointer data);
  friend void mainwindow_themeitem3(GtkMenuItem *menuitem, gpointer data);

  friend int  input_key_press (GtkWidget * wid, GdkEventKey * evt,
			       gpointer data);
  friend int  main_key_press (GtkWidget * wid, GdkEventKey * evt,
			      gpointer data);

  friend void     peer_connect_fics(gpointer data);

  friend void     peer_connect_xboard(gpointer data);
  friend void     peer_connect_gnuchess4(gpointer data);
  friend void     peer_connect_sjeng(gpointer data);
  friend void     peer_connect_crafty(gpointer data);

  friend void     peer_connect_ask(gpointer data);
  friend void     peer_disconnect(gpointer data);
  friend void     help_about(gpointer data);
  friend void     help_keys(gpointer data);
  friend gboolean mainwindow_idle_hook(gpointer data);
  friend void     mainwindow_icsout_changed(GtkEditable *gtke, gpointer data);

  friend void     navbar_back_all(GtkWidget *w,gpointer data);
  friend void     navbar_back_1(GtkWidget *w,gpointer data);
  friend void     navbar_forward_1(GtkWidget *w,gpointer data);
  friend void     navbar_forward_all(GtkWidget *w,gpointer data);
  friend void     navbar_movelist(GtkWidget *w,gpointer data);
  friend void     navbar_trash(GtkWidget *w,gpointer data);
  friend void     navbar_flip(GtkWidget *w,gpointer data);

  friend void     sett_hilite(GtkWidget *w,gpointer data);
  friend void     sett_animate(GtkWidget *w,gpointer data);
  friend void     sett_premove(GtkWidget *w,gpointer data);
  friend void     sett_coord(GtkWidget *w,gpointer data);
  friend void     sett_beepopp(GtkWidget *w,gpointer data);
  friend void     sett_osound(GtkWidget *w,gpointer data);
  friend void     sett_vector(GtkWidget *w,gpointer data);
  friend void     sett_legal(GtkWidget *w,gpointer data);
  friend void     sett_popup(GtkWidget *w,gpointer data);
  friend void     sett_smarttrash(GtkWidget *w,gpointer data);

  friend void windows_savedesk(GtkWidget *w, gpointer data);
};

void sett_prefs(gpointer data);

gint mainwindow_delete  (GtkWidget * widget, GdkEvent * event, gpointer data);
void mainwindow_destroy (GtkWidget * widget, gpointer data);

void game_resign(GtkWidget *w,gpointer data);
void game_draw(GtkWidget *w,gpointer data);
void game_adjourn(GtkWidget *w,gpointer data);
void game_abort(GtkWidget *w,gpointer data);

void windows_games(GtkWidget *w, gpointer data);
void windows_sough(GtkWidget *w, gpointer data);
void windows_stock(GtkWidget *w, gpointer data);
void windows_detached(GtkWidget *w, gpointer data);
void windows_script(GtkWidget *w, gpointer data);

// keep focus on input box
gboolean mainwindow_gcp_about_to_get_angry(GtkWidget *widget,GdkEventFocus *event,gpointer user_data);
gboolean keep_gcp_cool(gpointer data);

gboolean do_smart_remove(gpointer data);

#endif
