<?php
    /**
     * Utility functions
     *
     * @package core
     */

	/**
	 * Function which reads the XML. This XML is send by the WebClient.
	 * @return string XML	
	 */
	function readXML() {
		$xml = "";
		$putData = fopen("php://input", "r");
		
		while($block = fread($putData, 1024)) 
		{
			$xml .= $block;
		}
		
		fclose($putData);
		return $xml;
	}	
	
	/**
	 * Function which is called every time the "session_start" method is called.
	 * It unserializes the objects in the session. This function called by PHP.
	 * @param string @className the className of the object in the session
	 */	 	
	function sessionModuleLoader($className)
	{
		$className = strtolower($className); // for PHP5 set className to lower case to find the file (see ticket #839 for more information)

		switch($className)
		{
			case "bus":
				require_once("core/class.bus.php");
				break;
				
			default:
				if(array_search($className, $GLOBALS["availableModules"])!==false) {
					require_once("modules/class." . $className . ".php");
				}
				break;
		}
		if (!class_exists($className)){
			trigger_error("Can't load ".$className." while unserializing the session.", E_USER_WARNING);
		}
	}

	/**
	 * Function which returns a list of available modules.
	 * @return array a list of available modules	 
	 */	 	
	function getAvailableModules()
	{
		$modules = array();
		$dir = opendir("server/modules");
		
		while(($file = readdir($dir)) !== false)
		{
			$file = substr($file,6,-4);
			if ($file !== false && substr($file,-6)=="module"){
				array_push($modules, $file);
			}
		}
		
		return $modules;
	}
	
	/**
	 * Function which replaces some characters to correct XML values.
	 * @param string @string string which should be converted
	 * @return string correct XML	 
	 */	 	
	function xmlentities($string) {
		$string = str_replace("\x00", "", $string);
		$string = preg_replace("/[\x01-\x08\x0b\x0c\x0e-\x1f]+/", "", $string); // remove control chars, they would break the xml, and aren't needed anyway
		return str_replace ( array ( '&', '"', "'", '<', '>'), array ( '&amp;' , '&quot;', '&apos;' , '&lt;' , '&gt;'), $string );
	}
	
	/**
	 * Function which checks if an array is an associative array.
	 * @param array $data array which should be verified
	 * @return boolean true if the given array is an associative array, false if not
	 */	 	
	function is_assoc_array($data) {
		return is_array($data) && !empty($data) && !preg_match('/^\d+$/', implode('', array_keys($data)));
	}
	
	/**
	 * Function which compares two users on there full name. Used for sorting the user list.
	 * @param array $a user
	 * @param array $b user
	 * @return integer -1 - $a < $b || 0 - equal || 1 - $a > $b
	 */	 	
	function cmpUserList($a, $b) {
		if (strtolower($a["fullname"]) == strtolower($b["fullname"])) {
			return 0;
		}
		
		return (strtolower($a["fullname"]) < strtolower($b["fullname"])) ? -1 : 1;
	}
	
	/**
	 * Function which compares two groups on there group name. Used for sorting the group list.
	 * @param array $a group
	 * @param array $b group
	 * @return integer -1 - $a < $b || 0 - equal || 1 - $a > $b
	 */	 	
	function cmpGroupList($a, $b) {
		if (strtolower($a["groupname"]) == strtolower($b["groupname"])) {
			return 0;
		}
		
		return (strtolower($a["groupname"]) < strtolower($b["groupname"])) ? -1 : 1;
	}
	
	/**
	 * Function which is simular to the php function array_merge_recursive, but this 
	 * one overwrites duplicates.
	 * @param array $array1 array
	 * @param array $array1 array
	 * @return array merged array	 	 	 
	 */
	function array_merge_recursive_overwrite($array1, $array2)
	{
		if (!is_array($array1) || !is_array($array2)) {
			return $array2;
		}
		
		foreach ($array2 as $key=>$value) {
			if (isset($array1[$key])){
				$array1[$key] = array_merge_recursive_overwrite($array1[$key], $value);
			}else{
				$array1[$key] = $value;
			}
		}
		return $array1;
	}
	
	/**
	 * Function which adds a download url for inline attachments in mail body's.
	 * This function is called in the filter class (it is a preg_replace_callback function)
	 * @param array $match the information which part of the body is found.
	 * @return string download string	 	 	 
	 */
	function inline_attachments($match)
	{
		if(array_key_exists("2", $match)) {
			return "='" . BASE_URL . "index.php?load=download_attachment&store=" . $GLOBALS["preg_replace"]["storeid"] . "&amp;entryid=" . $GLOBALS["preg_replace"]["entryid"] . "&amp;attachCid=" . $match[2] . "&amp;openType=inline'";
		} else {
			return "=''";
		}
	}
	
	/**
	 * Function which adds a new mail popup on links which are mail addresses in mail body's.
	 * This function is called in the filter class (it is a preg_replace_callback function)
	 * @param array $match the information which part of the body is found.
	 * @return string new mail popup string	 	 	 
	 */
	function mailto_newmail($match)
	{
		$js_options = "'toolbar=0,scrollbars=1,location=0,status=1,menubar=0,resizable=1,width=780,height=560,top='+((screen.height/2)-280)+',left='+((screen.width/2)-390)";
		$newMail = array("TO"=>$match[4]);
		
		if (!empty($match[5])) {
			$subject = preg_replace('/.*subject=(.*)/mis','$1',$match[5]);
			$newMail['SUBJECT'] = $subject;
		}
		
		// 'encode' newMail array
		$newMailString = bin2hex(serialize($newMail)); 
		return '<'.$match[1].$match[2].'='.$match[3].'mailto:'.$match[4].(!empty($match[5])?'?'.$match[5]:'').$match[6].' onclick='."\"parent.webclient.openWindow(this, 'createmail', 'index.php?load=dialog&task=createmail_standard&to=".$newMail['TO']."'); return false;\"".$match[7].'>';
	}


	function microtime_float() {
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}


	function getMaxUploadSize($as_string = false)
	{
		$value = strtoupper(ini_get('upload_max_filesize'));
		// calculate value to bytes
		if (strpos($value, "K")!== false){
			$value = ((int)$value) * 1024;
		} else if (strpos($value, "M")!== false){
			$value = ((int)$value) * 1024 * 1024;
		} else if (strpos($value, "G")!== false){
			$value = ((int)$value) * 1024 * 1024 * 1024; 
		}
		
		if ($as_string){
			// make user readable string
			if ($value>1073741824){
				$value = round($value/1073741824, 1) ." ". _("GB");
			}else if ($value>1048576){
				$value = round($value/1048576, 1) ." ". _("MB");
			}else if ($value>1024){
				$value = round($value/1024, 1) ." ". _("KB");
			}else{
				$value = $value ." ". _("B");
			}
		}

		return $value;
	}

	function cleanTemp($directory = TMP_PATH)
	{
		if (!is_dir($directory)){
			return;
		}

		$dir = opendir($directory);

		while($file = readdir($dir)) {
			if (!is_dir($directory . "/" . $file)){
				$fileinfo = stat($directory . "/" . $file);

				if($fileinfo && $fileinfo["atime"] < time() - ini_get("session.gc_maxlifetime")) {
					unlink($directory . "/" . $file);
				}
			}
		}
	}

	function cleanSearchFolders()
	{
		$store = $GLOBALS["mapisession"]->getDefaultMessageStore();

		$storeProps = mapi_getprops($store, array(PR_STORE_SUPPORT_MASK, PR_FINDER_ENTRYID));
		if (($storeProps[PR_STORE_SUPPORT_MASK] & STORE_SEARCH_OK)!=STORE_SEARCH_OK) {
			return;
		}

		$finderfolder = mapi_msgstore_openentry($store, $storeProps[PR_FINDER_ENTRYID]);
		if (mapi_last_hresult()!=0){
			return;
		}
		
		$hierarchytable = mapi_folder_gethierarchytable($finderfolder);
		mapi_table_restrict($hierarchytable, array(RES_AND, 
												array(
													array(RES_CONTENT, 
														array(
															FUZZYLEVEL	=> FL_PREFIX,
															ULPROPTAG	=> PR_DISPLAY_NAME,
															VALUE		=> array(PR_DISPLAY_NAME=>"WebAccess Search Folder")
														)
													),
													array(RES_PROPERTY,
														array(
															RELOP		=> RELOP_LT,
															ULPROPTAG	=> PR_LAST_MODIFICATION_TIME,
															VALUE		=> array(PR_LAST_MODIFICATION_TIME=>(time()-ini_get("session.gc_maxlifetime")))
														)
													)
												)
											)
		);

		$folders = mapi_table_queryallrows($hierarchytable, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_LAST_MODIFICATION_TIME));
		foreach($folders as $folder){
			mapi_folder_deletefolder($finderfolder, $folder[PR_ENTRYID]);
		}
	}

	function dechex_32($dec){
		// Because on 64bit systems PHP handles integers as 64bit, 
		// we need to convert these 64bit integers to 32bit when we 
		// want the hex value 
		$result = unpack("H*",pack("N", $dec));
		return $result[1];
	}

	// PHP4 version of stripos
	if (!function_exists("stripos")) {
		function stripos($str,$needle,$offset=0)
		{
			return strpos(strtolower($str),strtolower($needle),$offset);
		}
	}

?>
