<?php
	/**
	* Upload Attachment
	* This file is used to upload an file.
	*/

	// Check if dialog_attachments is set
	if(isset($_POST["dialog_attachments"])) {
		// Check if the file is uploaded correctly and is not above the MAX_FILE_SIZE
		if(isset($_FILES["attachments"]) && is_array($_FILES["attachments"])) {
			if(isset($_FILES['attachments']['name']) && is_array($_FILES['attachments']['name'])){
				foreach($_FILES['attachments']['name'] as $key => $name){
					$FILE = Array(
						'name'     => $_FILES['attachments']['name'][$key],
						'type'     => $_FILES['attachments']['type'][$key],
						'tmp_name' => $_FILES['attachments']['tmp_name'][$key],
						'error'    => $_FILES['attachments']['error'][$key],
						'size'     => $_FILES['attachments']['size'][$key]
					);

					if (!empty($FILE["size"]) && !(isset($_POST["MAX_FILE_SIZE"]) && $FILE["size"] > $_POST["MAX_FILE_SIZE"])) {
						// Create unique tmpname
						$tmpname = tempnam(TMP_PATH, stripslashes($FILE["name"]));
						// Move the uploaded file the the tmpname
						$result = move_uploaded_file($FILE["tmp_name"], $tmpname);

						// Check if there are no files uploaded
						if(!isset($_SESSION["files"])) {
							$_SESSION["files"] = array();
						}
						
						// Check if no files are uploaded with this dialog_attachments
						if(!isset($_SESSION["files"][$_POST["dialog_attachments"]])) {
							$_SESSION["files"][$_POST["dialog_attachments"]] = array();
						}

						// stripping path details
						$tmpname = basename($tmpname);

						// Add file information to the session
						$_SESSION["files"][$_POST["dialog_attachments"]][$tmpname] = Array("name" => utf8_to_windows1252(stripslashes($FILE["name"])),
																				 "size" => $FILE["size"],
																				 "type" => $FILE["type"]);
					} 
				}
			}
		} else if(isset($_POST["deleteattachment"]) && isset($_POST["type"])) { // Delete uploaded file
			// Check if the delete file is an uploaded or an attachment of a MAPI iMessage
			if($_POST["type"] == "new") {
				// Get the tmpname of the uploaded file
				$tmpname = urldecode($_POST["deleteattachment"]);

				if(isset($_SESSION["files"][$_POST["dialog_attachments"]][$tmpname])) {
					unset($_SESSION["files"][$_POST["dialog_attachments"]][$tmpname]);
					// Delete file
					if (is_file($tmpname)) {
						unlink($tmpname);
					} 
				} 
			} else { // The file is an attachment of a MAPI iMessage
				// Set the correct array structure
				if(!isset($_SESSION["deleteattachment"])) {
					$_SESSION["deleteattachment"] = array();
				}
				
				if(!isset($_SESSION["deleteattachment"][$_POST["dialog_attachments"]])) {
					$_SESSION["deleteattachment"][$_POST["dialog_attachments"]] = array();
				}
				
				// Push the number of the attachment to the array structure
				array_push($_SESSION["deleteattachment"][$_POST["dialog_attachments"]], $_POST["deleteattachment"]);
			}
		}
	}

// Return the file data output when client has request this page through the load==upload_attachment
if($_GET['load'] == 'upload_attachment'){
	if(isset($_SESSION["files"]) && isset($_SESSION["files"][$_REQUEST["dialog_attachments"]])) {
		foreach($_SESSION["files"][$_REQUEST["dialog_attachments"]] as $tmpname => $file){
			// Echo tmpname | filename | size
			echo windows1252_to_utf8($tmpname) . "|" . windows1252_to_utf8($file["name"]) . "|" . $file["size"] . "||";
		}
	}
}

?>
