<?php
	/**
	 * ResolveNames Module
	 * @author Michael Erkens <m.erkens@zarafa.com>
	 */
	class ResolveNamesModule extends Module
	{
		/**
		 * Constructor
		 */
		function ResolveNamesModule($id, $data)
		{
			parent::Module($id, $data);
		}

		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			$result = false;
	
			foreach($this->data as $action)
			{
				if(isset($action["attributes"]) && isset($action["attributes"]["type"])) {
					$store = $this->getActionStore($action);
					$parententryid = $this->getActionParentEntryID($action);
					$entryid = $this->getActionEntryID($action);
				
					switch($action["attributes"]["type"])
					{
						case "checknames":
							$result = $this->checkNames($store, $action);
							break;
					}
				}
			}
		}
		
		/**
		 * Function which checks the names, sent by the client. This function is used
		 * when a user wants to sent an email and want to check the names filled in
		 * by the user in the to, cc and bcc field. This function uses the global
		 * user list of Zarafa to check if the names are correct.		 		 		 
		 * @param object $store MAPI Message Store Object
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function checkNames($store, $action)
		{
			$result = false;

			if(isset($action["name"])) {
				$data = array();
				$data["attributes"] = array("type" => "checknames");
				$data["name"] = array();
				
				$names = $action["name"];
				if(!is_array($names)) {
					$names = array($names);
				} 
				
				// open contact folder
				$store = $GLOBALS["mapisession"]->getDefaultMessageStore();
				$inbox = mapi_msgstore_getreceivefolder($store);
				$inboxProps = mapi_getprops($inbox, array(PR_IPM_CONTACT_ENTRYID));
				$contactfolder = mapi_msgstore_openentry($store,$inboxProps[PR_IPM_CONTACT_ENTRYID]);

				// open addressbook
				$ab = $GLOBALS["mapisession"]->getAddressbook();
				$ab_entryid = mapi_ab_getdefaultdir($ab);
				$ab_dir = mapi_ab_openentry($ab,$ab_entryid);

				// check names
				foreach($names as $query){
					if (is_array($query) && isset($query["id"]) && !empty($query["id"]) && isset($query["type"]) && !empty($query["type"])){
						$id = $query["id"];
						$type = $query["type"];

						$result = $this->searchAddressBook($ab_dir, $id, $type);
						$data["name"] = array_merge($data["name"], $result);

						$result = $this->searchContactFolder($contactfolder, $id, $type);
						$data["name"] = array_merge($data["name"], $result);
					}
				}

				array_push($this->responseData["action"], $data);
				$GLOBALS["bus"]->addData($this->responseData);
			}
			
			return $result;
		}

		/**
		* This function searches the addressbook specified for users and returns an array with data
		* Please note that the returning array must be UTF8
		*
		*@param $ab_dir The addressbook
		*@param $query The search query, case is ignored
		*@param $type The type of search, this is returned in the result array
		*/
		function searchAddressBook($ab_dir, $query, $type)
		{
			$table = mapi_folder_getcontentstable($ab_dir);

			// only return users from who the displayName or the username starts with $name
			// TODO: use PR_ANR for this restriction instead of PR_DISPLAY_NAME and PR_ACCOUNT
			$restriction = array(RES_AND, 
								array(
									array(RES_OR, 
										array(
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>PR_DISPLAY_NAME,
														VALUE=>utf8_to_windows1252($query)
													)
												),
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>PR_ACCOUNT,
														VALUE=>utf8_to_windows1252($query)
													)
												),
										), // RES_OR
									),
									array(
										RES_PROPERTY,
											array(RELOP=>RELOP_EQ,
												ULPROPTAG=>PR_OBJECT_TYPE,
												VALUE=>MAPI_MAILUSER
											)
										)
								) // RES_AND
							);
			mapi_table_restrict($table, $restriction);
			mapi_table_sort($table, array(PR_DISPLAY_NAME => TABLE_SORT_ASCEND));
			$items = array();
			for ($i = 0; $i < mapi_table_getrowcount($table); $i++) {
				$user_data = mapi_table_queryrows($table, array(PR_ACCOUNT, PR_DISPLAY_NAME, PR_ENTRYID, PR_OBJECT_TYPE, PR_SMTP_ADDRESS), $i, 1);
				$item = array();
				$item["username"] = windows1252_to_utf8($user_data[0][PR_ACCOUNT]);
				$item["fullname"] = windows1252_to_utf8($user_data[0][PR_DISPLAY_NAME]);
				$item["emailaddress"] = windows1252_to_utf8($user_data[0][PR_SMTP_ADDRESS]);
				$item["nameid"] = $query;
				$item["nametype"] = $type;
				array_push($items, $item);
			}
			return $items;
		}

		/**
		* This function searches the contact folder specified for users and returns an array with data
		* Please note that the returning array must be UTF8
		*
		*@param $folder The opened folder to search, normaly this is a contactsfolder
		*@param $query The search query, case is ignored
		*@param $type The type of search, this is returned in the result array
		*/
		function searchContactFolder($folder, $query, $type)
		{
			$table = mapi_folder_getcontentstable($folder);
			
			$properties = $GLOBALS["properties"]->getContactProperties();

			// only return users from who the displayName or the username starts with $name
			// TODO: use PR_ANR for this restriction instead of PR_DISPLAY_NAME and PR_ACCOUNT
			$restriction = array(RES_AND, 
								array(
									array(RES_OR, 
										array(
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>$properties["display_name"],
														VALUE=>utf8_to_windows1252($query)
													)
												),
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>$properties["fileas"],
														VALUE=>utf8_to_windows1252($query)
													)
												),
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>$properties["email_address_display_name_1"],
														VALUE=>utf8_to_windows1252($query)
													)
												),
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>$properties["email_address_display_name_2"],
														VALUE=>utf8_to_windows1252($query)
													)
												),
											array(
												RES_CONTENT,
													array(FUZZYLEVEL => FL_SUBSTRING|FL_IGNORECASE,
														ULPROPTAG=>$properties["email_address_display_name_3"],
														VALUE=>utf8_to_windows1252($query)
													)
												),
										), // RES_OR
									),
									array(
										RES_PROPERTY,
											array(RELOP=>RELOP_EQ,
												ULPROPTAG=>$properties["message_class"],
												VALUE=>"IPM.Contact"
											)
										)
								) // RES_AND
							);
			mapi_table_restrict($table, $restriction);
			mapi_table_sort($table, array($properties["fileas"] => TABLE_SORT_ASCEND));
			$items = array();
			for ($i = 0; $i < mapi_table_getrowcount($table); $i++) {
				$user_data = mapi_table_queryrows($table, $properties, $i, 1);
				for ($email=1; $email<=3; $email++){
					if (isset($user_data[0][$properties["email_address_".$email]]) && !empty($user_data[0][$properties["email_address_".$email]])){
						$item = array();
						$item["username"] = windows1252_to_utf8($user_data[0][$properties["fileas"]]);
						if (isset($user_data[0]["email_address_display_name_".$email])){
							$item["fullname"] = windows1252_to_utf8($user_data[0][$properties["email_address_display_name_".$email]]);
						}else{
							$item["fullname"] = windows1252_to_utf8($user_data[0][$properties["display_name"]]);
						}
						$item["emailaddress"] = windows1252_to_utf8($user_data[0][$properties["email_address_".$email]]);
						$item["nameid"] = $query;
						$item["nametype"] = $type;
						array_push($items, $item);
					}
				}
			}
			return $items;
		}
	}
?>
