<?php
	/**
	 * Create Mail ItemModule
	 * Module which openes, creates, saves and deletes an item. It 
	 * extends the Module class.
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class CreateMailItemModule extends ItemModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function CreateMailItemModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getMailProperties();
			
			parent::ItemModule($id, $data);
		}
		
		/**
		 * Function which opens a draft. Ite opens the body in plain text.
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function open($store, $entryid)
		{
			$result = false;
			
			if($store && $entryid) {
				$data = array();
				$data["attributes"] = array("type" => "item");
				$message = $GLOBALS["operations"]->openMessage($store, $entryid);
				
				$convertToPlainFormat = true;
				if($GLOBALS['settings']->get('createmail/mailformat',"html") == 'html' && FCKEDITOR_INSTALLED){
					$convertToPlainFormat = false;
				}
				$data["item"] = $GLOBALS["operations"]->getMessageProps($store, $message, $this->properties, $convertToPlainFormat);
				
				array_push($this->responseData["action"], $data);
				$GLOBALS["bus"]->addData($this->responseData);
				
				$result = true;
			}
			
			return $result;
		}
		
		/**
		 * Function which saves and/or sends an item.
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid parent entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function save($store, $parententryid, $action)
		{
			global $state;

			if(!$parententryid && isset($action["props"]["parent_entryid"])) {
				$parententryid = $action["props"]["parent_entryid"];
			}

			$result = false;

			if(!$store) {
				$store = $GLOBALS["mapisession"]->getDefaultMessageStore();
			}
			
			if($store) {
				if(isset($action["props"]) && isset($action["recipients"])){
					/**
					 * When the no recipients are added the transformation from 
					 * XML to an array does not add the empty recipient subarray.
					 */
					if(!isset($action["recipients"]["recipient"])) {
						$action["recipients"]["recipient"] = Array();
					}
					$messageProps = array();

					$send = false;
					if(isset($action["send"])) {
						$send = $action["send"];
					}
					
					$copyAttachments = false;
					$copyAttachmentsStore = false;
					if(isset($action["message_action"]) && isset($action["message_action"]["action_type"]) && $action["message_action"]["action_type"] == "forward") {
						// we need to copy the original attachments when it is an forwarded message
						$copyAttachments = hex2bin($action["message_action"]["entryid"]);
						$copyAttachmentsStore = hex2bin($action["message_action"]["storeid"]);
						// Open store (this => $GLOBALS['mapisession'])
						$copyAttachmentsStore = $GLOBALS['mapisession']->openMessageStore($copyAttachmentsStore);
					}


					if($send) {
						$prop = Conversion::mapXML2MAPI($this->properties, $action["props"]);
						$session = $GLOBALS["mapisession"]->getSession();			
						
						/**
						 * NOTE: PR_SENT_REPRESENTING_NAME might contain user info
						 * for which current user is sending mail on behalf of, so
						 * get delegator's store.
						 */
						$addrbook = mapi_openaddressbook($session);
						$user = array( array( PR_DISPLAY_NAME => $prop[PR_SENT_REPRESENTING_NAME] ));
						$user = mapi_ab_resolvename($addrbook, $user);
						$user2_entryid = mapi_msgstore_createentryid($store, $user[0][PR_EMAIL_ADDRESS]);
						$store = mapi_openmsgstore($session, $user2_entryid);

						if(!$store) {
							$store = $GLOBALS["mapisession"]->getDefaultMessageStore();
						}

						$parententryid = $this->getDefaultFolderEntryID($store, $action["props"]["message_class"]);
						$result = $GLOBALS["operations"]->submitMessage($store, Conversion::mapXML2MAPI($this->properties, $action["props"]), $action["recipients"]["recipient"], $action["dialog_attachments"], $messageProps, $copyAttachments, $copyAttachmentsStore);
						
						// If draft is send from the drafts folder, delete notification
						if($result) {
							if(isset($action["props"]["entryid"])) {
								$props = array();
								$props[PR_ENTRYID] = hex2bin($action["props"]["entryid"]);
								$props[PR_PARENT_ENTRYID] = $parententryid;
								
								$storeprops = mapi_getprops($store, array(PR_ENTRYID));
								$props[PR_STORE_ENTRYID] = $storeprops[PR_ENTRYID];
								
								$GLOBALS["bus"]->notify(bin2hex($parententryid), TABLE_DELETE, $props);
							}
						}
					} else {
						$parententryid = $this->getDefaultFolderEntryID($GLOBALS["mapisession"]->getDefaultMessageStore(), $action["props"]["message_class"]);
						if ($action["props"]["entryid"]==""){
							$action["props"]["entryid"] = $state->read("createmail".$action["dialog_attachments"]);
						}
						$result = $GLOBALS["operations"]->saveMessage($GLOBALS["mapisession"]->getDefaultMessageStore(), $parententryid, Conversion::mapXML2MAPI($this->properties, $action["props"]), $action["recipients"]["recipient"], $action["dialog_attachments"], $messageProps, $copyAttachments, $copyAttachmentsStore);
						$state->write("createmail".$action["dialog_attachments"], bin2hex($messageProps[PR_ENTRYID]));

						// Update the client with the (new) entryid and parententryid to allow the draft message to be removed when submitting.						
						// Retrieve entryid and parententryid of new mail.
						$props = array();
						$props = mapi_getprops($result, array(PR_ENTRYID, PR_PARENT_ENTRYID));
						// Send data to client
						$data = array();
						$data["attributes"] = array("type" => "update");
						$data["item"] = array();
						$data["item"]["entryid"] = bin2hex($props[PR_ENTRYID]);
						$data["item"]["parententryid"] = bin2hex($props[PR_PARENT_ENTRYID]);

						//send info to update attachments
						/** 
						 * We have to reopen the message because the PR_ATTACH_SIZE is calculated 
						 * when the message has been saved. This information is then not updated in 
						 * the MAPI Message Object that is still open. So you have to reopen it to 
						 * get the SIZE data.
						 */
						$savedMsg = $GLOBALS['operations']->openMessage($store, $props[PR_ENTRYID]);
						$hasattachProp = mapi_getprops($savedMsg, array(PR_HASATTACH));
						if (isset($hasattachProp[PR_HASATTACH])&& $hasattachProp[PR_HASATTACH]){
							$attachmentTable = mapi_message_getattachmenttable($savedMsg);
							$attachments = mapi_table_queryallrows($attachmentTable, array(PR_ATTACH_NUM, PR_ATTACH_SIZE, PR_ATTACH_LONG_FILENAME, PR_ATTACH_FILENAME, PR_ATTACHMENT_HIDDEN, PR_DISPLAY_NAME, PR_ATTACH_METHOD));
							$attachment_props["attachments"] = array();
							$attachment_props["attachments"]["attachment"] = array();

							foreach($attachments as $attachmentRow)
							{
								if(!isset($attachmentRow[PR_ATTACHMENT_HIDDEN]) || !$attachmentRow[PR_ATTACHMENT_HIDDEN]) {
									$attachment = array();
									$attachment["attach_num"] = $attachmentRow[PR_ATTACH_NUM];
									$attachment["attach_method"] = $attachmentRow[PR_ATTACH_METHOD];
									$attachment["size"] = $attachmentRow[PR_ATTACH_SIZE];

									if(isset($attachmentRow[PR_ATTACH_LONG_FILENAME]))
										$attachment["name"] = $attachmentRow[PR_ATTACH_LONG_FILENAME];
									else if(isset($attachmentRow[PR_ATTACH_FILENAME]))
										$attachment["name"] = $attachmentRow[PR_ATTACH_FILENAME];
									else if(isset($attachmentRow[PR_DISPLAY_NAME]))
										$attachment["name"] = $attachmentRow[PR_DISPLAY_NAME];
									else
										$attcahment["name"] = "untitled";

									if (isset($attachment["name"])){
										$attachment["name"] = windows1252_to_utf8($attachment["name"]);
									}

									if ($attachment["attach_method"] == ATTACH_EMBEDDED_MSG){
										// open attachment to get the message class
										$attach = mapi_message_openattach($savedMsg, $attachment["attach_num"]);
										$embMessage = mapi_attach_openobj($attach);
										$embProps = mapi_getprops($embMessage, array(PR_MESSAGE_CLASS));
										if (isset($embProps[PR_MESSAGE_CLASS]))
											$attachment["attach_message_class"] = $embProps[PR_MESSAGE_CLASS];
									}

									array_push($attachment_props["attachments"]["attachment"], $attachment);
								}
							}
							$data["item"]["attachments"] = $attachment_props["attachments"];
						}

						array_push($this->responseData["action"], $data);
						$GLOBALS["bus"]->addData($this->responseData);
					}
					
					// Reply/Reply All/Forward Actions (ICON_INDEX & LAST_VERB_EXECUTED)
					if(isset($action["message_action"]) && isset($action["message_action"]["action_type"])) {
						$props = array();
						$props[$this->properties["entryid"]] = hex2bin($action["message_action"]["entryid"]);

						switch($action["message_action"]["action_type"])
						{
							case "reply":
								$props[$this->properties["icon_index"]] = 261;
								$props[$this->properties["last_verb_executed"]] = 102;
								break;
							case "replyall":
								$props[$this->properties["icon_index"]] = 261;
								$props[$this->properties["last_verb_executed"]] = 103;
								break;
							case "forward":
								$props[$this->properties["icon_index"]] = 262;
								$props[$this->properties["last_verb_executed"]] = 104;
								break;
						}
						
						$props[$this->properties["last_verb_execution_time"]] = mktime();
						
						// Use the storeid of that belongs to the message_action entryid.
						// This is in case the message is on another store.
						if(isset($action["store"])) {
							$storeOrigMsg = $GLOBALS["mapisession"]->openMessageStore(hex2bin($action["message_action"]["storeid"]));
						}

						$message_action_props = array();
						$message_action_result = $GLOBALS["operations"]->saveMessage($storeOrigMsg, $parententryid, $props, false, array(), $message_action_props);

						if($message_action_result) {
							if(isset($message_action_props[PR_PARENT_ENTRYID])) {
								$GLOBALS["bus"]->notify(bin2hex($message_action_props[PR_PARENT_ENTRYID]), TABLE_SAVE, $message_action_props);
							}
						}
					}
				}
				if($result && !$send) {
					$GLOBALS["bus"]->notify(bin2hex($messageProps[PR_PARENT_ENTRYID]), TABLE_SAVE, $messageProps);
				}
			}
			
			return $result;
		}
	}
?>
