<?php
	/**
	 * Contact Module
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class ContactListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function ContactListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getContactProperties();

			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon"), _("Sort On Icon"));
			$this->addColumn($this->tablecolumns, "fileas", true, 1, _("File As"), _("Sort On File As"));
			$this->addColumn($this->tablecolumns, "display_name", true, 2, _("Full Name"), _("Sort On Display Name"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "email_address_1", true, 3, _("Email Address 1"), _("Sort On Email Address 1"));
			$this->addColumn($this->tablecolumns, "email_address_2", false, 3, _("Email Address 2"), _("Sort On Email Address 2"));
			$this->addColumn($this->tablecolumns, "email_address_3", false, 3, _("Email Address 3"), _("Sort On Email Address 3"));
			$this->addColumn($this->tablecolumns, "home_telephone_number", true, 4, _("Home Telephonenumber"), _("Sort On Home Telephonenumber"));
			$this->addColumn($this->tablecolumns, "cellular_telephone_number", true, 5, _("Cellular Telephonenumber"), _("Sort On Cellular Telephonenumber"));
			$this->addColumn($this->tablecolumns, "categories", false, 4, _("Categories"), _("Sort On Categories"));
			
			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["fileas"]] = TABLE_SORT_ASCEND;
			
			$this->start = 0;
		}
		
		/**
		 * Function which retrieves a list of contacts in a contact folder. It uses
		 * a restriction (start letter).		 
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the folder
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function messageList($store, $entryid, $action)
		{
			$result = false;

			// Retrieve the data for a normal table view with rows.
			if(isset($action["data_retrieval"]) && $action["data_retrieval"] == "normal") {
				// Use the parent class "messageList" method
				$result = parent::messageList($store, $entryid, $action);
			} else { // Retrieve the data for the address cards view
				if($store && $entryid) {
					$character = "a";
					if(isset($action["restriction"])) {
						if(isset($action["restriction"]["character"])) {
							$character = $action["restriction"]["character"];
						}
						if(isset($action["restriction"]["start"])) {
							// Set start variable
							$this->start = (int) $action["restriction"]["start"];
						}
					}
					
					$restriction = array();
					if($character != "...") {
						switch ($character){
							case "123":
								$restriction = array(
												RES_AND,
												array(
													array(
														RES_PROPERTY,
														array(RELOP => RELOP_GE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => "0" 
															)
														)
													),
													array(
														RES_PROPERTY,
														array(RELOP => RELOP_LE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => "9"
															)
														)
													)
												)
											);
								break;
							case "z":
								$restriction = array(
													RES_PROPERTY,
													array(RELOP => RELOP_GE,
														ULPROPTAG => $this->properties["fileas"],
														VALUE => array(
															$this->properties["fileas"] => "z" 
														)
													)
												);
								break;
							default:
								$restriction = array(
												RES_AND,
												array(
													array(
														RES_PROPERTY,
														array(
															RELOP => RELOP_GE,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => $character
															)
														)
													),
													array(
														RES_PROPERTY,
														array(
															RELOP => RELOP_LT,
															ULPROPTAG => $this->properties["fileas"],
															VALUE => array(
																$this->properties["fileas"] => chr(ord($character)+1)
															)
														)
													)
												)
											);
							break;
						}
					}

					$sort = array($this->properties["fileas"]=>TABLE_SORT_ASCEND);

					$data = array();
					$data["attributes"] = array("type" => "list");
					
					$firstSortColumn = reset(array_keys($this->sort)); // get first key of the sort array
					$data["sort"] = array();
					$data["sort"]["attributes"] = array();
					$data["sort"]["attributes"]["direction"] = (isset($this->sort[$firstSortColumn]) && $this->sort[$firstSortColumn] == TABLE_SORT_ASCEND) ? "asc" : "desc";
					$data["sort"]["_content"] = array_search($firstSortColumn, $this->properties);
	
					$data = array_merge($data, $GLOBALS["operations"]->getTable($store, $entryid, $this->properties, $sort, $this->start, false, $restriction));
					
					array_push($this->responseData["action"], $data);
					$GLOBALS["bus"]->addData($this->responseData);
					
					$result = true;
				} 
			}
			
			return $result;
		}
	}
?>
