<?php
/**
* This file is only used for debugging purpose, this file isn't needed in
* the release version.
*
*@author Michael Erkens <michael@connectux.com> 
*/

/**
* Set this to let zarafa.php exports the XML
* but please note that you must create the DEBUG_XMLOUT_DIR directory and that
* it is writable by PHP
*/
define("DEBUG_XMLOUT", true);
define("DEBUG_XMLOUT_DIR", "debug_xml/");
define("DEBUG_XMLOUT_GZIP", false);
define("DEBUG_XMLOUT_FORMAT_INPUT", true);

// dump file, must be writable
define("DEBUG_DUMP_FILE", "debug.txt");

// if true, webaccess won't be combining JS en CSS files and disables caching
define("DEBUG_LOADER", true);

// if false, webaccess would never use GZIP compression
define("DEBUG_GZIP", true);

// show SVN version if possible
define("DEBUG_SHOW_SVN_VERSION", true);

// if true, show server url (if not localhost) in title of webaccess, or when this is a string, show that string
define("DEBUG_SHOW_SERVER", true);

// end config


//	This PHP error handler, only dumps the error to our dump file, including mapi_last_hresult
error_reporting(E_ALL);
set_error_handler("zarafa_error_handler");

// get server url
if (DEBUG_SHOW_SERVER){
	if (DEBUG_SHOW_SERVER===true){
		if (preg_match_all("|http://([^:/]+).*|", DEFAULT_SERVER, $matches)){
			if ($matches[1][0]!="localhost"){ // other than localhost
				define("DEBUG_SERVER_ADDRESS", $matches[1][0]);
			}
		}else if (DEFAULT_SERVER!="file://\\\\.\\pipe\\zarafa" && DEFAULT_SERVER!="file:///var/run/zarafa"){  
			// other non http server locations except the default values
			define("DEBUG_SERVER_ADDRESS", str_replace("file://","",DEFAULT_SERVER)); // show location
		}
	}else{ // show that string
		define("DEBUG_SERVER_ADDRESS", DEBUG_SHOW_SERVER);
	}
}

// get SVN build
if (DEBUG_SHOW_SVN_VERSION && is_dir(".svn")){
	$svnversion = @shell_exec("svnversion .");
	if (!empty($svnversion)){
		define("SVN", $svnversion);
	}
}

/**
* Custom error handler, here we check to see if it is a MAPI error and dump all info
* to the dump file, and finally we redirect the error back to PHP
*/
function zarafa_error_handler($errno, $errstr, $errfile, $errline, $errcontext)
{	
	$error = array("msg"=>$errstr, "file"=>$errfile.":".$errline);

	if($errno == E_STRICT)
	    return;

	if (strpos($errstr,"mapi_")!==false) {
			$error["mapi"] = get_mapi_error_name();
	}
	dump($error, "ERROR", true);

	switch($errno){
		case E_WARNING:
			$errno = E_USER_WARNING;
			break;
		case E_STRICT:
		case E_NOTICE:
			$errno = E_USER_NOTICE;
			break;
		case E_ERROR:
			$errno = E_USER_ERROR;
			break;
	}
	trigger_error($errstr." - ".$errfile.":".$errline, $errno);
}
if (!defined("E_STRICT"))
	define("E_STRICT", E_NOTICE);

/**
* This function "dumps" the contents of $variable to debug.txt (and when requested also a backtrace)
*/
function dump($variable, $title="", $backtrace=false)
{
	$file = fopen(DEBUG_DUMP_FILE, "a+");
	$date = strftime("%d-%b-%Y");
	$time = strftime("%H:%M:%S");
	fwrite($file, ("[" . $date . " " . $time . "] " . $title. " - " . var_export($variable, true) . "\r\n"));
	if ($backtrace){
		dump(_debug_backtrace(false));
	}
}

// use this function when you want to dump an array of MAPI properties
function dump_props($variable,$title=""){
	global $_debug_propList;
	if ($_debug_propList===false){
		// caching
		foreach(get_defined_constants() as $key=>$value){
			if (substr($key,0,3)=='PR_'){
				$_debug_propList[$key] = $value;
			}
		}
	}

	foreach($variable as $key=>$value){
		$prop = array_keys($_debug_propList,$key);
		if (count($prop)>0){
			foreach($prop as $k=>$v){
				$variable["0x".str_pad(strtoupper(dechex($key)),8, '0', STR_PAD_LEFT).' '.$v] = $value;
			}
		}else{
			$variable["0x".str_pad(strtoupper(dechex($key)),8, '0', STR_PAD_LEFT)] = $value;
		}
		unset($variable[$key]);
	}
	dump($variable,$title);
}
$_debug_propList = false;

/**
* This function is used for the in/output by zarafa.php to store the XML to disk
*/
function dump_xml($xml, $prefix){
	global $debug_xml_id;

	if (DEBUG_XMLOUT){
		if (!isset($debug_xml_id) || empty($debug_xml_id)){
				$debug_xml_id = strftime("%Y%m%d%H%M%S").uniqid("_");
		}

		if (DEBUG_XMLOUT_FORMAT_INPUT && $prefix == "in"){
			$parser = new XMLParser();
			$data = $parser->getData($xml);
			$builder = new XMLBuilder();
			$xml = $builder->build($data);
		}
		
		if (is_dir(DEBUG_XMLOUT_DIR)){
				$fh = fopen(DEBUG_XMLOUT_DIR.$prefix."_".$debug_xml_id.".xml".(DEBUG_XMLOUT_GZIP?".gz":""), "w");
				fwrite($fh, (DEBUG_XMLOUT_GZIP?gzencode($xml):$xml));
				fclose($fh);
		}
	}
}

/**
* internal function to generate a backtrace
*/
function _debug_backtrace($html=true){
  $output = $html?"<br/>\n":"\n";
  foreach(debug_backtrace() as $t){
    if (isset($t['file']) && $t['file']!=__FILE__){
      $output .= $html?'<strong>@</strong> ':'@ ';
      if(isset($t['file'])) {
        $output .= basename($t['file']) . ':' . $t['line'];
      } else {
       $output .= '[PHP inner-code]';
      }
      $output .= ' - ';
      if(isset($t['class'])) $output .= $t['class'] . $t['type'];
      $output .= $t['function'];
      if(isset($t['args']) && sizeof($t['args']) > 0) {
        $output .= '(...)';
      } else {
        $output .= '()';
      }
      $output .= $html?"<br/>\n":"\n";
    }
  }
  return $output;
}

?>