/**
 * --CombinedDateTimePicker widget--   
 * @author Frans van Veen <f.vanveen@zarafa.com>
 * 
 * This widget will create a quota bar  
 * 
 * HOWTO BUILD:
 * - make two div with unique id "quota_footer"
 * - this.quotaBar = new QuotaWidget(dhtml.getElementById("quota_footer"),"quota");
 * HOWTO USE:
 * - to update the quota: this.quotaBar.update(store_size,quota_warning,quota_soft,quota_hard);
 * DEPENDS ON:
 * |------> dhtml.js
 * |------> style.css (you need some edit the style of element in the css file)
 */

QuotaWidget.prototype = new Widget;
QuotaWidget.prototype.constructor = QuotaWidget;
QuotaWidget.superclass = Widget.prototype;
 
//PUBLIC
/**
 * Constructor
 * @param element = html element where the quotabar have to be placed in
 * @param labltext = string that will be placed before the bar  
 */ 
function QuotaWidget(element,labeltext)
{
	this.hideWhenZero = true;
	this.element = element;
	this.element.style.display = "none";
	if(!labeltext){
		labeltext = "";
	}
	this.render(labeltext);
}

/**
 * Function will update the quota bar
 * @param size = int size of store in kb
 * @param warn = int warning of store in kb  
 * @param soft = int soft quota of store in kb
 * @param hard = int hard quota of store in kb  
 */ 
QuotaWidget.prototype.update = function(size,warn,soft,hard)
{
	size = parseInt(size,10);
	warn = parseInt(warn,10);
	soft = parseInt(soft,10);
	hard = parseInt(hard,10);
	if(hard <= 0){
		this.element.style.display = "none";
	}else{
		this.element.style.display = "block";
		
		//Set label
		dhtml.deleteAllChildren(this.labelElement);
		dhtml.addTextNode(this.labelElement,Math.roundDecimal(size/1024,1)+" / "+Math.roundDecimal(hard/1024,1)+" "+_("MB"));
		
		//Calc value
		var factor = this.barElement.offsetWidth/hard;
		hard -= soft;
		soft -= warn;			
		if(size < warn){
			warn = size; size = 0;
		}else{
			size -= warn;
		}
		if(size < soft){
			soft = size; size = 0;
		}else{
			size -= soft;
		}		
		if(size < hard) hard = size;
		
		//Update view
		this.warnElement.style.width = warn*factor+"px";
		this.softElement.style.width = soft*factor+"px";
		this.hardElement.style.width = hard*factor+"px";
		this.softElement.style.left = this.warnElement.offsetWidth+"px";
		this.hardElement.style.left = this.warnElement.offsetWidth+this.softElement.offsetWidth+"px";
	}
}

//PRIVATE
/**
 * Function will draw the quota bar
 * @param labeltext = string text will be placed before quota bar 
 */ 
QuotaWidget.prototype.render = function(labeltext)
{
	dhtml.deleteAllChildren(this.element);
	if(labeltext.length > 0){
		dhtml.addElement(this.element,"span","quota_display","",labeltext+":");
	}else{
		dhtml.addElement(this.element,"span","quota_display");
	}
	this.barElement = dhtml.addElement(this.element,"div","quota_bar");
	this.warnElement = dhtml.addElement(this.barElement,"span","quota_warning");
	this.softElement = dhtml.addElement(this.barElement,"span","quota_soft");
	this.hardElement = dhtml.addElement(this.barElement,"span","quota_hard");
	this.labelElement = dhtml.addElement(this.element,"span","quota_label");
}
