/**
* Generates Print Preview for Calendar Week View
*/
PrintCalendarWeekView.prototype = new PrintView;
PrintCalendarWeekView.prototype.constructor = PrintCalendarWeekView;
PrintCalendarWeekView.superclass = PrintView.prototype;

/**
 * @constructor This view can be used to print a list of appointments in week view
 * @param Int moduleID The PrintListModule ID
 * @param HtmlElement The html element where all elements will be appended
 * @param Object The Events object
 * @param Object The Data Passed from the main window
 */
function PrintCalendarWeekView(moduleID, element, events, data, uniqueid) {
	if(arguments.length > 0) {
		this.init(moduleID, element, events, data, uniqueid);
	}
}

/**
 * Function which intializes the view
 */
PrintCalendarWeekView.prototype.initView = function() {
	// add day elments
	this.dayElements = new Array();
	this.dayElements[0] = dhtml.addElement(this.element, "div", "week_view day_monday");
	this.dayElements[3] = dhtml.addElement(this.element, "div", "week_view day_thursday");
	this.dayElements[1] = dhtml.addElement(this.element, "div", "week_view day_tuesday");
	this.dayElements[4] = dhtml.addElement(this.element, "div", "week_view day_friday");
	this.dayElements[2] = dhtml.addElement(this.element, "div", "week_view day_wednesday");
	this.dayElements[5] = dhtml.addElement(this.element, "div", "week_view day_saturday");
	this.dayElements[6] = dhtml.addElement(this.element, "div", "week_view day_sunday");

	// add header info
	var tmpStart = new Date(this.selecteddate).getStartDateOfWeek();
	
	for(var i = 0;i < this.dayElements.length; i++) {
		this.dayElements[i].id = "day_" + this.moduleID + "_" + (tmpStart.getTime() / 1000);
		var dayTitle = dhtml.addElement(this.dayElements[i], "span", "day_header", "", 
											tmpStart.strftime( _("%A %d %B") ));
		tmpStart.addDays(1);
	}
}

/**
 * Function will resize all elements in the view
 */
PrintCalendarWeekView.prototype.resizeView = function() {
	var menubarHeight = dhtml.getElementById("menubar").offsetHeight + dhtml.getElementById("menubar").offsetTop;
	var titleHeight = dhtml.getElementsByClassName("title")[0].offsetHeight;
	var bodyHeight = document.getElementsByTagName("body")[0].offsetHeight;

	var dialogContentHeight = bodyHeight - (menubarHeight + titleHeight) + 12;
	dhtml.getElementById("dialog_content").style.height = dialogContentHeight + "px";

	var printFooterHeight = dhtml.getElementById("print_footer").offsetHeight;
	var printHeaderHeight = dhtml.getElementById("print_header").offsetHeight;

	this.element.style.height = dialogContentHeight - (printHeaderHeight + printFooterHeight) + "px";

	for(var i in this.dayElements) {
		if(i == "5" || i == "6") {
			this.dayElements[i].style.height = (this.element.offsetHeight/3) / 2 + "px";
		} else {
			this.dayElements[i].style.height = (this.element.offsetHeight/3) + "px";	
		}
		this.dayElements[i].style.width = (this.element.offsetWidth/2) - 2 + "px";
	}

	// width of "print_calendar","print_header" and "print_footer" is in percentage 
	// so before printing need to convert it into pixels
	this.element.style.width = (this.dayElements[0].offsetWidth * 2) + 2 + "px";
	dhtml.getElementById("print_header").style.width = this.element.style.width;
	dhtml.getElementById("print_footer").style.width = this.element.style.width;
	
	this.hideOverlappingItems();
}

/**
 * Function will add items to the view
 * @param Object items Object with items
 * @param Array properties property list
 * @param Object action the action tag
 * @return Array list of entryids
 */
PrintCalendarWeekView.prototype.execute = function(items, properties, action) {
	var entryids = false;

	for(var i=0;i<items.length;i++){
		if (!entryids) {
			entryids = new Object();
		}
		// there is not much difference in createItem function 
		// of PrintView and PrintCalendarWeekView class
		// so it is not redeclared here used common function
		var item = this.createItem(items[i]);
		entryids[item["id"]]= item["entryid"];
	}

	this.resizeView();

	this.createIFrame();

	return entryids;
}

/**
 * Function will check if there are items outside the view that
 * have to be hidden
 */
PrintCalendarWeekView.prototype.hideOverlappingItems = function() {
	for(var i in this.dayElements) {
		var items = dhtml.getElementsByClassNameInElement(this.dayElements[i], "event", "div");
		var dayHeight = this.dayElements[i].offsetHeight;
		var	dayCurrentHeight = (items.length * 14) + 14;
		var maxItems = Math.floor((dayHeight - 18) / 14) - 1;

		// remove more_items label
		var moreItem = dhtml.getElementsByClassNameInElement(this.dayElements[i], "more_items", "div")[0];
		if(moreItem) {
			dhtml.deleteElement(moreItem);
		}

		// hide/show items
		var moreItemCount = 0;
		for(var j = 0; j < items.length; j++) {
			if(j < maxItems) {
				items[j].style.display = "block";
			} else {
				items[j].style.display = "none";
				moreItemCount++;
			}

			var item_back = dhtml.getElementById(items[j].id + "_back", "div", this.dayElements[i]);
			if(item_back != null) {
				if(j < maxItems) {
					item_back.style.display = "block";
				} else {
					item_back.style.display = "none";
				}
			}
		}

		// show more_items label
		if(items.length > maxItems && items.length > 0) {
			var moreItem = dhtml.addElement(this.dayElements[i], "div", "more_items");
			var unixTime = this.dayElements[i].getAttribute("id").split("_")[2];
			moreItem.setAttribute("unixtime", unixTime);
			moreItem.innerHTML = _("More items...");
		}
	}
}