/**
* Generates Print Preview for Mail items
*
*@author M. Erkens <m.erkens@connectux.com>
*/
function printMessageItem()
{
}

/**
* this function does all the creating stuff
*
*@param object moduleObject The PrintItemModule object
*@param	window frame The iframe window object where to write the print preview to.
*/
printMessageItem.prototype.init = function(moduleObject, frame)
{
	// initialize data
	this.frame = frame;
	this.module = moduleObject;
	this.props = this.module.propData;
	this.doc = this.frame.document;

	this.createHTML();
}

printMessageItem.prototype.createHTML = function()
{
	// set content/type
	this.doc.open("text/html");
	
	// write header
	this.doc.writeln('<html>');
	this.doc.writeln('	<head>');
	this.doc.writeln('		<title>Zarafa WebAccess - '+webclient.fullname+'</title>');
	this.doc.writeln('	</head>');

	// begin body
	this.doc.writeln('	<body>');
	this.doc.writeln('		<h1 style="font-family: sans-serif; font-size: 12pt;border-bottom: 3px solid #000;">'+webclient.fullname+'</h1>');

	// write mail properties (from/to/cc/subject etc)
	this.doc.writeln('		<table cellspacing=0 cellpadding=0 style="font-family: sans-serif; font-size: 10pt">');
	this.writeLine(_("From"),"sent_representing_name");
	this.writeLine(_("Sent"),"message_delivery_time");
	this.writeLine(_("To"),"display_to");
	this.writeLine(_("CC"),"display_cc");
	this.writeLine(_("Subject"),"subject");
	this.writeLine(_("Creation Time"),"creation_time","IPM.StickyNote");
	this.writeLine(_("Modified"),"last_modification_time");
	
	this.writeLine(_("Location"),"location");//appointment
	this.writeLine(_("Start Date"),"startdate");//appointment, task
	this.writeLine(_("End Date"),"duedate");//appointment, task
	this.writeLine(_("Recurrence Pattern"),"RecurrencePattern");//appointment
	
	//task
	this.writeLine("","","IPM.Task");
	if(this.props["status"]){
		switch(this.props["status"]){
			case "1":
				this.props["status"] = _("In Progress");
				break;
			case "2":
				this.props["status"] = _("Complete");
				break;
			case "3":
				this.props["status"] = _("Wait for other person");
				break;
			case "5":
				this.props["status"] = _("Expelled");
				break;
		}
		this.writeLine(_("Status"),"status");
	}
	if(this.props["percent_complete"]){
		this.props["percent_complete"] = (this.props["percent_complete"]*100)+'%';
		this.writeLine(_("Percent Complete"),"percent_complete");
		this.writeLine(_("Date completed"),"datecompleted");
	}
	this.writeLine("","","IPM.Task");
	if(this.props["totalwork"]){
		this.props["totalwork"] = Math.round(this.props["totalwork"]/6)/10+' '+_("hours");
		this.writeLine(_("Total Work"),"totalwork");
	}
	if(this.props["actualwork"]){
		this.props["actualwork"] = Math.round(this.props["actualwork"]/6)/10+' '+_("hours");
		this.writeLine(_("Actual Work"),"actualwork");
	}
	this.writeLine("","","IPM.Task");
	this.writeLine(_("Owner"),"owner");
	this.writeLine("","","IPM.Task");
	
	this.writeLine(_("Contacts"),"contacts_string");
	this.writeLine("","","IPM.Task");
	
	//contacts
	this.writeLine(_("Full Name"),"display_name");
	this.writeLine(_("Last Name"),"surname");
	this.writeLine(_("First Name"),"given_name");
	this.writeLine(_("Middle Name"),"middle_name");
	this.writeLine(_("Job Title"),"title");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("Mobile"),"cellular_telephone_number");
	this.writeLine(_("IM Address"),"im");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("Company"),"company_name");
	this.writeLine(_("Business Address"),"business_address");
	this.writeLine(_("Business")+" "+_("Phone"),"office_telephone_number");
	this.writeLine(_("Business Fax"),"business_fax_number");
	this.writeLine(_("Home address"),"home_address");
	this.writeLine(_("Home")+" "+_("Phone"),"home_telephone_number");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("E-mail"),"email_address_1");
	this.writeLine(_("Display Name"),"email_address_display_name_1");
	this.writeLine(_("E-mail")+"(2)","email_address_2");
	this.writeLine(_("Display Name"),"email_address_display_name_2");
	this.writeLine(_("E-mail")+"(3)","email_address_3");
	this.writeLine(_("Display Name"),"email_address_display_name_3");
	this.writeLine(_("Web Page"),"webpage");
		
	this.writeLine(_("Categories"),"categories");
	this.writeLine(_("Company"), "companies");
	this.writeLine(_("Billing information"), "billinginformation");
	this.writeLine(_("Mileage"), "mileage");

	this.writeLine(_("Attachments"), "attachments");

	// write member list
	this.writeLine("", "", "IPM.DistList");
	this.writeMembers("IPM.DistList");

	this.doc.writeln('		</table>');
	this.doc.writeln('		<br>');

	// write mail
	this.writeBody();

	// write footer
	this.doc.writeln('	</body>');
	this.doc.writeln('</html>');

	this.doc.close();
}

/*
* This function makes sure that the body of the mail is written correctly. 
* In Firefox for example there are multiple textnodes that holds the 
* message, so get them all.
*/
printMessageItem.prototype.writeBody = function()
{
	var body = this.props["body"];
	
	if(body && body.childNodes.length > 0) {
		var content = "";
		var element = body.firstChild;
		for(var i = 0; i < body.childNodes.length; i++)
		{
			content += element.nodeValue;
			element = element.nextSibling;
		}

		if (!this.props["isHTML"] || this.props["isHTML"]=="0"){
			content = convertPlainToHtml(content);
			content = "<pre style=\"white-space: -moz-pre-wrap; word-wrap: break-word;\">" + content + "</pre>";
		}

		this.doc.write(content);
	}
}

printMessageItem.prototype.writeLine = function(label, field, msgClass)
{
	if (this.props[field] && (!msgClass || msgClass == this.props["message_class"])){		
		this.doc.writeln('			<tr><th align="left">'+label+':</th><td style="padding-left: 10px">'+this.props[field].replace(/</g,"&lt;").replace(/>/g,"&gt;")+'</td></tr>');
	}
	if(label == "" && field == "" && msgClass == this.props["message_class"]){
		this.doc.writeln('			<tr><th align="left">'+NBSP+'</th><td style="padding-left: 10px">'+NBSP+'</td></tr>');
	}
}

printMessageItem.prototype.writeMembers = function(msgClass) {
	var members = this.props["members"];
	var name, address, missing;

	if(this.props["message_class"] == msgClass) {
		this.doc.writeln('<tr><th align="left">'+ _("Members") +':</th></tr>');

		if(members && members.childNodes) {
			for(var i=0; i < members.childNodes.length; i++) {
				if(members && members.firstChild) {
					var member = members.childNodes[i];

					if(member.tagName == "member") {
						name = member.getElementsByTagName("name")[0].firstChild.nodeValue;
						address = member.getElementsByTagName("address")[0].firstChild.nodeValue;
						missing = member.getElementsByTagName("missing")[0] ? member.getElementsByTagName("missing")[0].firstChild.nodeValue : 0;

						if(missing != 1) {
							this.doc.writeln('<tr><td align="left">' + name + '</td><td style="padding-left: 10px">' + address + '</td></tr>');
						}
					}
				}
			}
		}
	}
}