contactitemmodule.prototype = new ItemModule;
contactitemmodule.prototype.constructor = contactitemmodule;
contactitemmodule.superclass = ItemModule.prototype;

function contactitemmodule(id)
{
	if(arguments.length > 0) {
		this.init(id);
	}
}

contactitemmodule.prototype.init = function(id)
{
	contactitemmodule.superclass.init.call(this, id);
}

contactitemmodule.prototype.executeOnLoad = function()
{
	initContact();
}

contactitemmodule.prototype.save = function(props, email_addresses, dialog_attachments)
{
	var data = new Object();
	if(this.storeid) {
		data["store"] = this.storeid;
	}
	
	if(this.parententryid) {
		data["parententryid"] = this.parententryid;
	}
	
	data["props"] = props;
	data["dialog_attachments"] = dialog_attachments;
	data["email_addresses"] = email_addresses;
	
	if(parentWebclient) {
		parentWebclient.xmlrequest.addData(this, "save", data, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, "save", data);
		webclient.xmlrequest.sendRequest();
	}
}
