var parentModule;

function initFieldChooser()
{
	var dialogname = window.name;
	if(!dialogname) {
		dialogname = window.dialogArguments.dialogName;
	}

	parentModule = parentWebclient.dialogs[dialogname]["module"];
	var propertylist = parentModule.propertylist;

	var columns = dhtml.getElementById("columns");
	var selected_columns = dhtml.getElementById("selected_columns");

	var properties = new Array();
	var selected_properties = new Array();
	
	for(var i = 0; i < propertylist.length; i++)
	{
		var property = propertylist[i];
		
		if(property["name"]) {
			if(property["visible"]) {
				selected_properties.push(property);
			} else {
				properties.push(property);			
			}
		}
	}
	
	properties.sort(sortColumns);
	selected_properties.sort(orderColumns);
	
	for(var i = 0; i < properties.length; i++)
	{
		columns.options[columns.options.length] = new Option(properties[i]["name"], properties[i]["id"]);
	}
	
	for(var i = 0; i < selected_properties.length; i++)
	{
		selected_columns.options[selected_columns.options.length] = new Option(selected_properties[i]["name"], selected_properties[i]["id"]);		
	}
}

function submitFields()
{
	var properties = new Array();
	var columns = dhtml.getElementById("columns");
	var selected_columns = dhtml.getElementById("selected_columns");
	
	for(var i = 0; i < selected_columns.options.length; i++)
	{
		var property = new Object();
		property["id"] = selected_columns.options[i].value;
		property["action"] = "add";
		property["order"] = "" + i;
		properties.push(property);
	}
	
	for(var i = 0; i < columns.options.length; i++)
	{
		var property = new Object();
		property["id"] = columns.options[i].value;
		property["action"] = "delete";
		properties.push(property);
	}

	window.resultCallBack(properties, window.callBackData);
}

function addColumn()
{
	var columns = dhtml.getElementById("columns");
	var selected_columns = dhtml.getElementById("selected_columns");
	
	if(columns.selectedIndex >= 0) {
		var selected_index = columns.selectedIndex;
		var option = columns.options[selected_index];
		selected_columns.options[selected_columns.options.length] = new Option(option.text, option.value);
		
		columns.remove(selected_index);
		
		// Select the added column in 'selected_columns'
		selected_columns.options[selected_columns.options.length - 1].selected = true;
		
		// Select the next or previous option in 'columns'
		var next_option = selected_index - 1;
		if(selected_index < columns.options.length) { 
			next_option++;	
		}

		if(next_option < columns.options.length && next_option >= 0) {
			columns.options[next_option].selected = true;
		}
	}
}

function deleteColumn()
{
	var columns = dhtml.getElementById("columns");
	var selected_columns = dhtml.getElementById("selected_columns");
	
	if(selected_columns.selectedIndex >= 0) {
		var selected_index = selected_columns.selectedIndex;
		var option = selected_columns.options[selected_index];
		var selected_value = option.value;
		columns.options[columns.options.length] = new Option(option.text, option.value);
		
		selected_columns.remove(selected_columns.selectedIndex);

		// Select the next or previous option in 'selected_columns'
		var next_option = selected_index - 1;
		if(selected_index < selected_columns.options.length) { 
			next_option++;	
		}

		if(next_option < selected_columns.options.length && next_option >= 0) {
			selected_columns.options[next_option].selected = true;
		}
		
		// Select the deleted column in 'selected_columns' in 'columns'
		sortAvailableFields(selected_value);
	}
}

function columnUp()
{
	var selected_columns = dhtml.getElementById("selected_columns");
	
	if(selected_columns.selectedIndex >= 0) {
		var previous_option_index = selected_columns.selectedIndex - 1;
		
		if(previous_option_index >= 0) {
			var previous_option = selected_columns.options[previous_option_index];
			var selected_option = selected_columns.options[selected_columns.selectedIndex];

			selected_columns.options[previous_option_index] = new Option(selected_option.text, selected_option.value);
			selected_columns.options[selected_columns.selectedIndex] = new Option(previous_option.text, previous_option.value);
			
			selected_columns.options[previous_option_index].selected = true;
		}
	}
}

function columnDown()
{
	var selected_columns = dhtml.getElementById("selected_columns");
	
	if(selected_columns.selectedIndex >= 0) {
		var next_option_index = selected_columns.selectedIndex + 1;
		
		if(next_option_index < selected_columns.options.length) {
			var next_option = selected_columns.options[next_option_index];
			var selected_option = selected_columns.options[selected_columns.selectedIndex];

			selected_columns.options[next_option_index] = new Option(selected_option.text, selected_option.value);
			selected_columns.options[selected_columns.selectedIndex] = new Option(next_option.text, next_option.value);
			
			selected_columns.options[next_option_index].selected = true;
		}
	}
}

function sortAvailableFields(selectedId)
{
	var columns = dhtml.getElementById("columns");
	var properties = new Array();
	
	for(var i = columns.options.length - 1; i >= 0; i--)
	{
		var property = new Object();
		property["id"] = columns.options[i].value;
		property["name"] = columns.options[i].text;
		properties.push(property);
		columns.remove(i);
	} 

	properties.sort(sortColumns);

	for(var i = 0; i < properties.length; i++)
	{
		columns.options[columns.options.length] = new Option(properties[i]["name"], properties[i]["id"]);
		
		if(properties[i]["id"] == selectedId) {
			columns.options[columns.options.length - 1].selected = true;
		}
	}
}

function orderColumns(a, b)
{
	if(a["order"] > b["order"]) return 1;
	if(a["order"] < b["order"]) return -1;
	return 0;
}

function sortColumns(a, b)
{
	if(a["name"] > b["name"]) return 1;
	if(a["name"] < b["name"]) return -1;
	return 0;
}
