function initContact()
{
	// Fileas
	setFileAs();
	
	// Email Address 1
	dhtml.getElementById("email_address").value = dhtml.getElementById("email_address_1").value;
	dhtml.getElementById("email_address_display_name").value = dhtml.getElementById("email_address_display_name_1").value;

	// Address
	var mailing_address = dhtml.getElementById("mailing_address").value;
	if(parseInt(mailing_address) > 0) {
		dhtml.setValue(dhtml.getElementById("checkbox_mailing_address"), true);
	}
	
	// Default: Business Address
	var address = dhtml.getElementById("business_address").value;
	switch(mailing_address)
	{
		// Home
		case "1":
			address = dhtml.getElementById("home_address").value;
			break;
		// Other
		case "3":
			address = dhtml.getElementById("other_address").value;
			break;
	}
	
	dhtml.setValue(dhtml.getElementById("select_address"), mailing_address);
	dhtml.getElementById("selected_address").value = mailing_address;
	dhtml.getElementById("address").value = address;

	// Birthday
	dhtml.setDate(dhtml.getElementById("birthday"));
	
	// Wedding Anniversary
	dhtml.setDate(dhtml.getElementById("wedding_anniversary"));
	
	// Private
	if(dhtml.getElementById("sensitivity").value == "2") {
		dhtml.setValue(dhtml.getElementById("checkbox_private"), true);
	}
}

function submitContact()
{
	// File As
	dhtml.getElementById("fileas").value = dhtml.getValue(dhtml.getElementById("select_fileas"));

	// Current Email Address
	var selected_email_address = dhtml.getElementById("selected_email_address");
	var email_address = dhtml.getElementById("email_address");
	var email_address_display_name = dhtml.getElementById("email_address_display_name");
	onUpdateEmailAddress(); // update display_name

	dhtml.getElementById("email_address_" + selected_email_address.value).value = email_address.value;
	dhtml.getElementById("email_address_display_name_" + selected_email_address.value).value = email_address_display_name.value;
	
	// Current Address
	var selected_address = dhtml.getElementById("selected_address");
	var address = dhtml.getElementById("address");
	
	var address_element_id = "business";
	switch(selected_address.value)
	{
		case "1":
			address_element_id = "home";
			break;
		case "3":
			address_element_id = "other";
			break;
	}
	
	dhtml.getElementById(address_element_id + "_address").value = address.value;
	
	// Mailing Address
	var mailing_address = dhtml.getElementById("mailing_address");
	var checkbox_mailing_address = dhtml.getElementById("checkbox_mailing_address");
	if(checkbox_mailing_address.checked) {
		mailing_address.value = selected_address.value;
	}
	
	// Birthday
	if(dhtml.getElementById("text_birthday").value != ""){
		dhtml.getElementById("birthday").value = Date.parseDate(dhtml.getElementById("text_birthday").value, _("%d-%m-%Y")).getTime()/1000;
	}else{
		dhtml.getElementById("birthday").value = "";
	}
	
	// Special Date
	if(dhtml.getElementById("text_wedding_anniversary").value != ""){
		dhtml.getElementById("wedding_anniversary").value = Date.parseDate(dhtml.getElementById("text_wedding_anniversary").value, _("%d-%m-%Y")).getTime()/1000;
	}else{
		dhtml.getElementById("wedding_anniversary").value = "";
	}

	// Private
	var checkbox_private = dhtml.getElementById("checkbox_private");
	if(checkbox_private.checked) {
		dhtml.getElementById("sensitivity").value = "2";
		dhtml.getElementById("private").value = "1";
	} else {
		dhtml.getElementById("sensitivity").value = "0";
		dhtml.getElementById("private").value = "-1";
	}
	
	// Contacts
	dhtml.getElementById("contacts_string").value = dhtml.getElementById("contacts").value;
	
	submit_contact();
}

function setFileAs()
{
	var fileas = dhtml.getElementById("fileas").value;
	var select_fileas = dhtml.getElementById("select_fileas");
	var display_name = dhtml.getElementById("display_name");
	
	// Remove all options in select list
	if(select_fileas.options.length > 0) {
		for(var i = select_fileas.options.length - 1; i >= 0; i--)
		{
			select_fileas.remove(i);
		} 
	}
	
	// Remove prefix and suffix of name.
	var name = display_name.value.replace(dhtml.getElementById("display_name_prefix").value, "").replace(dhtml.getElementById("generation").value, "").replace(",", "");
	
	// Split display name ([0] => SURNAME, [1] => GIVEN NAME, [2] => MIDDLE NAME)
	var names = name.split(" ");

	// Remove white spaces in array
	var tmpnames = names;
	names = new Array();
	for(var i = 0; i < tmpnames.length; i++)
	{
		if(tmpnames[i].length > 0 && tmpnames[i].trim() != "") {
			names.push(tmpnames[i].trim());
		}
	}
	
	// Build up two different options (SURNAME, GIVEN NAME MIDDLE NAME and GIVENNAME MIDDLE NAME SURNAME)
	var	surname = names.join(" ");
	var givenname = "";
	if(names.length == 1) {
		givenname = names[0];
	}else{
		givenname = names[names.length-1] + ", ";
		names.splice(names.length-1,1);
		givenname += names.join(" ");
	}
	
	// Add the two options to select list
	select_fileas.options[0] = new Option(surname, surname);
	select_fileas.options[1] = new Option(givenname, givenname);
	
	// Check if company name is set
	var company_name = dhtml.getElementById("company_name");
	if(company_name.value != "") {
		// Add company name to select list
		select_fileas.options[2] = new Option(company_name.value, company_name.value);
		
		// Add two options which contains the company name and the full name
		select_fileas.options[3] = new Option(company_name.value + " (" + surname + ")", company_name.value + " (" + surname + ")");
		select_fileas.options[4] = new Option(company_name.value + " (" + givenname + ")", company_name.value + " (" + givenname + ")");
		select_fileas.options[5] = new Option(surname + " (" + company_name.value + ")", surname + " (" + company_name.value + ")");
		select_fileas.options[6] = new Option(givenname + " (" + company_name.value + ")", givenname + " (" + company_name.value + ")");
	}
	
	// Set selected value
	var isFileasSet = dhtml.setValue(dhtml.getElementById("select_fileas"), fileas);
	// If fileas is not selected add new option
	if(!isFileasSet && fileas != "") {
		select_fileas.options[select_fileas.options.length] = new Option(fileas, fileas);
		select_fileas.options[select_fileas.options.length - 1].selected = true;
	}
}

function onChangeEmailAddress()
{
	var select_email_address = dhtml.getElementById("select_email_address");
	var selected_email_address = dhtml.getElementById("selected_email_address");
	var email_address = dhtml.getElementById("email_address");
	var email_address_display_name = dhtml.getElementById("email_address_display_name");
	
	dhtml.getElementById("email_address_" + selected_email_address.value).value = email_address.value;
	dhtml.getElementById("email_address_display_name_" + selected_email_address.value).value = email_address_display_name.value;
	
	selected_email_address.value = select_email_address.options[select_email_address.selectedIndex].value;

	email_address.value = dhtml.getElementById("email_address_" + selected_email_address.value).value;
	email_address_display_name.value = dhtml.getElementById("email_address_display_name_" + selected_email_address.value).value;
}

function onUpdateEmailAddress()
{
	var email_address = dhtml.getElementById("email_address");
	var email_address_display_name = dhtml.getElementById("email_address_display_name");
	var select_fileas = dhtml.getElementById("select_fileas");
	
	if (email_address_display_name.value.trim()==""){
		email_address_display_name.value = "("+email_address.value.trim()+")";
		if (select_fileas.value.trim()!=""){
			email_address_display_name.value = select_fileas.value.trim()+" "+email_address_display_name.value;
		}
	}
}

function onChangeAddress()
{
	var select_address = dhtml.getElementById("select_address");
	var selected_address = dhtml.getElementById("selected_address");
	var mailing_address = dhtml.getElementById("mailing_address");
	var checkbox_mailing_address = dhtml.getElementById("checkbox_mailing_address");
	var address = dhtml.getElementById("address");
	
	var address_element_id = "business";
	switch(selected_address.value)
	{
		case "1":
			address_element_id = "home";
			break;
		case "3":
			address_element_id = "other";
			break;
	}
	
	dhtml.getElementById(address_element_id + "_address").value = address.value;
	
	selected_address.value = select_address.options[select_address.selectedIndex].value;

	var address_element_id = "business";
	switch(selected_address.value)
	{
		case "1":
			address_element_id = "home";
			break;
		case "3":
			address_element_id = "other";
			break;
	}

	address.value = dhtml.getElementById(address_element_id + "_address").value
	if(selected_address.value == mailing_address.value) {
		dhtml.setValue(checkbox_mailing_address, true);
	} else {
		dhtml.setValue(checkbox_mailing_address, false);
	}
}

function onChangeMailingAddress()
{
	var mailing_address = dhtml.getElementById("mailing_address");
	var selected_address = dhtml.getElementById("selected_address");
	
	mailing_address.value = selected_address.value;
}

function eventContactItemSendMailTo()
{
	var toValue = dhtml.getElementById("display_name").value+" <"+dhtml.getElementById("email_address").value+">";
	webclient.openWindow(this, "createmail", DIALOG_URL+"task=createmail_standard&to="+escape(toValue));
}

function categoriesCallBack(categories)
{
	dhtml.getElementById("categories").value = categories;
}

function abCallBack(recipients)
{
	dhtml.getElementById("contacts").value = recipients["contacts"].value;
}
