function compose_loadSettings(settings){
	var value;
	var field;
	
	// format
	value = settings.get("createmail/mailformat","html");
	field = dhtml.getElementById("compose_format");
	field.value = value;

	// reply to
	value = settings.get("createmail/reply_to","");
	field = dhtml.getElementById("compose_replyto");
	field.value = value;

	// close on reply
	value = settings.get("createmail/close_on_reply","no");
	field = dhtml.getElementById("compose_close_on_reply");
	field.checked = (value=="yes");

	// request read receipt
	value = settings.get("createmail/always_readreceipt","false");
	field = dhtml.getElementById("compose_readreceipt");
	field.checked = (value=="true");

	// autosave unsent emails
	value = settings.get("createmail/autosave","false");
	field = dhtml.getElementById("compose_autosave");
	field.checked = (value=="true");
	value = settings.get("createmail/autosave_interval",3);
	field = dhtml.getElementById("compose_autosave_interval");
	field.value = value;

	// cursor position when replying to mail
	value = settings.get("createmail/cursor_position", "start");
	field = dhtml.getElementById("compose_cursorposition");
	field.value = value;

	// from address
	value = settings.get("createmail/from","");
	field = dhtml.getElementById("compose_email_from_address");
	while(field.options.length > 0){ // clear select box
		field.remove(0);
	}
	var email_addresses = value.split(",");
	for(var i=0;i<email_addresses.length;i++){
		if(email_addresses[i].trim().length > 0){
			field.options[field.options.length] = new Option(email_addresses[i], email_addresses[i]);
		}
	}
	sortSelectBox(field);

	var addButton = dhtml.getElementById("compose_email_add_from");
	dhtml.addEvent(-1, addButton, "mouseover", eventMenuMouseOverTopMenuItem);
	dhtml.addEvent(-1, addButton, "mouseout", eventMenuMouseOutTopMenuItem);

	var delButton = dhtml.getElementById("compose_email_del_from");
	dhtml.addEvent(-1, delButton, "mouseover", eventMenuMouseOverTopMenuItem);
	dhtml.addEvent(-1, delButton, "mouseout", eventMenuMouseOutTopMenuItem);
}

function compose_saveSettings(settings){
	var field;
	
	// format
	field   = dhtml.getElementById("compose_format");
	settings.set("createmail/mailformat",field.value);

	// reply to
	field = dhtml.getElementById("compose_replyto");
	settings.set("createmail/reply_to",field.value);

	// close on reply
	field = dhtml.getElementById("compose_close_on_reply");
	settings.set("createmail/close_on_reply",field.checked?"yes":"no");

	// request read receipt
	field = dhtml.getElementById("compose_readreceipt");
	settings.set("createmail/always_readreceipt",field.checked?"true":"false");
	
	// autosave unsent emails
	field = dhtml.getElementById("compose_autosave");
	settings.set("createmail/autosave",field.checked?"true":"false");
	field = dhtml.getElementById("compose_autosave_interval");
	settings.set("createmail/autosave_interval", Number(field.value));

	// cursor position
	field = dhtml.getElementById("compose_cursorposition");
	settings.set("createmail/cursor_position", field.value);

	// from address
	field = dhtml.getElementById("compose_email_from_address");
	var values = new Array();
	for(var i=0;i<field.options.length;i++){
		if(field.options[i].value != ""){
			values[i] = field.options[i].value;
		}
	}
	var value = "";
	if(values.length > 0){
		value = values.join(",");
	}
	settings.set("createmail/from", value);
}

function compose_delFromAddress(){
	var field = dhtml.getElementById("compose_email_from_address");
	if(field.selectedIndex >= 0){
		for(var i=(field.options.length-1);i>=0;i--){
			if(field.options[i].selected){
				field.remove(i);
			}
		}
	}
}

function compose_addCallBack(result) {
	var name = result.name;
	var email = result.email;
	
	var field = dhtml.getElementById("compose_email_from_address");

	if (name.length<1){
		name = email;
	}

	name = name.replace("<", "");
	name = name.replace(">", "");

	field.options[field.options.length] = new Option(name + " <" + email + ">", name + " <" + email + ">");

	sortSelectBox(field);
	
}

function openEditSignatures(){
	webclient.openModalDialog(-1, 'signatures', DIALOG_URL+'&task=signatures_modal', 710, 550);
}