/**
* Adding trim function to the String class
*/
String.prototype.trim = function() 
{ 
	return this.replace(/^[\s\xA0]+|[\s\xA0]+$/g, ""); 
}

String.prototype.isArgument = function()
{
	return /^([a-zA-Z]){1,}=([0-9]){1,}$/.test(this);
}

String.prototype.htmlEntities = function()
{
	var tmp = this.replace(/&/g, "&amp;");
	tmp = tmp.replace(/</g, "&lt;");
	tmp = tmp.replace(/>/g, "&gt;");
	return tmp;
}

/**
 * Returns an string with the extra characters/words "broken".
 *
 * maxLength  maximum amount of characters per line
 * breakWith  string that will be added whenever it's needed to break the line
 * cutWords   if true, the words will be cut, so the line will have exactly "maxLength" characters, otherwise the words won't be cut
 *
 * Original by Jonas Raoni Soares Silva (http://jsfromhell.com/string/wordwrap)
 * Modified by nkallen (http://snippets.dzone.com/posts/show/869)
 * Modified by M. Erkens (m.erkens@zarafa.com)
 */
String.prototype.wordWrap = function(maxLength, breakWidth, cutWords){
	var i, j, s, result = this.split("\n");
	if(maxLength > 0) for(i in result){
		for(s = result[i], result[i] = ""; s.length > maxLength;
				j = cutWords ? maxLength : (j = s.substr(0, maxLength).match(/\S*$/)).input.length - j[0].length
				|| maxLength,
				result[i] += s.substr(0, j) + ((s = s.substr(j)).length ? breakWidth : "")
		   );
		result[i] += s;
	}
	return result.join("\n");
}

String.repeat = function(str, times)
{
	var result = "";
	for(var i=0;i<times;i++){
		result += str;
	}
	return result;
}

/**
* This function is a javascript implementation of sprintf.
* Original made by Jan Moesen, and modified by Michael Erkens for Zarafa.
*
* Original disclaimer:
*
*   This code is in the public domain. Feel free to link back to http://jan.moesen.nu/
*/
String.prototype.sprintf = function()
{
	if (!arguments || arguments.length < 1 || !RegExp) {
		return;
	}

	var str = this;
	var re = /([^%]*)%('.|0|\x20)?(-)?(\d+)?(\.\d+)?(%|b|c|d|u|f|o|s|x|X)(.*)/;
	var a = b = [], numSubstitutions = 0, numMatches = 0;
	while (a = re.exec(str)) {
		var leftpart = a[1], pPad = a[2], pJustify = a[3], pMinLength = a[4];
		var pPrecision = a[5], pType = a[6], rightPart = a[7];

		numMatches++;
		if (pType == '%') {
			subst = '%';
		} else {
			numSubstitutions++;
			if (numSubstitutions > arguments.length) {
				console.log('Error! Not enough function arguments (' + (arguments.length) + ')\nfor the number of substitution parameters in string (' + numSubstitutions + ' so far).');
			}
			var param = arguments[numSubstitutions-1];
			var pad = '';

			if (pPad && pPad.substr(0,1) == "'")
				pad = leftpart.substr(1,1);
			else if (pPad)
				pad = pPad;
			var justifyRight = true;
			if (pJustify && pJustify === "-") 
				justifyRight = false;
			var minLength = -1;
			if (pMinLength) 
				minLength = parseInt(pMinLength);
			var precision = -1;
			if (pPrecision && pType == 'f') 
				precision = parseInt(pPrecision.substring(1));
			var subst = param;
			if (pType == 'b') 
				subst = parseInt(param).toString(2);
			else if (pType == 'c') 
				subst = String.fromCharCode(parseInt(param));
			else if (pType == 'd') 
				subst = parseInt(param) ? parseInt(param) : 0;
			else if (pType == 'u') 
				subst = Math.abs(param);
			else if (pType == 'f') 
				subst = (precision > -1) ? Math.round(parseFloat(param) * Math.pow(10, precision)) / Math.pow(10, precision): parseFloat(param);
			else if (pType == 'o') 
				subst = parseInt(param).toString(8);
			else if (pType == 's') 
				subst = param;
			else if (pType == 'x') 
				subst = ('' + parseInt(param).toString(16)).toLowerCase();
			else if (pType == 'X') 
				subst = ('' + parseInt(param).toString(16)).toUpperCase();
		}
		str = leftpart + subst + rightPart;
	}
	return str;
}


// sorting select boxes
function sortSelectBox(element)
{
	var txt = new Array();
	var val = new Object();
	
	// store info in temp array's
	for(i=0; i<element.length; i++)  {
	  txt[i] = element.options[i].text;
	  val[txt[i]] = element.options[i].value;
	}

	txt.sort();

	for(i=0; i<txt.length; i++)  {
	  element.options[i].text = txt[i];
	  element.options[i].value = val[txt[i]];
	}
}



/**
 * Function will make long notation of e-mail address
 * @param name = "string" like: "Frans van Veen"
 * @param email = "string" like: "f.vanveen@zarafa.com"
 * @param html = "bool" true will return &lg;f.vanveen@zarafa.com&gt; 
 * @return "string" like: "Frans van Veen <f.vanveen@zarafa.com>" 
 */
function nameAndEmailToString(name,email,html)
{
	var result = "";
	if(name == email || name == ""){
		result = email;
	} else {
		if(html == true){
			result = name+" &lt;"+email+"&gt;";
		} else {
			result = name+" <"+email+">";
		}
	}
	return result;
}

/**
 * Function will round "value" with "decimals" 
 * NOTE: Math is a native object and can not be prototyped
 */ 
Math.roundDecimal = function(value,decimals)
{
	decimals = Math.pow(10,decimals);
	return Math.round(value*decimals)/decimals;
}

/**
* convert decimals to hex string
*/
function dec2hex(dec) 
{
	var hexChars = "0123456789ABCDEF";
	var a = dec % 16;
	var b = (dec - a)/16;
	return hexChars.charAt(b) + hexChars.charAt(a); 
}

/**
* wrapper for parseInt(,16)
*/
function hex2dec(hex)
{
	return parseInt(hex, 16);
}

/**
* binary string to hex string converter
*/
function bin2hex(bin)
{
	var result = "";
	for(var i=0; i<bin.length;i++){
		result += dec2hex(bin.charCodeAt(i));
	}
	return result;
}

/**
* hex string to binary string converter
*/
function hex2bin(hex)
{
	var result = "";
	for(var i=0; i<hex.length; i+=2){
		result += String.fromCharCode(hex2dec(hex.charAt(i)+hex.charAt(i+1)));
	}
	return result;
}

/**
 * Function will create window.console.log function for debugging
 * Use for firefox the "FireBug" extension, for more options
 */ 
if (!window.console){
	function Console()
	{
	}

	Console.prototype.log = function(msg)
	{
		alert("console.log: "+msg);
	}

	Console.prototype.info = function(msg)
	{
		alert("console.info: "+msg);
	}
	Console.prototype.trace = function()
	{
	}

	window.console = new Console;
}

function escapeHtml(text)
{
	if (text == null) return "";
	if (typeof text != "string") text = text.toString();
	return text	.replace(/&/g,"&amp;")
				.replace(/</g,"&lt;")
				.replace(/>/g,"&gt;");
}

function escapeJavascript(text)
{
	if (text == null) return "";
	if (typeof text != "string") text = text.toString();
	return text	.replace(/\\/g,"\\\\")
				.replace(/\'/g,"\\\'")
				.replace(/\"/g,"\\\"")
				.replace(/\n/g,"\\n")
				.replace(/\r/g,"\\r");
}


function getType(variable)
{
	if (variable == null)
		return "null";

	if (variable.constructor){
		var str = variable.constructor.toString();
		str = str.replace(/\/\/.*\n/g,"\n");
		str = str.replace(/\/\*[^*]*\*+([^\/\*][^*]*\*+)*\//g,"");
	
		var match = /function\s*([a-zA-Z_$][\w$]*)?\s*\(([^)]*)\)/.exec(str);
		return match[1].toLowerCase();
	}

	return typeof(variable);
}


/**
* Converts a DOM object to a simple JavaScript array
* Attributes are ignored
*
*@param object element The DOM element to convert
*@returns Object-array
*@author Michael Erkens <michael@connectux.com>
*/
function dom2array(element)
{
	var result_array = new Object;
	var hasChildTags = false;
	var textValue = "";
	
	for(var i=0; i<element.childNodes.length; i++){
		var child = element.childNodes[i];
		switch (child.nodeType){
			case 1: // tag
				hasChildTags = true;
				if (typeof(child.tagName)!="undefined"){
					if (typeof(result_array[child.tagName])!="undefined"){ // when more tags with the name exists, put them in an array
						if (getType(result_array[child.tagName])!="array"){
							result_array[child.tagName] = new Array(result_array[child.tagName]);
						}
						result_array[child.tagName].push(dom2array(child));
					}else{
						result_array[child.tagName] = dom2array(child);
					}
				}
				break;
			case 3: // textnode
				textValue += child.nodeValue.trim();
				break;
		}
	}
	if (hasChildTags){ // ignore textnodes when we have tags (textnodes contain only whitespace in that case)
		return result_array;
	}else{
		return textValue;
	}
}

function xml2text(element,depth)
{
	var result = "";
	
	if (typeof depth == "undefined") {
		depth = 0;
	}

	for(var i=0; i<element.childNodes.length; i++){
		var child = element.childNodes[i];
		switch (child.nodeType){
			case 1: 
				result += "\n" + String.repeat("\t",depth) + "<"+child.tagName;

				if (child.attributes.length>0){
					for(var j=0;j<child.attributes.length;j++){
						var attribute = child.attributes[j];
						result += " "+attribute.name+"=\""+attribute.value+"\"";
					}
				}
				result += ">\n";

				depth++;
				result += String.repeat("\t", depth)+ xml2text(child, depth).trim();
				depth--;

				result += "\n" + String.repeat("\t", depth);
				result += "</"+child.tagName+">";
				break;
			case 3: 
				result += String.repeat("\t", depth) + child.nodeValue.trim();
				break;
		}
	}
	return result;
}
/**
 * Function which opens a new window or modal window.
 * @param string url the url
 * @param string name name of the window
 * @param string window properties (width, height, etc.)
 * @param boolean isModal true - window is modal, false - window is not modal
 * @param object resultCallback callback function for modal windows
 * @return object window object 
 */ 
function dialog(url, name, feature, isModal, resultCallBack, callBackData, windowData)
{
	var result = null;
	if(url == null) {
		return false;
	}
	
	if(name == null){
		name = "";
	}
	
	if(feature == null){
		feature = "";
	}
	
	if(resultCallBack == null) {
		resultCallBack = false;
	}
	
	if(window.showModelessDialog) { // IE
		if(isModal) {
			feature = feature.replace(/,/g, ";");
			feature = feature.replace(/=/g, ":");
			
			dialogArgs = new Object;
			dialogArgs.dialogName = name;
			dialogArgs.parentWindow = self;
			dialogArgs.resultCallBack = resultCallBack;
			dialogArgs.callBackData = callBackData;
			dialogArgs.windowData = windowData;

			result = window.showModalDialog(url, dialogArgs, feature);
		} else {
			result = window.open(url, name, feature);
		}
	} else { // not IE
		if(document.getBoxObjectFor && isModal) {
			var Modal = window.open(url, name, "modal=1," + feature);
			result = Modal;
			
			var ModalFocus = function() {
				if (Modal){
					if(!Modal.closed) {
						Modal.focus();
					} else {
						Modal = null;
						window.removeEventListener("focus", ModalFocus,false);
						ModalFocus = null;
					}
				}
			}
			
			window.addEventListener("focus", ModalFocus, false);
		} else { 
			result = window.open(url,name,feature);
		}

		if(resultCallBack) {
			result.resultCallBack = resultCallBack;

			if(callBackData) 
				result.callBackData = callBackData;
		}
		if(windowData){
			result.windowData = windowData;
		}
	}
/*
	if (!result)
		alert(_("You are using a pop-up blocker. You must disable the pop-up blocker before you can use this function of the WebAccess"));
*/
	return result;
}

/**
 * Function which opens a modal dialog.
 * @param string url the url
 * @param string name name of the window
 * @param string window properties (width, height, etc.)
 * @return object window object
 */ 
function modal(url, name, feature, callback, callbackdata, windowdata)
{
	return dialog(url, name, feature, true, callback, callbackdata, windowdata);
}

/**
* returns the window object for the given window, if window doesn't exists, the window will be created
*/
function getWindowByName(name)
{	
	var result = window.open("", name);
/*
	if (!result)
		alert(_("You are using a pop-up blocker. You must disable the pop-up blocker before you can use this function of the WebAccess"));
*/
	return result;
}

function getSizeOfObject(obj)
{
	var counter = 0;
	for(var i in obj){
		counter++;
	}
	return counter;
}

/**
* Function will validate email address field 
*/
function validateEmailAddress(fieldString, forceSingleAddress, suppressPopupMsg)
{
	var result = "";
	if(!forceSingleAddress){
		var data = fieldString.split(";");
	}else{
		var data = new Array();
		data[0] = fieldString;
	}
	for(i in data){
		// check e-mail address
		var email = data[i].trim();
		var filter = new RegExp(/^([^<]*<){0,1}(([a-z0-9=_\+\.\-])+\@(([a-z0-9\-])+\.)+([a-z0-9]{2,5})+)>{0,1}$/i);
		if(email.length > 0 && !filter.test(email)){
			result += "\n"+email;
		}
	}
	if(result.length > 0){
		if (!suppressPopupMsg){
			alert(_("Please input a valid email address!")+result);
		}
		return false;
	} else {
		return true;
	}
}

function parseEmailAddress(address)
{
	// This filter is almost the same as in validateEmailAddress, and could
	// probably be used in both. But because I'm scared of breaking things,
	// here is the modified one. The only difference is that it discards
	// quotes and spaces from the fullname
	
	var filter = new RegExp(/^("?([^<"]*)"? ?<){0,1}(([a-z0-9=_\+\.\-])+\@(([a-z0-9\-])+\.)+([a-z0-9]{2,5})+)>{0,1}$/i); 
	
	// It also breaks coloring in my editor, so here is a quote to stop the runaway string "
	
	var matches = filter.exec(address);
	var result;
	
	if(matches) {
		result = new Object;
		result.displayname = matches[2];
		result.emailaddress = matches[3];
	} else {
		result = false;
	}	
	
	return result;
	
}

function iconIndexToClassName(icon_index,messageClass, isRead)
{
	var className = "";
	switch(parseInt(icon_index,10)){
		case 261:
			if (isRead) {
				className += "icon_mail_replied";
			}else{
				className += "icon_mail_replied_unread";
			}
			break;
		case 262:
			if (isRead) {
				className += "icon_mail_forwarded";
			}else{
				className += "icon_mail_forwarded_unread";
			}
			break;
		case 771:
			className += "icon_stickynote_yellow";
			break;
		case 770:
			className += "icon_stickynote_pink";
			break;
		case 768:
			className += "icon_stickynote_blue";
			break;
		case 769:
			className += "icon_stickynote_green";
			break;
		case 772:
			className += "icon_stickynote_white";
			break;
		case 1280:
			className += "icon_task";
			break;
		case 512:
			className += "icon_contact";
			break;
		case 514:
			className += "icon_distributionlist";
			break;
		case 1024:
			className += "icon_appointment";
			break;
		default:
			switch(messageClass){
				case "IPM.Appointment":
					className += "icon_appointment";
					break;
				case "IPM.Task":
					className += "icon_task";
					break;
				case "IPM.StickyNote":
					className += "icon_stickynote_yellow";
					break;
				case "IPM.Contact":
					className += "icon_contact";
					break;
				case "IPM.DistList":
					className += "icon_distributionlist";
					break;
				case "IPM.DistList.Organization":
					className += "icon_company";
					break;
				case "IPM.Schedule.Meeting.Request":
					className += "icon_meetingrequest";
					break;
				case "IPM.Schedule.Meeting.Resp.Pos":
					className += "icon_meetingrequest_pos";
					break;
				case "IPM.Schedule.Meeting.Resp.Tent":
					className += "icon_meetingrequest_tent";
					break;
				case "IPM.Schedule.Meeting.Resp.Neg":
					className += "icon_meetingrequest_neg";
					break;
				case "IPM.Schedule.Meeting.Canceled":
					className += "icon_meetingrequest_canceled";
					break;
				case "REPORT.IPM.Note.IPNNRN":
					className += "icon_report_decline";
					break;
				case "REPORT.IPM.Note.IPNRN":
					className += "icon_report_accept";
					break;
				case "REPORT.IPM.Note.NDR":
					className += "icon_report_ndr";
					break;
				case "IPM.Note.StorageQuotaWarning":
					className += "icon_newmail";
					break;
				default:
					if (isRead){
						className += "icon_mail";
					}else{
						className += "icon_newmail";
					}
					break;
			}
			break;
	}
	return className;
}

function convertPlainToHtml(content)
{
	content = content.replace(/</g, "&lt;");
	content = content.replace(/>/g, "&gt;");
				
	// replace in body

	// simple text markup *bold* and _underlined_ text
	content = content.replace(/(^|\s)(\*[^\*_\n\r\s][^\*_\n\r]+[^\*_\n\r\s]\*)($|\s)/ig, "$1<strong>$2</strong>$3"); // bold
	content = content.replace(/(^|\s)(_[^_\*\n\r\s][^_\*\n\r]+[^_\*\n\r\s]_)($|\s)/ig, "$1<span style=\"text-decoration: underline\">$2</span>$3"); // underline
				
	// e-mail
	content = content.replace(/(^|\b|\s)(mailto:){0,1}([a-z0-9_'+*$%\^&!\.\-]+\@(?:[a-z0-9\-]+\.)+[a-z]{2,})(\?subject=[a-z0-9\+\%]+){0,1}($|[\s,;>\]\)])/ig, "$1<a href=\"mailto:$3$4\" onclick=\"parent.eventReadmailClickEmail(false,this,\'click\');return false;\">$3$4</a>$5");

	// url
	content = content.replace(/(((https{0,1}|ftp):\/\/([a-z0-9\-\_]+@){0,1}|www\.)([a-z0-9\-]+[a-z0-9\.]*)+\.[a-z0-9]+(:[0-9]{1,5}){0,1}(\/[a-z0-9\-_#&@\?=%+;:\.\[\]~\$!\*'\(\),\{\}|\^`]*)*)/ig, "<a href=\"$1\" target=\"_blank\">$1</a>");
	content = content.replace(/(<a href\=\"www)/ig, "<a href=\"http://www");
		
	return content;
}

function convertAnchors(content)
{
    content = content.replace(/<a href=\"#(.*)\"/gi, "<a target=\"_self\" href=\"javascript:parent.DHTML.prototype.scrollFrame('html_body', '$1');\"");
    
    return content;
}

function removeTagFromSource(content, tagName, closingTag, saveDocOnNoClosingTag){
	var openIndex, closeIndex;
	while((openIndex = content.search(new RegExp("<"+tagName, "gim"))) && openIndex >= 0){
		if(closingTag){
			closeIndex = content.search(new RegExp("</"+tagName, "gim"))
			if(closeIndex >= 0){
				closeIndex = content.indexOf(">", closeIndex) + 1;
			// No closing tag found, use end of string
			}else if(saveDocOnNoClosingTag){
				closeIndex = content.length;
			// Fetch index after tag
			}else{
				closeIndex = content.indexOf(">", openIndex) + 1;
			}
		// No closing tag, only remove single tag
		}else{
			// Fetch index after tag
			closeIndex = content.indexOf(">", openIndex) + 1;
		}
		content = content.slice(0, openIndex) + content.slice(closeIndex, content.length);
	}
	return content;
}

/* 
 * This function collapses a DOM XML describing a rule into a much more readable
 * and easier-to-use javascript object model. It does this by:
 *
 * 1) Putting items that are not arrays into objects with property 'value' containing the nodeValue and property 'attributes' being an object with attrname => attrvalues
 * 2) Putting items that are arrays into javascript Arrays
 *
 * This means we do not support:
 * 1) Arrays with attributes
 * 2) Arrays with content
 * 3) Multiple attributes with the same name
 * .. and possibly some other gnarly XML DOM constructs
 *
 * But it makes it possible to do this
 *
 * rule.restriction[1].property.attributes.proptag = 0x60000003;
 *
 * Instead of
 *
 * getXMLNode(getXMLNode(getXMLNode(rule, "restriction", 1), "property").attributes, "proptag").nodeValue = 0x60000003;
 */

function collapseXML(xmlroot) {
	var result = new Object();
	if(!xmlroot.childNodes)
		return result;
		
	for(var i=0;i<xmlroot.childNodes.length;i++) {
		var isArray = false;
		var node = xmlroot.childNodes.item(i);
	
		switch(node.nodeName) {
			case 'rule_actions':
				isArray = true;
				break;
			case 'restriction':
				if(result.restype && (result.restype.value == "RES_AND" || result.restype.value == "RES_OR"))
					isArray = true;
				break;
			case 'property':
				if(result.restype && (result.restype.value == "RES_COMMENT") || xmlroot.nodeName == "address" )
					isArray = true;

		}

		var isTextNode = node.childNodes.length == 1 && node.childNodes.item(0).nodeType == 3;

		if(isTextNode) {
			child = new Object;
			if(node.firstChild)
				child.value = node.firstChild.nodeValue;

			var attributes = new Object;
			if(node.attributes) {
				for(var j=0;j<node.attributes.length;j++) {
					attributes[node.attributes.item(j).nodeName] = node.attributes.item(j).firstChild.nodeValue;
				}
			}

			child.attributes = attributes;
		} else {
			child = collapseXML(node);
		}
		
		if(isArray) {
			if(typeof(result[node.nodeName]) != "object")
				result[node.nodeName] = new Array();
			result[node.nodeName].push(child);
		} else {
			if(node.nodeName != '#text')
				result[node.nodeName] = child;
		}
	}
	return result;
}

/**
 * Converts a javascript object model to xmlbuilder-compatible
 * objects.
 *
 */
function buildXML(root)
{
	var result = new Object();
	
	if(typeof(root) != "object") {
		return result;
	}

	var key;

	for(key in root) {
		if(typeof(root[key])!="undefined" && typeof(root[key].value) != "object" && typeof(root[key].value) != "undefined") {
			// entry is value, convert to single-item array
			var entry = new Array;
			entry.push(new Object);
			entry[0]["_content"] = root[key].value;
			if(root[key].attributes)
				entry[0]["attributes"] = root[key].attributes;
			else
				entry[0]["attributes"] = new Array();
			
			result[key] = entry;
		} else if(typeof(root[key]) == "object" && typeof(root[key].length) != "undefined") {
			// entry is array
			var entry = new Array();
			for(var i=0;i<root[key].length;i++) {
				if(typeof(root[key][i].value) != "object" && typeof(root[key][i].value) != "undefined") {
					// array of values, convert to multi-value array
					var valentry = new Object;
					valentry["_content"] = root[key][i].value;
					if(root[key][i].attributes)
						valentry["attributes"] = root[key][i].attributes;
					else
						valentry["attributes"] = new Array();
					entry.push(valentry);
				} else {
					// array of objects (array of arrays is not possible), convert to array of subobjects
					entry.push(buildXML(root[key][i]));
				}
			}
			result[key] = entry;
		} else {
			// entry is single object, convert to single-entry array
			var entry = new Array;
			entry.push(buildXML(root[key]));
			result[key] = entry;
		}
	}
	return result;
}

/**
 * Converts a javascript object model to DOM
 * objects.
 *
 */
function buildDOM(root, type)
{
	var dom = new XMLRequest("pre");
	var xml = buildXML(root);
	
	var container = new Object;
	container[type] = xml;
	
	dom.addData(module, type, container);
	
	return dom.xmlbuilder.getXML();
}

/**
 * Function which returns true, if object is Array()
 * @param object Object
 * @return boolean true if object is Array otherwise false if not.
 */
function isArray(object)
{
	if (object == "undefined" || object.constructor.toString().indexOf("Array") == -1)
      return false;
   else
      return true;
}
/**
 * Function which returns true, if needle is found in the array
 * @param mixed needle
 * @param array haystack
 * @return boolean true needle is found in haystack
 */
function inArray(needle, haystack)
{
	if (typeof needle != "undefined" && isArray(haystack)){
		for(var i in haystack){
			if (haystack[i] === needle) return true;
		}
	}
	return false;
}