/* 
 * General protoypes
 *
 * (c) NLnet Labs, 2004
 *  
 * See the file LICENSE for the license
 *
 */

#ifndef _PROTOTYPE_H
#define _PROTOTYPE_H
int get_next_token(FILE *, char *);
int get_last_token(FILE *, char *);
struct t_rdata * get_next_rdata(FILE *);
struct t_rdata * get_last_rdata(FILE *);
size_t get_next_token_string(char *, char *, size_t len);
size_t get_next_rdata_string(char *, struct t_rdata **);
struct t_rr * pubkey_fromfilepointer(FILE *);
struct t_rr * pubkey_fromfile(const char *);
struct t_rr * pubkey_fromstring(char *);
int axfr(struct t_dpacket *, struct t_rr *);
int query(struct t_rr *, struct t_rr *, int);
void warning(const char *fmt, ... );
void error(const char *fmt, ... );
void mesg(const char *fmt, ... );
void verbose(const char *fmt, ... );
void vverbose(const char *fmt, ... );
void debug(const char *fmt, ... );
int nsec_walk(char *, struct t_rr *, int);
#endif /* _PROTOTYPE_H */
