/**
 * nsecwalk.c walk a nameserver using the nsecs
 *
 * display all the name until we reach the soa again
 *
 * (c) NLnet Labs, 2004
 * 
 * See the file LICENSE for the license
 *
 */

#include "common.h"

int 
nsec_walk(char *zone, struct t_rr* nameserver, int proto)
{
	struct t_rr *q;
	struct t_rdata *z;
	struct t_rdata *z_orig;
	struct t_rr *nsec = NULL;
	struct t_dpacket *a = NULL;
	int first_pass = 0;

	z_orig = rdata_create((uint8_t *) zone, strlen(zone));
	z = rdata_create((uint8_t *) zone, strlen(zone));

	while (first_pass == 0 || rdata_cmp(z_orig, z) == 0) {
		first_pass = 1;
	
		q = rr_create(z, TYPE_NSEC, DEF_TTL, SEC_QUESTION);
		a = do_query_rr(q, nameserver, proto);

		if (a) {
			/* try to extract the nsec if its there */
			nsec = dpacket_get_rrset(z, TYPE_NSEC, a, SEC_ANSWER);

			if (nsec) {
				print_rr(nsec, NO_FOLLOW);
				
				xfree(z);
				z = nsec->rdata[0];
			} else {
				warning("Could not retrieve the NSEC");
				return RET_FAIL;
			}
		} else {
			warning("Packet sending failed");
			return RET_FAIL;
		}
	}
	return RET_SUC;
}

