/***************************************************************************
                          factors.cpp  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Birgit Schulz
    email                : B.Schulz@Superlehrer.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "factors.h"
#include "factors.moc"

#include <krestrictedline.h>
#include <ktextbrowser.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kapplication.h>

#include <qlabel.h>
#include <qstring.h>

#include <math.h>




Factors::Factors(QWidget *parent, const char *name ) : FactorsD(parent,name)
    {
	
 
}
Factors::~Factors()
{
}

void Factors::changeView(EFunctions eSelected)
{
    //Leeren der Boxen
    KTextBrowserResult->setText("");
    KRestrictedLineFirstInfo->setText("");
    KRestrictedLineSecondInfo->setText("");
    KRestrictedLineSecondInfo->setEnabled(false);

    //2.Feld einschalten
    TextLabelSecondInfo->show();
    KRestrictedLineSecondInfo->show();

    switch (eSelected)
    {
        case Factorize:
        {
            TextLabelInformation->setText(i18n("Factorize a given number"));
            TextLabelFirstInfo->setText(i18n("One number:"));

            TextLabelSecondInfo->hide();
            KRestrictedLineSecondInfo->hide();

            m_eSelected = Factorize;
            m_iNumBoxNeed = 1;
            break;
        }

        case FindFactors:
        {
            TextLabelInformation->setText(i18n("Find all factors of a given number"));
            TextLabelFirstInfo->setText(i18n("One number:"));

            TextLabelSecondInfo->hide();
            KRestrictedLineSecondInfo->hide();
            
            m_eSelected = FindFactors;
            m_iNumBoxNeed = 1;
            break;
        }

        case FindHCF:
        {
            TextLabelInformation->setText(i18n("Find the HCF of two numbers"));
            TextLabelFirstInfo->setText(i18n("First number:"));
            TextLabelSecondInfo->setText(i18n("Second number:"));
            TextLabelSecondInfo->setEnabled(true);
            KRestrictedLineSecondInfo->setEnabled(true);

            m_eSelected = FindHCF;
            m_iNumBoxNeed = 2;
            break;
        }

        case FindLCM:
        {
            TextLabelInformation->setText(i18n("Find the LCM of two numbers"));
            TextLabelFirstInfo->setText(i18n("First number:"));
            TextLabelSecondInfo->setText(i18n("Second number:"));
            TextLabelSecondInfo->setEnabled(true);
            KRestrictedLineSecondInfo->setEnabled(true);

            m_eSelected = FindLCM;
            m_iNumBoxNeed = 2;
            break;
        }

        case ProvePrime:
        {
            TextLabelInformation->setText(i18n("Prove if given number is prime"));
            TextLabelFirstInfo->setText(i18n("One number:"));

            TextLabelSecondInfo->hide();
            KRestrictedLineSecondInfo->hide();

            m_eSelected = ProvePrime;
            m_iNumBoxNeed =1;
            break;
        }

        case FindPrime:
        {
            TextLabelInformation->setText(i18n("Find prime numbers in a range"));
            TextLabelFirstInfo->setText(i18n("Start number:"));
            TextLabelSecondInfo->setText(i18n("End number:"));
            TextLabelSecondInfo->setEnabled(true);
            KRestrictedLineSecondInfo->setEnabled(true);

            m_eSelected = FindPrime;
            m_iNumBoxNeed = 2;
            break;
        }
    }
}

void Factors::slotClear()
{
    KRestrictedLineFirstInfo->setText("");
    KRestrictedLineSecondInfo->setText("");
    KTextBrowserResult->setText("");
    KPushButtonCalculate->setEnabled(false);
    KPushButtonClear->setEnabled(false);

}


void Factors::slotCalculate()
{
    switch (m_eSelected)
    {
        case FindFactors: //Find Factors
        {
            QString qsNumber = KRestrictedLineFirstInfo->text();
            int iNumber = qsNumber.toInt();
            int iMax = sqrt(iNumber);
            int iFactorRest;
            QString qsFactor,qsFactorRest;
            QString qsResult = i18n("The factors of ") + qsNumber + i18n(" are {1,");
            QString qsResult2 = qsNumber + " }";

            for (int iFactor = 2; iFactor <= iMax ; ++iFactor)
            {
                if (iNumber % iFactor == 0)
                {
                    iFactorRest= iNumber/iFactor;
                    qsFactor = qsFactor.arg(iFactor);
                    qsFactorRest = qsFactorRest.arg(iFactorRest);
                    qsResult += qsFactor + ",";
                    qsResult2 = qsFactorRest + "," + qsResult2;
                }
                qsFactor = "";
                qsFactorRest = "";
            }
            qsResult.truncate(qsResult.length());
            qsResult += qsResult2;
            KTextBrowserResult->setText(qsResult);
            break;
        }

        case ProvePrime: //Prove for Prime-Number
        {
            QString qsNumber = KRestrictedLineFirstInfo->text();
            int iNumber = qsNumber.toInt();
            int iMax = iNumber;
            int iFactor2;
            QString qsFactor, qsFactor2;
            QString qsResult = i18n("The number ") + qsNumber;
            bool bIsPrime = TRUE;
            for (int iFactor = 2; iFactor < iMax ; ++iFactor)
            {
                if (iNumber % iFactor == 0)
                {
                    iFactor2 = iNumber = iNumber / iFactor;
                    qsFactor = qsFactor.arg(iFactor);
                    qsFactor2 = qsFactor2.arg(iFactor2);
                    qsResult += i18n(" is not a prime-number because\n");
                    qsResult += qsNumber + "=" + qsFactor + "*" + qsFactor2;
                    bIsPrime = FALSE;
                    break;
                }
            }
            if (bIsPrime)
            {
                qsResult +=  i18n(" is a prime-number");
            }
            KTextBrowserResult->setText(qsResult);
            break;
        }

        case FindPrime: //Find Prime-Numbers
        {
            KTextBrowserResult->setText(i18n("This function is not yet implemented."));
            break;
        }

        case FindHCF: //Find HCF
        {
            QString qsNumber1 = KRestrictedLineFirstInfo->text();
            QString qsNumber2 = KRestrictedLineSecondInfo->text();
            int iNumber1 = qsNumber1.toInt();
            int iNumber2 = qsNumber2.toInt();
            int iHCF = 1;
            QString qsHCF;
            QString qsResult = i18n("The <b>H</b>ighest <b>C</b>ommon Factor of ") + qsNumber1 + i18n(" and ") + qsNumber2 + i18n(" is");
            while (iHCF != 0)
            {
                if (iNumber1 == iNumber2)
                {
                    iHCF = iNumber1;
                    break;
                }
                if(iNumber1 > iNumber2)
                {
                    iNumber1 = iNumber1 - iNumber2;
                }
                else
                {
                    iNumber2 = iNumber2 - iNumber1;
                }
            }
            qsHCF = qsHCF.arg(iHCF);
            qsResult += qsHCF + ".";
            KTextBrowserResult->setText(qsResult);
            break;
        }

        case FindLCM: //Find LCM
        {
            QString qsNumber1 = KRestrictedLineFirstInfo->text();
            QString qsNumber2 = KRestrictedLineSecondInfo->text();
            int iNumber1 = qsNumber1.toInt();
            int iNumber2 = qsNumber2.toInt();
            int iLCM = iNumber1*iNumber2;
            int iHCF = 1;
            QString qsLCM;
            QString qsResult = i18n("The <b>L</b>owest <b>C</b>ommon <b>M</b>ultiple of ") + qsNumber1 + i18n(" and ") + qsNumber2 + i18n(" is");
            while (iHCF != 0)
            {
                if (iNumber1 == iNumber2)
                {
                    iHCF = iNumber1;
                    break;
                }
                if(iNumber1 > iNumber2)
                {
                    iNumber1 = iNumber1 - iNumber2;
                }
                else
                {
                    iNumber2 = iNumber2 - iNumber1;
                }
            }
            iLCM /= iHCF;
            qsLCM = qsLCM.arg(iLCM);
            qsResult += qsLCM + ".";
            KTextBrowserResult->setText(qsResult);
            break;
        }

        case Factorize:
        {
            QString qsNumber = KRestrictedLineFirstInfo->text();
            int iNumber = qsNumber.toInt();
            int iMax = iNumber;
            bool bIsPrime = TRUE;
            QString qsFactor;
            QString qsResult = i18n("The factorization of ") + qsNumber + i18n(" is: \n") + qsNumber + " = ";
            for (int iFactor = 2; iFactor < iMax ; ++iFactor)
            {
                if (iNumber % iFactor == 0)
                {
                    bIsPrime = FALSE;
                    qsFactor = qsFactor.arg(iFactor);
                    qsResult += qsFactor + " *";
                    qsFactor = "";
                    iNumber = iNumber / iFactor;
                    iFactor -= 1;
                    if (iNumber == 1) break;
                }
            }
            if (bIsPrime == TRUE)
            {
                qsResult = i18n("It is impossible to find a factorization for ") + qsNumber + i18n(" because it is a prime-number.");
            }
            else
            {
                qsResult.truncate(qsResult.length()-1);
            }
            KTextBrowserResult->setText(qsResult);
        }
    }
}

void Factors::slotCheckBoxes(const QString &qsText)
{
    if (m_iNumBoxNeed == 1)
    {
        if (qsText == "")
        {
            KPushButtonCalculate->setEnabled(false); 
            KPushButtonClear->setEnabled(false); 
        }
        else 
        {
            KPushButtonCalculate->setEnabled(true); 
            KPushButtonClear->setEnabled(true); 
        }
    }
    else
    {
         if (qsText == "")
        {
            KPushButtonCalculate->setEnabled(false); 
            KPushButtonClear->setEnabled(false); 
        }  
        else if ((KRestrictedLineFirstInfo->text() == "") || (KRestrictedLineSecondInfo->text() == "")) 
        {
            KPushButtonCalculate->setEnabled(false); 
            KPushButtonClear->setEnabled(false); 
        }
        else
        {
            KPushButtonCalculate->setEnabled(true); 
            KPushButtonClear->setEnabled(true); 
        }
    }

}
