<?php
/**
 * 
 * @package mobilewebaccess
 * @author Mans Matulewicz
 * @copyright 2006
 */
session_start();

require_once("config.php");

// check if config is correct
if (CONFIG_CHECK){
	include("class.configcheck.php");
	new ConfigCheck();
}

// gzip support
ob_start("ob_gzhandler");



require_once("mapi.php");
require_once('Smarty.class.php');
require_once("include/login.php");
require_once("include/functions.php");

require_once("include/class.message.php");
require_once("include/class.hierarchy.php");
require_once("include/class.table.php");
require_once("include/class.appointmenttable.php");
require_once("include/class.appointmentmessage.php");
require_once("include/class.contactmessage.php");
require_once("include/class.contacttable.php");
require_once("include/class.mailtable.php");
require_once("include/class.mailmessage.php");
require_once("include/class.tasktable.php");
require_once("include/class.taskmessage.php");


$smarty =  new Smarty;

// register smarty template functions
require_once("include/smarty.includes.php");

$mapi = new Mapi();

$authenticated = login(); 

header("Content-Type: text/html; charset=windows-1252");

if ($authenticated) {	
	
	$store = new hierarchy($mapi->getDefaultMessageStore());
	if ((!isSet($_GET["entryid"])) && (!isSet($_GET["type"]))) {
		$store->getcontents();
		$smarty->display('hierarchy.tpl');
	}
	else {
		$_GET["type"] = isset($_GET["type"]) ? $_GET["type"] : "";
		switch ($_GET["type"])
		{
			case "table":
				require_once("table.php");
				break;
				
			case "msg":
				require_once("msg.php");
				break;
				
			case "edit":
				require_once("edit.php");
				break;
			
			case "new":
				require_once("new.php");
				break;
			
			case "action":
				require_once("action.php");
				break;
				
			case "reply":
				require_once("reply.php");
				break;
			
			case "forward":
				require_once("forward.php");
				break;
				
			case "copy":
				require_once("copy.php");
				break;
				
			case "delete":
				require_once("delete.php");
				break;
					
			case "logout":
				session_destroy(); 
				session_start();
				if (isset($_COOKIE) && isset($_COOKIE["mobile_password"])){
					setcookie("mobile_password", false, mktime(0,0,0,1,1,0));
				}
				$authenticated = false;
				break;
			
			case "attachment":
				require_once("include/attachment.php");
				break;
			
			default:
				$store->getcontents();
				$smarty->display('hierarchy.tpl');
				break;
		}
	}
}

if (!$authenticated){
	if (isset($_COOKIE["mobile_username"])){
		$smarty->assign("username", $_COOKIE["mobile_username"]);
	}
	$smarty->display('login.tpl');
}

ob_flush();
?>
