<?php

class attachments {
	
	/**
	 * Message containing the attachments
	 *
	 * @var resource Mapi_Message
	 */
	var $message;
	
	/**
	 * Array with all attachments
	 *
	 * @var array List of Attachments
	 */
	var $attachmentslist;
	
	function attachments($message)
	{
		$this->message = $message;
		$attachtable = mapi_message_getattachmenttable($this->message);
		$attachinfo = mapi_table_queryallrows($attachtable, array(PR_ENTRYID, PR_ATTACH_LONG_FILENAME, PR_ATTACH_SIZE));
		$this->attachmentslist = array();
		foreach ($attachinfo as $key => $value)
		{
			$keys = array_keys($value);
			array_push($this->attachmentslist, new attachment($value[$keys[0]], $value[$keys[1]], $value[$keys[2]]));
		}
	}
	
	function get_attachmentlist()
	{
		return $this->attachmentslist;
	}
	
	function render()
	{
		echo "<hr>\n";
		foreach ($this->attachmentslist as $key => $value)
		{
			$value->render();
		}
	}
}
?>