<?php
/* 
	config.php
	
	The config file for the mobile webaccess.
*/

	// Set FALSE disable the config check
	define("CONFIG_CHECK", true);

	// Default Zarafa server to connect to.
	define("SERVER", "file:///var/run/zarafa");
	#define("SERVER", "http://localhost:236/zarafa");

	// Defines the base path on the server, terminated by a slash
	define('BASE_PATH', dirname($_SERVER['SCRIPT_FILENAME']) . "/");

	// Define the include paths
	set_include_path(BASE_PATH."include/" . PATH_SEPARATOR . 
					 BASE_PATH."include/smarty/" . PATH_SEPARATOR . 
					 BASE_PATH . PATH_SEPARATOR . 
					 "." . PATH_SEPARATOR . 
					 "/usr/share/php/");

	define("COOKIE_EXPIRE", 60*60*24*365); // one year

	/**************************************\
	* Template Settings / Smarty           *
	\**************************************/


	// smarty
	define("SMARTY_TEMPLATE_DIR", "render/html");
	define("SMARTY_CONFIG_DIR", "render/config");
	define("SMARTY_CACHE_DIR",	"cache"); // must be writable
	define("SMARTY_COMPILE_DIR", "templates_c"); // must be writable

	// renderer type (currently only "html")
	$config["renderer"]="html";
	
	// textmessages for when the subject or the sender not exists
	// needed to click on the item
	define('NOSENDERMSG', _("No sender"));
	define('NOSUBJECTMSG', _("No subject"));

	define('CELLSHOUR', 1);
	define('SCREENWIDTH', 240);
	
	// number of items per page
	$GLOBALS["emailsonpage"]=10;
	$GLOBALS["appointmentsonpage"]=10;
	$GLOBALS["contactsonpage"]=1000;
	$GLOBALS["tasksonpage"]=100;

	/**************************************\
	* Memory usage and timeouts            *
	\**************************************/
	
	// The maximum POST limit. To upload large files, this value must be larger than upload_max_filesize.
	ini_set('post_max_size', "31M");
	ini_set('upload_max_filesize', "30M");

	// This sets the maximum amount of memory in bytes that we are allowed to allocate. 
	ini_set('memory_limit', -1);  // -1 = no limit

	// This sets the maximum time in seconds that is allowed to run before it is terminated by the parser.	
	ini_set('max_execution_time', 300); // 5 minutes

	// BLOCK_SIZE (in bytes) is used for attachments by mapi_stream_read/mapi_stream_write
	define('BLOCK_SIZE', 1048576);

	// Maximum body size that will be sent to the client (100k by default)
	define('MAX_BODY_SIZE', 100 * 1024);	

	// Debugging
	$debug = false;

	if ($debug){
		error_reporting(E_ALL);
		ini_set("display_errors", true);
		if (file_exists("debug.php")){
			include ("debug.php");
		}else{
			// define empty dump function in case we still use it somewhere
			function dump(){}
		}	
	}else{
		ini_set("display_errors", false);
	}

?>
