// Preferences dialog box

#include "config.h"
#include "i18n.h"

#include <fx.h>
#include <fxkeys.h>

#include "icons.h"
#include "xfedefs.h"
#include "File.h"
#include "FileDialog.h"
#include "FontDialog.h"
#include "Preferences.h"
#include "XFileExplorer.h"
#include "MessageBox.h"


FXbool Theme::operator != (const Theme& t)
{
    for(int i=0;i<COLORS_NUM;i++)
        if(color[i] != t.color[i])
            return TRUE;
    return FALSE;
}

// Main window
extern FXMainWindow *mainWindow;

// Single click navigation
extern FXbool single_click;

// File tooltips
extern FXbool file_tooltips;

// Relative resizing of the panels and columns in detailed mode
extern FXbool relative_resize;


// Map
FXDEFMAP(PreferencesBox) PreferencesMap[]=
{
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_ACCEPT,PreferencesBox::onCmdAccept),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_CANCEL,PreferencesBox::onCmdCancel),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_TXTEDIT,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_TXTVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_IMGVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_ARCHIVER,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_PDFVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_VIDEOVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_AUDIOVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_XTERM,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_COLOR,PreferencesBox::onCmdColor),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_NORMALFONT,PreferencesBox::onCmdNormalFont),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_TEXTFONT,PreferencesBox::onCmdTextFont),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_THEME,PreferencesBox::onCmdTheme),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_ICON_PATH,PreferencesBox::onCmdBrowsePath),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_TRASH_BYPASS,PreferencesBox::onUpdTrashBypass),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_CONFIRM_DEL_EMPTYDIR,PreferencesBox::onUpdConfirmDelEmptyDir),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_SU_CMD,PreferencesBox::onCmdSuMode),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_SUDO_CMD,PreferencesBox::onCmdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SU_CMD,PreferencesBox::onUpdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SUDO_CMD,PreferencesBox::onUpdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_COLOR,PreferencesBox::onUpdColor),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_WHEELADJUST,PreferencesBox::onCmdWheelAdjust),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_WHEELADJUST,PreferencesBox::onUpdWheelAdjust),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SINGLE_CLICK_FILEOPEN,PreferencesBox::onUpdSingleClickFileopen),
};

// Object implementation
FXIMPLEMENT(PreferencesBox,DialogBox,PreferencesMap,ARRAYNUMBER(PreferencesMap))

// Construct window for one file
PreferencesBox::PreferencesBox(FXWindow *win, FXColor listbackcolor, FXColor listforecolor, FXColor highlightcolor): DialogBox(win,_("Preferences"), DECOR_TITLE|DECOR_BORDER)
{
    currTheme.name = _("Current Theme");
    currTheme.color[0] = getApp()->getBaseColor();
    currTheme.color[1] = getApp()->getBorderColor();
    currTheme.color[2] = getApp()->getBackColor();
    currTheme.color[3] = getApp()->getForeColor();
    currTheme.color[4] = getApp()->getSelbackColor();
    currTheme.color[5] = getApp()->getSelforeColor();
    currTheme.color[6] = listbackcolor;
    currTheme.color[7] = listforecolor;
    currTheme.color[8] = highlightcolor;

    Themes[0] = currTheme;
    Themes[1] = Theme("FOX",FXRGB(212,208,200),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(10,36,106),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[2] = Theme("GNOME2",FXRGB(220,218,213),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(75,105,131),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[3] = Theme("KDE3",FXRGB(238,238,230),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(255,222,118),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[4] = Theme("XFCE4",FXRGB(238,238,238),FXRGB(0,0,0),FXRGB(238,238,238),FXRGB(0,0,0),FXRGB(99,119,146),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[5] = Theme("CDE",FXRGB(156,153,156),FXRGB(0,0,0),FXRGB(131,129,131),FXRGB(255,255,255),FXRGB(49,97,131),FXRGB(255,255,255),FXRGB(131,129,131),FXRGB(255,255,255),FXRGB(131,129,131));
    Themes[6] = Theme("Digital CDE",FXRGB(74,121,131),FXRGB(0,0,0),FXRGB(49,76,74),FXRGB(255,255,255),FXRGB(65,80,90),FXRGB(255,255,255),FXRGB(49,76,74),FXRGB(255,255,255),FXRGB(49,76,74));
    Themes[7] = Theme("Sea Sky",FXRGB(165,178,198),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(49,101,156),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[8] = Theme("Blue Slate",FXRGB(156,186,205),FXRGB(0,0,0),FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(82,129,148),FXRGB(255,255,255),FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[9] = Theme("Human",FXRGB(0xEF,0xEB,0xE7),FXRGB(0,0,0),FXRGB(0xEE,0xEE,0xEE),FXRGB(0,0,0),FXRGB(0xB3,0x91,0x69),FXRGB(0xFF,0xFF,0xFF),FXRGB(0xEE,0xEE,0xEE),FXRGB(0,0,0),FXRGB(255,255,255));
    Themes[10] = Theme("iMac",FXRGB(205,206,205),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[11] = Theme("BeOS",FXRGB(222,218,222),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(172,170,172),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
	Themes[12] = Theme("Windows 95",FXRGB(192,192,192),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));

    // Buttons
    FXHorizontalFrame *buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X,0,0,0,0,10,10,5,5);

    // Contents
    FXHorizontalFrame *contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH);

	// Accept
    FXButton *ok = new FXButton(buttons,_("&Accept"),NULL,this,PreferencesBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    ok->addHotKey(KEY_Return);
    
    // Cancel
    new FXButton(buttons,_("&Cancel"),NULL,this,PreferencesBox::ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    
	// Switcher
    FXTabBook *tabbook = new FXTabBook(contents,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT);


    // First tab - General options
    new FXTabItem(tabbook,_("&General"),NULL);
    FXVerticalFrame *options=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);

	FXGroupBox *group=new FXGroupBox(options,_("Options"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    trashcan=new FXCheckButton(group,_("Use trash can for file deletion (safe delete)")); 
	trashbypass=new FXCheckButton(group,_("Include a command to bypass the trash can (permanent delete)"),this,ID_TRASH_BYPASS);
    autosave=new FXCheckButton(group,_("Auto save layout"));
    diropen=new FXCheckButton(group,_("Single click directory open"));
    fileopen=new FXCheckButton(group,_("Single click file open"),this,ID_SINGLE_CLICK_FILEOPEN);
    filetooltips=new FXCheckButton(group,_("Display tooltips in file and directory lists"),this,ID_FILE_TOOLTIPS);
    relativeresize=new FXCheckButton(group,_("Relative resizing of file lists"),this,ID_RELATIVE_RESIZE);
    showpathlink=new FXCheckButton(group,_("Display a path linker above file lists"),this,ID_SHOW_PATHLINK);

	group=new FXGroupBox(options,_("Mouse"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    scroll=new FXCheckButton(group,_("Smooth scrolling in file lists and text windows"));
    FXMatrix *matrix = new FXMatrix(group,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_Y);
	new FXLabel(matrix,_("Mouse scrolling speed:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    FXSpinner* spinner=new FXSpinner(matrix,3,this,PreferencesBox::ID_WHEELADJUST,JUSTIFY_RIGHT|LAYOUT_FILL_X|LAYOUT_FILL_ROW,0,0,0,0, 2,2,1,1);
    spinner->setRange(1,100);
	FXbool smoothscroll=getApp()->reg().readUnsignedEntry("SETTINGS","smooth_scroll",TRUE);
	scroll->setCheck(smoothscroll);

	group=new FXGroupBox(options,_("Root mode"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	FXRadioButton* subutton=new FXRadioButton(group,_("Authentication using su (uses root password)"),this,ID_SU_CMD);
	FXRadioButton* sudobutton=new FXRadioButton(group,_("Authentication using sudo (uses user password)"),this,ID_SUDO_CMD);
	if (getuid()==0) // Super user
	{
		subutton->disable();
		sudobutton->disable();
	}
	use_sudo=getApp()->reg().readUnsignedEntry("OPTIONS","use_sudo",FALSE);

    FXbool use_trash_can=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_can",TRUE);
	trashcan->setCheck(use_trash_can);
    
	if (trashcan->getCheck())
	{
	    FXbool use_trash_bypass=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_bypass",FALSE);
		trashbypass->setCheck(use_trash_bypass);
	}
	else
		trashbypass->disable();

	FXbool auto_save_layout=getApp()->reg().readUnsignedEntry("OPTIONS","auto_save_layout",TRUE);
	autosave->setCheck(auto_save_layout);
    
	// Single click navigation
	single_click=getApp()->reg().readUnsignedEntry("SETTINGS","single_click",SINGLE_CLICK_NONE);
	single_click=getApp()->reg().readUnsignedEntry("SETTINGS","single_click",SINGLE_CLICK_NONE);
	if (single_click==SINGLE_CLICK_DIR)
	{
		diropen->setCheck(TRUE);
		fileopen->setCheck(FALSE);
	}
	else if (single_click==SINGLE_CLICK_DIR_FILE)
	{
		diropen->setCheck(TRUE);
		fileopen->setCheck(TRUE);
	}
	else
	{
		diropen->setCheck(FALSE);
		fileopen->setCheck(FALSE);
	}
	
	// File tooltips
	if (file_tooltips==FALSE)
		filetooltips->setCheck(FALSE);
	else
		filetooltips->setCheck(TRUE);
	
	// Relative resizing
	if (relative_resize==FALSE)
		relativeresize->setCheck(FALSE);
	else
		relativeresize->setCheck(TRUE);
		
	// Display path linker
	show_pathlink=getApp()->reg().readUnsignedEntry("SETTINGS","show_pathlinker",TRUE);
	if (show_pathlink==FALSE)
		showpathlink->setCheck(FALSE);
	else
		showpathlink->setCheck(TRUE);	
		
    // Second tab - Dialogs
    new FXTabItem(tabbook,_("&Dialogs"),NULL);
    FXVerticalFrame *dialogs=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
	group=new FXGroupBox(dialogs,_("Confirmations"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    ask=new FXCheckButton(group,_("Confirm copy/move/rename/symlink"));
    dnd=new FXCheckButton(group,_("Confirm drag and drop"));
	del=new FXCheckButton(group,_("Confirm delete"));
	del_emptydir=new FXCheckButton(group,_("Confirm delete non empty directories"),this,ID_CONFIRM_DEL_EMPTYDIR);
    overwrite=new FXCheckButton(group,_("Confirm overwrite"));
	quit=new FXCheckButton(group,_("Confirm quit"));

	group=new FXGroupBox(dialogs,_("Warnings"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
#if defined(linux)
    mount=new FXCheckButton (group,_("Warn when mount points are not responding"));
	show_mount=new FXCheckButton(group, _("Display mount/umount success messages"));
#endif
    root_warning=new FXCheckButton (group,_("Warn if running as root"));

	FXbool confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
	quit->setCheck(confirm_quit);
    FXbool confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
	del->setCheck(confirm_del);
    FXbool confirm_del_emptydir=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete_emptydir",TRUE);
	del_emptydir->setCheck(confirm_del_emptydir);
    FXbool confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
	overwrite->setCheck(confirm_overwrite);
    FXbool ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
	ask->setCheck(ask_before_copy);
    FXbool confirm_dnd=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_drag_and_drop",TRUE);
	dnd->setCheck(confirm_dnd);

#if defined(linux)
	FXbool mount_warn=getApp()->reg().readUnsignedEntry("OPTIONS","mount_warn",TRUE);
	FXbool mount_messages=getApp()->reg().readUnsignedEntry("OPTIONS","mount_messages",TRUE);
	mount->setCheck(mount_warn);
	show_mount->setCheck(mount_messages);
#endif

	FXbool root_warn=getApp()->reg().readUnsignedEntry("OPTIONS","root_warn",TRUE);
	if(getuid()) // Simple user
        root_warning->disable();
    else
        root_warning->setCheck(root_warn);

	// Third tab - Programs
    new FXTabItem(tabbook,_("&Programs"),NULL);
    FXVerticalFrame *programs=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    group=new FXGroupBox(programs,_("Default programs"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    matrix = new FXMatrix(group,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    new FXLabel(matrix,_("Text editor:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    txteditor = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_TXTEDIT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldtxteditor=getApp()->reg().readStringEntry("PROGS","txteditor",DEFAULT_TXTEDITOR);
    txteditor->setText(oldtxteditor);

	new FXLabel(matrix,_("Text viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    txtviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_TXTVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldtxtviewer=getApp()->reg().readStringEntry("PROGS","txtviewer",DEFAULT_TXTVIEWER);
    txtviewer->setText(oldtxtviewer);

	new FXLabel(matrix,_("Image editor:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    imgeditor = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_IMGVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldimgeditor=getApp()->reg().readStringEntry("PROGS","imgeditor",DEFAULT_IMGEDITOR);
    imgeditor->setText(oldimgeditor);

	new FXLabel(matrix,_("Image viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    imgviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_IMGVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldimgviewer=getApp()->reg().readStringEntry("PROGS","imgviewer",DEFAULT_IMGVIEWER);
    imgviewer->setText(oldimgviewer);

	new FXLabel(matrix,_("Archiver:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    archiver = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_ARCHIVER,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldarchiver=getApp()->reg().readStringEntry("PROGS","archiver",DEFAULT_ARCHIVER);
    archiver->setText(oldarchiver);

	new FXLabel(matrix,_("Pdf viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    pdfviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_PDFVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldpdfviewer=getApp()->reg().readStringEntry("PROGS","pdfviewer",DEFAULT_PDFVIEWER);
    pdfviewer->setText(oldpdfviewer);

	new FXLabel(matrix,_("Audio player:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    audioviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_AUDIOVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldaudioviewer=getApp()->reg().readStringEntry("PROGS","audioviewer",DEFAULT_AUDIOVIEWER);
    audioviewer->setText(oldaudioviewer);

	new FXLabel(matrix,_("Video player:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    videoviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_VIDEOVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldvideoviewer=getApp()->reg().readStringEntry("PROGS","videoviewer",DEFAULT_VIDEOVIEWER);
    videoviewer->setText(oldvideoviewer);

	new FXLabel(matrix,_("Terminal:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    xterm = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_XTERM,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldxterm=getApp()->reg().readStringEntry("PROGS","xterm",DEFAULT_TERMINAL);
    xterm->setText(oldxterm);

	// Fourth tab - Visual
    new FXTabItem(tabbook,_("&Themes"),NULL);
    FXVerticalFrame *visual=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *themes=new FXGroupBox(visual,_("Color theme"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXPacker *pack = new FXPacker(themes,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
    themesList = new FXList(pack,this,ID_THEME,LIST_BROWSESELECT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    themesList->setNumVisible(7);
	for(int i=0;i<THEMES_NUM;i++)
        themesList->appendItem(Themes[i].name);
    themesList->setCurrentItem(0);

    FXGroupBox *colors=new FXGroupBox(visual,_("Custom colors"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
	FXMatrix *matrix3 = new FXMatrix(colors,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    colorsBox = new FXComboBox(matrix3,COLORS_NUM,NULL,0,COMBOBOX_STATIC|FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_SIDE_RIGHT|LAYOUT_CENTER_Y);
  	colorsBox->setNumVisible(COLORS_NUM);
  	cwell=new FXColorWell(matrix3,FXRGB(0,0,0),this,ID_COLOR,LAYOUT_FILL_X|LAYOUT_FILL_COLUMN|LAYOUT_FILL_Y,0,0,0,0, 10,10,0,0);
  	cwell->setTipText(_("Double click to customize the color"));

    colorsBox->appendItem(_("Base color"));
    colorsBox->appendItem(_("Border color"));
    colorsBox->appendItem(_("Background color"));
    colorsBox->appendItem(_("Foreground color"));
    colorsBox->appendItem(_("Selection background color"));
    colorsBox->appendItem(_("Selection foreground color"));
    colorsBox->appendItem(_("File list background color"));
    colorsBox->appendItem(_("File list foreground color"));
	colorsBox->appendItem(_("File list highlight color"));
    colorsBox->setCurrentItem(0);

	FXGroupBox *button=new FXGroupBox(visual,_("Controls"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    controls=new FXCheckButton(button,_("Gradient effect and rounded corners")); 
	FXbool roundedgradient=getApp()->reg().readUnsignedEntry("SETTINGS","rounded_gradient",TRUE);
	controls->setCheck(roundedgradient);

	// Find iconpath from the Xfe registry settings or set it to DEFAULTICONPATH
	FXGroupBox *group2=new FXGroupBox(visual,_("Icon theme path"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
	FXMatrix *matrix2 = new FXMatrix(group2,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	iconpath = new FXTextField(matrix2,40,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix2,_("\tSelect path..."),filedialogicon,this,ID_BROWSE_ICON_PATH,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
	oldiconpath=getApp()->reg().readStringEntry("SETTINGS","iconpath",DEFAULTICONPATH);
    iconpath->setText(oldiconpath);

    // Fifth tab - Fonts
    new FXTabItem(tabbook,_("&Fonts"),NULL);
    FXVerticalFrame *fonts=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *fgroup=new FXGroupBox(fonts,_("Fonts"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    FXMatrix *fmatrix = new FXMatrix(fgroup,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(fmatrix,_("Normal font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    normalfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(fmatrix,_(" Select..."),NULL,this,ID_NORMALFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldnormalfont=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
    normalfont->setText(oldnormalfont);

    new FXLabel(fmatrix,_("Text font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    textfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(fmatrix,_(" Select..."),NULL,this,ID_TEXTFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//0,0,0,0,20,20);
    oldtextfont=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
    textfont->setText(oldtextfont);
}


long PreferencesBox::onUpdColor(FXObject* o,FXSelector s,void* p)
{
    FXColorWell *cwell = (FXColorWell*)o;
    int i = colorsBox->getCurrentItem();
    cwell->setRGBA(currTheme.color[i]);

    return 1;
}


long PreferencesBox::onCmdColor(FXObject* o,FXSelector s,void* p)
{
	FXColorWell *cwell = (FXColorWell*)o;
    int i = colorsBox->getCurrentItem();
    currTheme.color[i] = cwell->getRGBA();
    
    return 1;
}


long PreferencesBox::onCmdTheme(FXObject* o,FXSelector s,void* p)
{
    currTheme = Themes[themesList->getCurrentItem()];
    return 1;
}


long PreferencesBox::onCmdBrowsePath(FXObject* o,FXSelector s,void* p)
{
	FileDialog browse(this,_("Select an icon theme folder or an icon file"));
	browse.setSelectMode(SELECT_FILE_MIXED);
	browse.setDirectory(iconpath->getText());
	if(browse.execute())
	{
		FXString path=browse.getFilename();
		if (::isFile(path))
			iconpath->setText(FXPath::directory(path).text());
		else
			iconpath->setText(path);
	}
	return 1;
}


long PreferencesBox::onCmdBrowse(FXObject* o,FXSelector s,void* p)
{
    FileDialog browse(this,_("Select an executable file"));
    const FXchar *patterns[]=
        {
            _("All files"),     "*",NULL
        };
	browse.setFilename(ROOTDIR);
	browse.setPatternList(patterns);
	browse.setSelectMode(SELECT_FILE_EXISTING);
    if(browse.execute())
    {
        char *path=strdup(browse.getFilename().text());
        switch(FXSELID(s))
        {
        case ID_BROWSE_TXTEDIT:
            txteditor->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_TXTVIEW:
            txtviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_IMGVIEW:
            imgviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_ARCHIVER:
            archiver->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_PDFVIEW:
            pdfviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_AUDIOVIEW:
            audioviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_VIDEOVIEW:
            videoviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_XTERM:
            xterm->setText(FXPath::name(path).text());
            break;
        }
    }
    return 1;
}

// Change normal font
long PreferencesBox::onCmdNormalFont(FXObject*,FXSelector,void*)
{
    FontDialog fontdlg(this,_("Change Normal Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;

	fontspec=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
   	FXFont* nfont=new FXFont(getApp(),fontspec);
	nfont->create();
	nfont->getFontDesc(fontdesc);
    
	fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		nfont->setFontDesc(fontdesc);
		fontspec=nfont->getFont();
        normalfont->setText(fontspec);  
    }
    return 1;
}

// Change text font
long PreferencesBox::onCmdTextFont(FXObject*,FXSelector,void*)
{
    FontDialog fontdlg(this,_("Change Text Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;
	fontspec=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
   	FXFont* tfont=new FXFont(getApp(),fontspec);
	tfont->create();
	tfont->getFontDesc(fontdesc);
    fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		tfont->setFontDesc(fontdesc);
		fontspec=tfont->getFont();
        textfont->setText(fontspec);
    }
    return 1;
}

long PreferencesBox::onCmdAccept(FXObject* o,FXSelector s,void* p)
{
    FXbool restart_theme=FALSE;
    FXbool restart_scroll=FALSE;
    FXbool restart_pathlink=FALSE;
    FXbool restart_controls=FALSE;
    FXbool restart_normalfont=FALSE;
    FXbool restart_textfont=FALSE;
	
	if (iconpath->getText()=="")
		iconpath->setText(oldiconpath);

	// Icon path has changed
	if(oldiconpath != iconpath->getText())
	{
		getApp()->reg().writeStringEntry("SETTINGS","iconpath",iconpath->getText().text());
 		getApp()->reg().write();
		restart_theme=TRUE;
	}
	
	// Normal font has changed
	if (oldnormalfont != normalfont->getText())
	{
		getApp()->reg().writeStringEntry("SETTINGS","font",normalfont->getText().text());
		getApp()->reg().write();
		restart_normalfont=TRUE;
	}

	// Text font has changed
	if (oldtextfont != textfont->getText())
	{
		getApp()->reg().writeStringEntry("SETTINGS","textfont",textfont->getText().text());
		getApp()->reg().write();
		restart_textfont=TRUE;
	}

    // Text editor has changed
	if(oldtxteditor != txteditor->getText())
	{
        // Update the txteditor string
		FXString newtxteditor=txteditor->getText().text();
		getApp()->reg().writeStringEntry("PROGS","txteditor",newtxteditor.text());
		
		// Update each filetype where the old txteditor was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old txteditor string with the new one
			if (value.contains(oldtxteditor))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the open and edit strings, if needed
				if (open==oldtxteditor)
					open=newtxteditor;
				if (edit==oldtxteditor)
					edit=newtxteditor;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Text viewer has changed
	if(oldtxtviewer != txtviewer->getText())
	{
        // Update the txtviewer string
		FXString newtxtviewer=txtviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","txtviewer",newtxtviewer.text());
		
		// Update each filetype where the old txtviewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old txtviewer string with the new one
			if (value.contains(oldtxtviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the view string, if needed
				if (view==oldtxtviewer)
					view=newtxtviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Image editor has changed
	if(oldimgeditor != imgeditor->getText())
	{
        // Update the imgeditor string
		FXString newimgeditor=imgeditor->getText().text();
		getApp()->reg().writeStringEntry("PROGS","imgeditor",newimgeditor.text());
		
		// Update each filetype where the old imgeditor was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old imgeditor string with the new one
			if (value.contains(oldimgeditor))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the open and edit strings, if needed
				if (open==oldimgeditor)
					open=newimgeditor;
				if (edit==oldimgeditor)
					edit=newimgeditor;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Image viewer has changed
	if(oldimgviewer != imgviewer->getText())
	{
        // Update the imgviewer string
		FXString newimgviewer=imgviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","imgviewer",newimgviewer.text());
		
		// Update each filetype where the old imgviewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old imgviewer string with the new one
			if (value.contains(oldimgviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the view string, if needed
				if (view==oldimgviewer)
					view=newimgviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Archiver has changed
	if(oldarchiver != archiver->getText())
	{
        // Update the archiver string
		FXString newarchiver=archiver->getText().text();
		getApp()->reg().writeStringEntry("PROGS","archiver",newarchiver.text());
		
		// Update each filetype where the old archiver was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old archiver string with the new one
			if (value.contains(oldarchiver))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace the open, view and edit strings, if needed
				if (open==oldarchiver)
					open=newarchiver;
				if (view==oldarchiver)
					view=newarchiver;
				if (edit==oldarchiver)
					edit=newarchiver;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // PDF viewer has changed
	if(oldpdfviewer != pdfviewer->getText())
	{
        // Update the PDF viewer string
		FXString newpdfviewer=pdfviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","pdfviewer",newpdfviewer.text());
		
		// Update each filetype where the old PDF viewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old PDF viewer string with the new one
			if (value.contains(oldpdfviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace the open, view and edit strings, if needed
				if (open==oldpdfviewer)
					open=newpdfviewer;
				if (view==oldpdfviewer)
					view=newpdfviewer;
				if (edit==oldpdfviewer)
					edit=newpdfviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Audio viewer has changed
	if(oldaudioviewer != audioviewer->getText())
	{
        // Update the audio viewer string
		FXString newaudioviewer=audioviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","audioviewer",newaudioviewer.text());
		
		// Update each filetype where the old audio viewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old audio viewer string with the new one
			if (value.contains(oldaudioviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace the open, view and edit strings, if needed
				if (open==oldaudioviewer)
					open=newaudioviewer;
				if (view==oldaudioviewer)
					view=newaudioviewer;
				if (edit==oldaudioviewer)
					edit=newaudioviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Video viewer has changed
	if(oldvideoviewer != videoviewer->getText())
	{
        // Update the video viewer string
		FXString newvideoviewer=videoviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","videoviewer",newvideoviewer.text());
		
		// Update each filetype where the old video viewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old video viewer string with the new one
			if (value.contains(oldvideoviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace the open, view and edit strings, if needed
				if (open==oldvideoviewer)
					open=newvideoviewer;
				if (view==oldvideoviewer)
					view=newvideoviewer;
				if (edit==oldvideoviewer)
					edit=newvideoviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

	// Terminal has changed
	if(oldxterm != xterm->getText())
        getApp()->reg().writeStringEntry("PROGS","xterm",xterm->getText().text());

	getApp()->reg().writeUnsignedEntry("OPTIONS","auto_save_layout",autosave->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","use_trash_can",trashcan->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","use_trash_bypass",trashbypass->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","ask_before_copy",ask->getCheck());
    getApp()->reg().writeUnsignedEntry("SETTINGS","single_click",single_click);
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_delete",del->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_delete_emptydir",del_emptydir->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_overwrite",overwrite->getCheck());
	getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_quit",quit->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_drag_and_drop",dnd->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","root_warn",root_warning->getCheck());
    
#if defined(linux)
    getApp()->reg().writeUnsignedEntry("OPTIONS","mount_warn",mount->getCheck());
	getApp()->reg().writeUnsignedEntry("OPTIONS","mount_messages",show_mount->getCheck());
#endif

	// Smooth scrolling
	getApp()->reg().writeUnsignedEntry("SETTINGS","smooth_scroll",scroll->getCheck());
	if (scroll->getCheck()!=smoothscroll_prev)
	{
 		getApp()->reg().write();
		restart_scroll=TRUE;
	}
		
    // Controls
    getApp()->reg().writeUnsignedEntry("SETTINGS","rounded_gradient",controls->getCheck());
	if (controls->getCheck()!=controls_prev)
	{
 		getApp()->reg().write();
		restart_controls=TRUE;
	}

	// Update some global options
	if (diropen->getCheck() && fileopen->getCheck())
		single_click=SINGLE_CLICK_DIR_FILE;
	else if (diropen->getCheck() && !fileopen->getCheck())
		single_click=SINGLE_CLICK_DIR;
	else
		single_click=SINGLE_CLICK_NONE;
	
	if (single_click==SINGLE_CLICK_DIR_FILE)
	{
		((XFileExplorer*) mainWindow)->lpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
		((XFileExplorer*) mainWindow)->rpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
		((XFileExplorer*) mainWindow)->dirpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
	}
	else
	{
		((XFileExplorer*) mainWindow)->lpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
		((XFileExplorer*) mainWindow)->rpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
		((XFileExplorer*) mainWindow)->dirpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
	}
   
	// Update the file tooltips flag
	if (filetooltips->getCheck())
		file_tooltips=TRUE;
	else
		file_tooltips=FALSE;
	getApp()->reg().writeUnsignedEntry("SETTINGS","file_tooltips",(FXuint)file_tooltips);

	// Update the relative resize flag
	if (relativeresize->getCheck())
		relative_resize=TRUE;
	else
		relative_resize=FALSE;
	getApp()->reg().writeUnsignedEntry("SETTINGS","relative_resize",(FXuint)relative_resize);

	// Update the display path linker flag
	show_pathlink=showpathlink->getCheck();
	getApp()->reg().writeUnsignedEntry("SETTINGS","show_pathlinker",show_pathlink);
	if (show_pathlink!=show_pathlink_prev)
	{
 		getApp()->reg().write();
		restart_pathlink=TRUE;
	}

	// Theme has changed
	if(currTheme != Themes[0])
    {
		getApp()->reg().writeColorEntry("SETTINGS","basecolor",currTheme.color[0]);
        getApp()->reg().writeColorEntry("SETTINGS","bordercolor",currTheme.color[1]);
        getApp()->reg().writeColorEntry("SETTINGS","backcolor",currTheme.color[2]);
        getApp()->reg().writeColorEntry("SETTINGS","forecolor",currTheme.color[3]);
        getApp()->reg().writeColorEntry("SETTINGS","selbackcolor",currTheme.color[4]);
        getApp()->reg().writeColorEntry("SETTINGS","selforecolor",currTheme.color[5]);
		getApp()->reg().writeColorEntry("SETTINGS","listbackcolor",currTheme.color[6]);
		getApp()->reg().writeColorEntry("SETTINGS","listforecolor",currTheme.color[7]);
		getApp()->reg().writeColorEntry("SETTINGS","highlightcolor",currTheme.color[8]);

		getApp()->reg().write();
        restart_theme=TRUE;
    }
	
	// Restart application if necessary
	if (restart_scroll)
	{
		if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Scrolling mode will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}
	if (restart_theme)
	{
		if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Theme will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}
	
	if (restart_pathlink)
	{
		if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Path linker will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}

	if (restart_controls)
	{
		if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Button style will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}

	if (restart_normalfont)
	{
        if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Normal font will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}

	if (restart_textfont)
	{
        if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Text font will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}

	// Finally, update the registry
	getApp()->reg().write();
		
    DialogBox::onCmdAccept(o,s,p);
    return 1;
}


long PreferencesBox::onCmdCancel(FXObject* o,FXSelector s,void* p)
{
	// Reset preferences to their previous values
	
	// First tab - Options
	trashcan->setCheck(trashcan_prev);
	trashbypass->setCheck(trashbypass_prev);
	autosave->setCheck(autosave_prev);
	diropen->setCheck(diropen_prev);
	fileopen->setCheck(fileopen_prev);
	filetooltips->setCheck(filetooltips_prev);
	relativeresize->setCheck(relativeresize_prev);
	showpathlink->setCheck(show_pathlink_prev);
	getApp()->setWheelLines(value_prev);	
	use_sudo=use_sudo_prev;
	getApp()->reg().writeUnsignedEntry("OPTIONS","use_sudo",use_sudo);
	scroll->setCheck(smoothscroll_prev);
	
	// Second tab - Dialogs
	ask->setCheck(ask_prev);
	dnd->setCheck(dnd_prev);
	del->setCheck(del_prev);
	del_emptydir->setCheck(del_emptydir_prev);
	overwrite->setCheck(overwrite_prev);
	quit->setCheck(quit_prev);
#if defined(linux)
	mount->setCheck(mount_prev);
	show_mount->setCheck(show_mount_prev);
#endif
	root_warning->setCheck(root_warning_prev);
	
	// Third tab - Programs
	txteditor->setText(oldtxteditor);	
	txtviewer->setText(oldtxtviewer);	
	imgeditor->setText(oldimgeditor);	
	imgviewer->setText(oldimgviewer);	
	archiver->setText(oldarchiver);	
	pdfviewer->setText(oldpdfviewer);	
	audioviewer->setText(oldaudioviewer);	
	videoviewer->setText(oldvideoviewer);	
	xterm->setText(oldxterm);

	// Fourth tab - Visual
    themesList->setCurrentItem(themelist_prev);
	currTheme=currTheme_prev;
    iconpath->setText(oldiconpath);
	controls->setCheck(controls_prev);

	// Fifth tab - Fonts
	normalfont->setText(oldnormalfont);
	textfont->setText(oldtextfont);

	// Finally, update the registry (really necessary?)
	getApp()->reg().write();
	
    DialogBox::onCmdCancel(o,s,p);
    return 1;
}


// Execute dialog box modally
FXuint PreferencesBox::execute(FXuint placement)
{
	// Save current preferences to restore them if cancel is pressed
	
	// First tab - Options
	trashcan_prev=trashcan->getCheck();
	trashbypass_prev=trashbypass->getCheck();
	autosave_prev=autosave->getCheck();
	diropen_prev=diropen->getCheck();
	fileopen_prev=fileopen->getCheck();
	filetooltips_prev=filetooltips->getCheck();
	relativeresize_prev=relativeresize->getCheck();
	show_pathlink_prev=showpathlink->getCheck();
	value_prev=getApp()->getWheelLines();
	use_sudo_prev=use_sudo;
	smoothscroll_prev=scroll->getCheck();
	
	// Second tab - Dialogs
	ask_prev=ask->getCheck();
	dnd_prev=dnd->getCheck();
	del_prev=del->getCheck();
	del_emptydir_prev=del_emptydir->getCheck();
	overwrite_prev=overwrite->getCheck();
	quit_prev=quit->getCheck();
#if defined(linux)
	mount_prev=mount->getCheck();
	show_mount_prev=show_mount_prev;
#endif
	root_warning_prev=root_warning->getCheck();

    // Third tab - Programs
	oldtxteditor=txteditor->getText();
	oldtxtviewer=txtviewer->getText();
	oldimgeditor=imgeditor->getText();
	oldimgviewer=imgviewer->getText();
	oldarchiver=archiver->getText();
	oldpdfviewer=pdfviewer->getText();
	oldaudioviewer=audioviewer->getText();
	oldvideoviewer=videoviewer->getText();
	oldxterm=xterm->getText();
	
	// Fourth tab - Visual
	themelist_prev=themesList->getCurrentItem();
    currTheme_prev = currTheme;
    oldiconpath=iconpath->getText();
    controls_prev=controls->getCheck();
	
	// Fifth tab - Fonts
	oldnormalfont=normalfont->getText();
	oldtextfont=textfont->getText();

	create();
    show(placement);
	getApp()->refresh();
    return getApp()->runModalFor(this);
}


// Update the bypass trash can option item
long PreferencesBox::onUpdTrashBypass(FXObject* o,FXSelector,void*)
{
	if (trashcan->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


// Update the confirm delete empty directories option item
long PreferencesBox::onUpdConfirmDelEmptyDir(FXObject* o,FXSelector,void*)
{
	if (del->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


// Set root mode
long PreferencesBox::onCmdSuMode(FXObject*,FXSelector sel,void*)
{
	if (FXSELID(sel)==ID_SU_CMD)
		use_sudo=FALSE;
		
	else if (FXSELID(sel)==ID_SUDO_CMD)
		use_sudo=TRUE;

	getApp()->reg().writeUnsignedEntry("OPTIONS","use_sudo",use_sudo);
	getApp()->reg().write();

	return 1;
}


// Update root mode radio button
long PreferencesBox::onUpdSuMode(FXObject* sender,FXSelector sel,void*)
{
	FXSelector updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);
	
	if (FXSELID(sel)==ID_SU_CMD)
	{
		if (use_sudo)
			updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);
		else
			updatemessage=FXSEL(SEL_COMMAND,ID_CHECK);
	}
	else if (FXSELID(sel)==ID_SUDO_CMD)
	{
		if (use_sudo)
			updatemessage=FXSEL(SEL_COMMAND,ID_CHECK);
		else
			updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);

	}		
	sender->handle(this,updatemessage,NULL);
	return 1;
}

// Set scroll wheel lines (Mathew Robertson <mathew@optushome.com.au>)
long PreferencesBox::onCmdWheelAdjust(FXObject* sender,FXSelector,void*)
{
    FXuint value;
    sender->handle(this,FXSEL(SEL_COMMAND,ID_GETINTVALUE),(void*)&value);
    getApp()->setWheelLines(value);
	getApp()->reg().write();
    return 1;
}


// Update the wheel lines button
long PreferencesBox::onUpdWheelAdjust(FXObject* sender,FXSelector,void*)
{
    FXuint value=getApp()->getWheelLines();
	sender->handle(this,FXSEL(SEL_COMMAND,ID_SETINTVALUE),(void*)&value);
    return 1;
}


// Update single click file open button
long PreferencesBox::onUpdSingleClickFileopen(FXObject* o,FXSelector,void*)
{
	if (diropen->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
	{
		fileopen->setCheck(FALSE);
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
	}
    return 1;
}

