/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN
 *
 *	$Id: wsetname_f.c,v 1.1.2.1 2002/10/09 19:49:37 brbarret Exp $
 *
 *	Function:	- MPI_Win_set_name F77 wrapper
 */

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void 
mpi_win_set_name_(w, n, ierr, nn)

int			*w, *ierr;
char			*n;
int 			nn;

{
	char		*name;

	name = lam_F2C_string(n, nn);
	if (name == 0) {
		lam_setfunc(BLKMPIWINSETNAME);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPIWINSETNAME,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Win_set_name(GETHDL(*w), name);

	free(name);
}
